/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.npc.features;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.api.registry.NPCFeature;
import io.github.flemmli97.runecraftory.api.registry.NPCFeatureType;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryNPCLooks;
import io.github.flemmli97.runecraftory.common.utils.StreamCodecUtils;
import io.github.flemmli97.tenshilib.common.utils.CodecUtils;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.class_2960;
import net.minecraft.class_5699;
import net.minecraft.class_9139;

public record CustomModelFeatureType(List<Pair<class_2960, List<class_2960>>> models, Location location) implements NPCFeature.NPCFeatureHolder<ModelFeature>
{
    private static final Codec<Pair<class_2960, List<class_2960>>> VALUE_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("model").forGetter(Pair::getFirst), (App)class_5699.method_36973((Codec)class_2960.field_25139.listOf()).fieldOf("textures").forGetter(Pair::getSecond)).apply((Applicative)instance, Pair::of));
    public static final MapCodec<CustomModelFeatureType> TYPE_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_5699.method_36973((Codec)VALUE_CODEC.listOf()).fieldOf("models").forGetter(CustomModelFeatureType::models), (App)CodecUtils.stringEnumCodec(Location.class, null).fieldOf("location").forGetter(CustomModelFeatureType::location)).apply((Applicative)instance, CustomModelFeatureType::new));
    public static MapCodec<ModelFeature> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_2960.field_25139.fieldOf("model").forGetter(ModelFeature::model), (App)class_2960.field_25139.fieldOf("model").forGetter(ModelFeature::texture), (App)CodecUtils.stringEnumCodec(Location.class, null).fieldOf("location").forGetter(ModelFeature::location)).apply((Applicative)instance, ModelFeature::new));
    public static final class_9139<ByteBuf, ModelFeature> STREAM_CODEC = class_9139.method_56436((class_9139)class_2960.field_48267, ModelFeature::model, (class_9139)class_2960.field_48267, ModelFeature::texture, StreamCodecUtils.ofEnum(Location.class), ModelFeature::location, ModelFeature::new);

    @Override
    public ModelFeature create(NPCEntity npc) {
        if (this.models.isEmpty()) {
            throw new IllegalStateException("No models defined!");
        }
        Pair<class_2960, List<class_2960>> selected = this.models.get(npc.method_59922().method_43048(this.models.size()));
        return new ModelFeature((class_2960)selected.getFirst(), (class_2960)((List)selected.getSecond()).get(npc.method_59922().method_43048(((List)selected.getSecond()).size())), this.location());
    }

    @Override
    public NPCFeatureType<ModelFeature> getType() {
        return (NPCFeatureType)RuneCraftoryNPCLooks.MODEL.get();
    }

    public static enum Location {
        HEAD,
        BODY,
        LEFT_ARM,
        RIGHT_ARM,
        LEFT_LEG,
        RIGHT_LEG;

    }

    public record ModelFeature(class_2960 model, class_2960 texture, Location location) implements NPCFeature
    {
        public NPCFeatureType<ModelFeature> type() {
            return (NPCFeatureType)RuneCraftoryNPCLooks.MODEL.get();
        }
    }
}

