/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.items.weapons;

import io.github.flemmli97.runecraftory.api.registry.ArmorEffect;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.api.registry.action.AttackAction;
import io.github.flemmli97.runecraftory.common.components.StaffData;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryArmorEffects;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttackActions;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryDataComponentTypes;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.common.item.ExtendedWeapon;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2767;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_6880;
import net.minecraft.class_9331;

public class ItemStaffBase
extends class_1792
implements ExtendedWeapon {
    public final ItemElement startElement;
    public final int amount;

    public ItemStaffBase(ItemElement startElement, int amount, class_1792.class_1793 props) {
        super(props);
        this.startElement = startElement;
        this.amount = Math.max(1, amount);
    }

    public int getStaffChargeTime(class_1309 entity, class_1799 stack) {
        int time = ((StaffData)stack.method_57825((class_9331)RuneCraftoryDataComponentTypes.STAFF.get(), (Object)StaffData.DEFAULT)).chargeTime();
        if (ArmorEffect.hasArmorEffect(entity, (class_6880<ArmorEffect>)RuneCraftoryArmorEffects.MAGIC_RING.asHolder())) {
            time = (int)((double)time * 0.75);
        }
        return time;
    }

    public int chargeAmount(class_1799 stack) {
        return ((StaffData)stack.method_57825((class_9331)RuneCraftoryDataComponentTypes.STAFF.get(), (Object)StaffData.DEFAULT)).getChargeLevel();
    }

    public void executeAttack(class_1657 player, class_1799 stack) {
        Platform.INSTANCE.getPlayerData(player).getWeaponHandler().doWeaponAttack((AttackAction)RuneCraftoryAttackActions.STAFF.get(), stack);
    }

    public boolean attackOnBlock(class_1309 entity, class_1799 stack) {
        return true;
    }

    public void method_7852(class_1937 level, class_1309 livingEntity, class_1799 stack, int remainingUseDuration) {
        if (livingEntity instanceof class_3222) {
            class_3222 player = (class_3222)livingEntity;
            int duration = stack.method_7935(livingEntity) - remainingUseDuration;
            if (duration > 0 && duration / this.getStaffChargeTime(livingEntity, stack) <= this.chargeAmount(stack) && duration % this.getStaffChargeTime(livingEntity, stack) == 0) {
                player.field_13987.method_14364((class_2596)new class_2767((class_6880)class_3417.field_14776, player.method_5634(), player.method_23317(), player.method_23318(), player.method_23321(), 1.0f, 1.0f, player.method_59922().method_43055()));
            }
        }
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (hand == class_1268.field_5810) {
            return class_1271.method_22431((Object)stack);
        }
        if (this.chargeAmount(stack) > 0) {
            if (!level.field_9236) {
                if (this.getStaffChargeTime((class_1309)player, stack) <= 0) {
                    int chargeLevel = Math.min(3, this.chargeAmount(stack));
                    Spell spell = ((StaffData)stack.method_57825((class_9331)RuneCraftoryDataComponentTypes.STAFF.get(), (Object)StaffData.DEFAULT)).fromChargeLevel(stack, chargeLevel);
                    if (spell != null && player instanceof class_3222) {
                        class_3222 serverPlayer = (class_3222)player;
                        Platform.INSTANCE.getPlayerData((class_1657)serverPlayer).getWeaponHandler().doWeaponAttack((AttackAction)RuneCraftoryAttackActions.STAFF_USE.get(), stack, spell);
                    }
                } else {
                    player.method_6019(hand);
                }
            }
            return class_1271.method_22428((Object)stack);
        }
        return class_1271.method_22430((Object)stack);
    }

    public void method_7840(class_1799 stack, class_1937 level, class_1309 entity, int timeLeft) {
        if (!level.field_9236) {
            int tier = (stack.method_7935(entity) - timeLeft - 1) / this.getStaffChargeTime(entity, stack);
            int chargeLevel = Math.min(tier, this.chargeAmount(stack));
            Spell spell = ((StaffData)stack.method_57825((class_9331)RuneCraftoryDataComponentTypes.STAFF.get(), (Object)StaffData.DEFAULT)).fromChargeLevel(stack, chargeLevel);
            if (spell != null) {
                if (entity instanceof class_3222) {
                    class_3222 player = (class_3222)entity;
                    Platform.INSTANCE.getPlayerData((class_1657)player).getWeaponHandler().doWeaponAttack((AttackAction)RuneCraftoryAttackActions.STAFF_USE.get(), stack, spell);
                    return;
                }
                spell.use((class_3218)level, entity, stack);
            }
        }
    }

    public boolean method_7885(class_2680 state, class_1937 level, class_2338 pos, class_1657 player) {
        return !player.method_7337();
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    public int method_7881(class_1799 stack, class_1309 entity) {
        return 72000;
    }

    public boolean method_7870(class_1799 stack) {
        return false;
    }
}

