/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.network;

import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import io.github.flemmli97.runecraftory.platform.Platform;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public class C2SNPCInteraction
implements class_8710 {
    public static final class_8710.class_9154<C2SNPCInteraction> TYPE = new class_8710.class_9154(RuneCraftory.modRes("c2s_npc_interaction"));
    public static final class_9139<class_9129, C2SNPCInteraction> STREAM_CODEC = new class_9139<class_9129, C2SNPCInteraction>(){

        public C2SNPCInteraction decode(class_9129 buf) {
            return new C2SNPCInteraction(buf.readInt(), (Action)buf.method_10818(Action.class), buf.method_19772());
        }

        public void encode(class_9129 buf, C2SNPCInteraction pkt) {
            buf.method_53002(pkt.id);
            buf.method_10817((Enum)pkt.type);
            buf.method_10814(pkt.action);
        }
    };
    private final int id;
    private final Action type;
    private final String action;

    public C2SNPCInteraction(int entityID, Action type) {
        this(entityID, type, "");
    }

    public C2SNPCInteraction(int entityID, String action) {
        this(entityID, Action.ACTION, action);
    }

    public C2SNPCInteraction(int entityID, Action type, String action) {
        this.id = entityID;
        this.type = type;
        this.action = action == null ? "" : action;
    }

    public static void handle(C2SNPCInteraction pkt, class_3222 sender) {
        class_1297 entity = sender.method_37908().method_8469(pkt.id);
        if (entity instanceof NPCEntity) {
            NPCEntity npc = (NPCEntity)entity;
            switch (pkt.type.ordinal()) {
                case 0: {
                    npc.talkTo(sender);
                    break;
                }
                case 1: {
                    PlayerData data = Platform.INSTANCE.getPlayerData((class_1657)sender);
                    if (!data.party.isPartyMember(entity) && data.party.isPartyFull()) {
                        sender.method_7353((class_2561)class_2561.method_43471((String)"runecraftory.monster.interact.party.full"), true);
                        return;
                    }
                    if (npc.getEntityToFollowUUID() != null) break;
                    npc.followEntity(sender);
                    break;
                }
                case 2: {
                    if (npc.getEntityToFollowUUID() == null || !npc.getEntityToFollowUUID().equals(sender.method_5667())) break;
                    npc.setBehaviour(NPCEntity.Behaviour.FOLLOW_DISTANCE);
                    break;
                }
                case 3: {
                    if (npc.getEntityToFollowUUID() == null || !npc.getEntityToFollowUUID().equals(sender.method_5667())) break;
                    npc.setBehaviour(NPCEntity.Behaviour.STAY);
                    break;
                }
                case 4: {
                    if (npc.getEntityToFollowUUID() == null || !npc.getEntityToFollowUUID().equals(sender.method_5667())) break;
                    npc.followEntity(null);
                    break;
                }
                case 5: {
                    npc.openShopForPlayer(sender);
                    break;
                }
                case 8: {
                    npc.respondToQuest(sender, class_2960.method_60654((String)pkt.action));
                    break;
                }
                case 6: {
                    npc.closedDialogue(sender);
                    break;
                }
                case 7: {
                    npc.closedQuestDialogue(sender);
                    break;
                }
                case 9: {
                    if (npc.method_6109()) break;
                    npc.getProfession().handleAction(npc, (class_1657)sender, pkt.action);
                }
            }
        }
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    public static enum Action {
        TALK("runecraftory.gui.npc.talk", null),
        FOLLOW("runecraftory.gui.npc.follow", NPCEntity.Behaviour.FOLLOW),
        FOLLOWDISTANCE("runecraftory.gui.npc.distance", NPCEntity.Behaviour.FOLLOW_DISTANCE),
        STAY("runecraftory.gui.npc.stay", NPCEntity.Behaviour.STAY),
        STOPFOLLOW("runecraftory.gui.npc.stopFollow", NPCEntity.Behaviour.WANDER),
        SHOP("runecraftory.gui.npc.shop", null),
        CLOSE("runecraftory.gui.npc.close", null),
        CLOSE_QUEST("runecraftory.gui.npc.close.quest", null),
        QUEST("runecraftory.gui.quest.button", null),
        ACTION("", null);

        public final String translation;
        @Nullable
        public final NPCEntity.Behaviour behaviour;

        private Action(String translation, NPCEntity.Behaviour behaviour) {
            this.translation = translation;
            this.behaviour = behaviour;
        }
    }
}

