/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.quests;

import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import io.github.flemmli97.runecraftory.common.network.S2COpenQuestGui;
import io.github.flemmli97.runecraftory.common.quests.ClientSideQuestDisplay;
import io.github.flemmli97.runecraftory.common.quests.NPCQuest;
import io.github.flemmli97.runecraftory.common.quests.QuestData;
import io.github.flemmli97.runecraftory.common.quests.progress.NPCTalkTracker;
import io.github.flemmli97.runecraftory.common.quests.progress.ShippingTracker;
import io.github.flemmli97.runecraftory.common.quests.progress.TamingTracker;
import io.github.flemmli97.runecraftory.common.quests.tasks.LevelTask;
import io.github.flemmli97.runecraftory.common.quests.tasks.NPCTalkTask;
import io.github.flemmli97.runecraftory.common.quests.tasks.ShippingTask;
import io.github.flemmli97.runecraftory.common.quests.tasks.SkillLevelTask;
import io.github.flemmli97.runecraftory.common.quests.tasks.TamingTask;
import io.github.flemmli97.runecraftory.common.world.data.RunecraftorySavedData;
import io.github.flemmli97.runecraftory.mixinhelper.QuestDataGet;
import io.github.flemmli97.simplequests_api.datapack.QuestsManager;
import io.github.flemmli97.simplequests_api.player.PlayerQuestData;
import io.github.flemmli97.simplequests_api.player.QuestProgress;
import io.github.flemmli97.simplequests_api.quest.QuestBase;
import io.github.flemmli97.simplequests_api.quest.QuestState;
import io.github.flemmli97.simplequests_api.registry.PlayerQuestDataRegistry;
import io.github.flemmli97.simplequests_api.registry.ProgressionTrackerRegistry;
import io.github.flemmli97.simplequests_api.registry.QuestBaseRegistry;
import io.github.flemmli97.simplequests_api.registry.QuestEntryRegistry;
import io.github.flemmli97.tenshilib.loader.LoaderNetwork;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;

public class QuestHandler {
    public static final class_2960 QUEST_CATEGORY = RuneCraftory.modRes("quests");
    public static final class_2960 QUEST_CONTEXT = RuneCraftory.modRes("contexts");
    public static final String QUEST_BOARD_TRIGGER = "runecraftory_quest_board_trigger";

    public static void register() {
        QuestEntryRegistry.registerSerializer(ShippingTask.ID, ShippingTask.CODEC, ShippingTask.SkillLevelTaskResolved.CODEC);
        QuestEntryRegistry.registerSerializer(LevelTask.ID, LevelTask.CODEC, LevelTask.LevelTaskResolved.CODEC);
        QuestEntryRegistry.registerSerializer(SkillLevelTask.ID, SkillLevelTask.CODEC, SkillLevelTask.SkillLevelTaskResolved.CODEC);
        QuestEntryRegistry.registerSerializer(TamingTask.ID, TamingTask.CODEC, TamingTask.TamingTaskResolved.CODEC);
        QuestEntryRegistry.registerSerializer(NPCTalkTask.ID, NPCTalkTask.CODEC, NPCTalkTask.NPCTalkResolved.CODEC);
        QuestBaseRegistry.registerSerializer((class_2960)NPCQuest.ID, NPCQuest.CODEC);
        ProgressionTrackerRegistry.registerSerializer(ShippingTracker.KEY, ShippingTracker::new);
        ProgressionTrackerRegistry.registerSerializer(TamingTracker.KEY, TamingTracker::new);
        ProgressionTrackerRegistry.registerSerializer(NPCTalkTracker.KEY, NPCTalkTracker::new);
        PlayerQuestDataRegistry.registerFetcher((class_2960)RuneCraftory.modRes("quest_data"), QuestHandler::getData);
    }

    public static QuestData getData(class_3222 player) {
        return ((QuestDataGet)player).runecraftory$getQuestData();
    }

    public static void openGui(class_3222 player, class_243 at) {
        Map<class_2960, QuestBase> quest = QuestHandler.getQuestsFor(player, at);
        QuestData data = QuestHandler.getData(player);
        LoaderNetwork.INSTANCE.sendToPlayer((class_8710)new S2COpenQuestGui(false, quest.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(e -> {
            NPCQuest npcQuest;
            NPCEntity npc;
            List<class_5250> description = ((QuestBase)e.getValue()).getDescription(player);
            Object patt0$temp = e.getValue();
            if (patt0$temp instanceof NPCQuest && (npc = (npcQuest = (NPCQuest)((Object)((Object)patt0$temp))).getNpc(player.method_37908())) != null) {
                description = Stream.concat(Stream.of(class_2561.method_43469((String)"runecraftory.quest.npc.header", (Object[])new Object[]{npc.method_5477(), npc.method_24515().method_10263(), npc.method_24515().method_10264(), npc.method_24515().method_10260()}).method_27692(class_124.field_1065), class_2561.method_43473()), description.stream()).toList();
                return new ClientSideQuestDisplay((class_2960)e.getKey(), (class_2561)((QuestBase)e.getValue()).getName(player), description, npc.lookFeatures, npc.getLook().value().playerSkin(), data.isActive((class_2960)e.getKey()));
            }
            return new ClientSideQuestDisplay((class_2960)e.getKey(), (class_2561)((QuestBase)e.getValue()).getName(player), (List<? extends class_2561>)description, null, null, data.isActive((class_2960)e.getKey()));
        }).toList()), player);
        data.setQuestboardQuests(quest);
    }

    public static void acceptQuestRandom(class_3222 player, NPCEntity npc, class_2960 res) {
    }

    public static Map<class_2960, QuestBase> getQuestsFor(class_3222 player, class_243 at) {
        QuestData data = QuestHandler.getData(player);
        return Stream.concat(QuestsManager.instance().getQuestsForCategory(QUEST_CATEGORY, QUEST_CONTEXT).entrySet().stream().flatMap(e -> {
            Object patt0$temp = e.getValue();
            if (patt0$temp instanceof NPCQuest) {
                NPCQuest npcQuest = (NPCQuest)((Object)((Object)patt0$temp));
                return NPCQuest.resolve(npcQuest, player, at).stream();
            }
            return Stream.of(new NPCQuest[0]);
        }).filter(q -> data.canAcceptQuest((QuestBase)q, true) == QuestData.AcceptType.ACCEPT), data.getCurrentQuest().stream().map(QuestProgress::getQuest).filter(quest -> quest.category.id.equals((Object)QUEST_CATEGORY))).collect(Collectors.toMap(q -> q.id, q -> q, (e1, e2) -> e1, HashMap::new));
    }

    public static QuestState checkCompletionQuest(class_3222 player, NPCEntity npc) {
        QuestData data = QuestHandler.getData(player);
        return data.getCurrentQuest().stream().map(p -> p.tryComplete((PlayerQuestData)data, npc.method_5667().toString())).filter(s -> s != QuestState.NO).findFirst().orElse(QuestState.NO);
    }

    public static void removeQuestFor(class_3222 player, NPCEntity npc) {
        QuestData data = QuestHandler.getData(player);
        List<QuestProgress> toRemove = data.getCurrentQuest().stream().filter(p -> {
            QuestBase patt0$temp = p.getQuest();
            if (!(patt0$temp instanceof NPCQuest)) return false;
            NPCQuest npcQuest = (NPCQuest)patt0$temp;
            if (!npc.method_5667().equals(npcQuest.getNpcUuid())) return false;
            return true;
        }).toList();
        toRemove.forEach(p -> data.reset(p.getQuest().id));
    }

    public static void removeNPCQuestsFor(class_3222 player) {
        QuestData data = QuestHandler.getData(player);
        List<QuestProgress> toRemove = data.getCurrentQuest().stream().filter(p -> {
            NPCQuest npcQuest;
            QuestBase patt0$temp = p.getQuest();
            return patt0$temp instanceof NPCQuest && !RunecraftorySavedData.get((MinecraftServer)player.method_5682()).npcHandler.doesNPCExist((npcQuest = (NPCQuest)patt0$temp).getNpcUuid());
        }).toList();
        toRemove.forEach(p -> data.reset(p.getQuest().id));
    }

    public static class_2960 questForExists(class_3222 player, NPCEntity npc) {
        QuestData data = QuestHandler.getData(player);
        return data.getCurrentQuest().stream().filter(p -> {
            QuestBase patt0$temp = p.getQuest();
            if (!(patt0$temp instanceof NPCQuest)) return false;
            NPCQuest npcQuest = (NPCQuest)patt0$temp;
            if (!npc.method_5667().equals(npcQuest.getNpcUuid())) return false;
            return true;
        }).map(p -> ((NPCQuest)p.getQuest()).getOriginID()).findFirst().orElse(null);
    }
}

