/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.utils;

import com.google.common.collect.Lists;
import io.github.flemmli97.runecraftory.api.attachment.Skills;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.config.DistanceZoningConfig;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.config.MobConfig;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import io.github.flemmli97.runecraftory.common.entities.utils.IBaseMob;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.ToIntBiFunction;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1924;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5575;
import net.minecraft.class_5819;
import net.minecraft.class_6025;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class LevelCalc {
    private static long[] LEVEL_XP_TOTAL;
    private static long[] COMMON_SKILL_XP;
    private static long[] SLOW_SKILL_XP;
    private static long[] FAST_SKILL_XP;
    private static long[] VERY_FAST_SKILL_XP;
    private static long[] CRAFTING_SKILL_XP;
    private static long[] FRIEND_XP_TOTAL;

    public static int xpAmountForLevelUp(int level) {
        if (level <= 0) {
            return 1;
        }
        if (level >= GeneralConfig.maxLevel) {
            return 0;
        }
        return (int)(LevelCalc.totalXpForLevel(level + 1) - LevelCalc.totalXpForLevel(level));
    }

    public static long totalXpForLevel(int level) {
        if (level <= 0) {
            return 0L;
        }
        if (LEVEL_XP_TOTAL == null || LEVEL_XP_TOTAL.length < level) {
            int len = level + 10;
            LEVEL_XP_TOTAL = new long[len];
            LevelCalc.LEVEL_XP_TOTAL[0] = 50L;
            long prev = LEVEL_XP_TOTAL[0];
            for (int l = 1; l < len; ++l) {
                LevelCalc.LEVEL_XP_TOTAL[l] = (long)((double)(prev + 5L + (long)l * 10L) + 15.0 * Math.pow(l, 1.25) + (double)((long)(l / 10) * 250L) + (double)((long)(l / 20 * (l / 20)) * 1000L));
                prev = LEVEL_XP_TOTAL[l];
            }
        }
        return LEVEL_XP_TOTAL[level - 1];
    }

    public static int xpAmountForSkillLevelUp(Skills skill, int level) {
        if (level <= 0) {
            return 1;
        }
        if (level >= DataPackHandler.INSTANCE.skillPropertiesManager().getPropertiesFor(skill).maxLevel()) {
            return 0;
        }
        return (int)(LevelCalc.totalSkillXpForLevel(skill, level + 1) - LevelCalc.totalSkillXpForLevel(skill, level));
    }

    public static long totalSkillXpForLevel(Skills skill, int level) {
        if (level <= 0) {
            return 0L;
        }
        long[] xps = switch (skill.gainType) {
            default -> throw new MatchException(null, null);
            case Skills.GainType.COMMON -> {
                if (COMMON_SKILL_XP == null || COMMON_SKILL_XP.length < level) {
                    yield COMMON_SKILL_XP = LevelCalc.calcSkillXPs(COMMON_SKILL_XP, level, (l, prev) -> (long)((double)(prev + 35L) + 9.0 * Math.pow(l.intValue(), 2.555) - 12.0 * Math.pow(l.intValue(), 2.249) + (double)((long)l.intValue() * 21L)));
                }
                yield COMMON_SKILL_XP;
            }
            case Skills.GainType.SLOW -> {
                if (SLOW_SKILL_XP == null || SLOW_SKILL_XP.length < level) {
                    SLOW_SKILL_XP = LevelCalc.calcSkillXPs(SLOW_SKILL_XP, level, (l, prev) -> prev + 25L + ((long)l.intValue() - 1L) * 15L + (long)(l / 10) * 100L + (long)(Math.pow(l.intValue(), 1.2) * 3.0 + Math.pow(l / 10, 2.0) * 50.0 + Math.pow(Math.max(0, l - 50) / 10, 1.235) * 500.0));
                    yield SLOW_SKILL_XP;
                }
                yield SLOW_SKILL_XP;
            }
            case Skills.GainType.FAST -> {
                if (FAST_SKILL_XP == null || FAST_SKILL_XP.length < level) {
                    FAST_SKILL_XP = LevelCalc.calcSkillXPs(FAST_SKILL_XP, level, (l, prev) -> prev + 40L + (long)(l * 30) + (long)((int)(Math.pow(l.intValue(), 1.75) * 0.125) * 10));
                    yield FAST_SKILL_XP;
                }
                yield FAST_SKILL_XP;
            }
            case Skills.GainType.VERY_FAST -> {
                if (VERY_FAST_SKILL_XP == null || VERY_FAST_SKILL_XP.length < level) {
                    VERY_FAST_SKILL_XP = LevelCalc.calcSkillXPs(VERY_FAST_SKILL_XP, level, (l, prev) -> prev + 50L + ((long)l.intValue() - 1L) * 30L);
                    yield VERY_FAST_SKILL_XP;
                }
                yield VERY_FAST_SKILL_XP;
            }
            case Skills.GainType.CRAFTING -> {
                if (CRAFTING_SKILL_XP == null || CRAFTING_SKILL_XP.length < level) {
                    CRAFTING_SKILL_XP = LevelCalc.calcSkillXPs(CRAFTING_SKILL_XP, level, (l, prev) -> prev + 50L + ((long)l.intValue() - 1L) * 15L + (long)(l / 10) * 25L + (l % 10 == 0 ? (long)(l / 10) * 35L : 0L));
                    yield CRAFTING_SKILL_XP;
                }
                yield CRAFTING_SKILL_XP;
            }
        };
        return xps[level - 1];
    }

    private static long[] calcSkillXPs(long[] current, int level, BiFunction<Integer, Long, Long> levelXP) {
        if (current != null && current.length >= level) {
            return current;
        }
        int len = level + 10;
        if (current != null) {
            len = level + 50;
        }
        long[] xps = new long[len];
        xps[0] = 0L;
        long prev = xps[0];
        for (int l = 1; l < len; ++l) {
            xps[l] = levelXP.apply(l, prev);
            prev = xps[l];
        }
        return xps;
    }

    public static int friendPointsForNext(int level) {
        if (level <= 0) {
            return 1;
        }
        if (level >= 20) {
            return 0;
        }
        if (level >= 10) {
            return 1000;
        }
        return (int)(LevelCalc.totalFriendPointsForLevel(level) - LevelCalc.totalFriendPointsForLevel(level - 1));
    }

    public static long totalFriendPointsForLevel(int level) {
        if (level <= 0 || level >= 10) {
            return 0L;
        }
        if (FRIEND_XP_TOTAL == null) {
            FRIEND_XP_TOTAL = new long[10];
            LevelCalc.FRIEND_XP_TOTAL[0] = 30L;
            long prev = FRIEND_XP_TOTAL[0];
            for (int l = 1; l < 10; ++l) {
                LevelCalc.FRIEND_XP_TOTAL[l] = prev + 45L + (long)(l * 5) + (long)(l * l * 10);
                prev = FRIEND_XP_TOTAL[l];
            }
        }
        return FRIEND_XP_TOTAL[level - 1];
    }

    public static int getMoney(int base, int level) {
        return base;
    }

    public static void addXP(class_1309 attacker, int base, int money, int level) {
        LevelCalc.addXP(attacker, base, money, level, true);
    }

    public static void addXP(class_1309 attacker, int base, int money, int level, boolean adjustOnLevel) {
        NPCEntity npc;
        class_6025 ownable;
        class_1309 class_13092;
        if (GeneralConfig.xpMultiplier == 0.0f) {
            return;
        }
        class_3222 player = null;
        if (attacker instanceof class_3222) {
            class_3222 sP;
            player = sP = (class_3222)attacker;
        } else if (attacker instanceof class_6025 && (class_13092 = (ownable = (class_6025)attacker).method_35057()) instanceof class_3222) {
            class_3222 sP;
            player = sP = (class_3222)class_13092;
        } else if (attacker instanceof NPCEntity && (class_13092 = (npc = (NPCEntity)attacker).followEntity()) instanceof class_3222) {
            class_3222 sP;
            player = sP = (class_3222)class_13092;
        }
        if (player != null) {
            PlayerData data = Platform.INSTANCE.getPlayerData((class_1657)player);
            data.addXp(adjustOnLevel ? LevelCalc.levelXpWith(base, data.getPlayerLevel().getLevel(), level) : (float)base);
            data.setMoney(data.getMoney() + LevelCalc.getMoney(money, level));
            if (!(attacker instanceof class_1657)) {
                LevelCalc.tryAddXPTo(attacker, player, base, level, adjustOnLevel);
            }
            for (class_1308 e2 : player.method_37908().method_18023(class_5575.method_31795(class_1308.class), player.method_5829().method_1009(32.0, 32.0, 32.0), e -> true)) {
                if (e2 == attacker) continue;
                LevelCalc.tryAddXPTo((class_1309)e2, player, base, level, adjustOnLevel);
            }
        }
    }

    private static void tryAddXPTo(class_1309 entity, class_3222 player, int base, int level, boolean adjustOnLevel) {
        if (entity instanceof IBaseMob) {
            IBaseMob mob = (IBaseMob)entity;
            Consumer<Float> cons = null;
            if (entity instanceof BaseMonster) {
                BaseMonster monster = (BaseMonster)entity;
                if (player.method_5667().equals(monster.method_6139()) && monster.behaviourState() == BaseMonster.Behaviour.FOLLOW) {
                    cons = monster::addXp;
                }
            }
            if (entity instanceof NPCEntity) {
                NPCEntity npc = (NPCEntity)entity;
                if (player.method_5667().equals(npc.getEntityToFollowUUID())) {
                    cons = npc::addXp;
                }
            }
            if (cons == null) {
                return;
            }
            cons.accept(Float.valueOf(adjustOnLevel ? LevelCalc.levelXpWith(base, mob.xpLevel().getLevel(), level) : (float)base));
        }
    }

    private static float levelXpWith(int base, int level, int targetLevel) {
        float xp = ((float)base + (float)(base * (level - 1)) * 0.5f) * GeneralConfig.xpMultiplier;
        if (level <= targetLevel) {
            return xp;
        }
        int diff = level - targetLevel;
        return xp * Math.max(0.01f, 1.0f - (float)diff * 0.075f) * GeneralConfig.xpMultiplier;
    }

    public static float getSkillXpMultiplier(Skills skill) {
        return DataPackHandler.INSTANCE.skillPropertiesManager().getPropertiesFor(skill).xpMultiplier();
    }

    public static void levelSkill(PlayerData data, Skills skill, float amount) {
        if (GeneralConfig.skillXpMultiplier == 0.0f) {
            return;
        }
        data.increaseSkill(skill, LevelCalc.getSkillXpMultiplier(skill) * amount * GeneralConfig.skillXpMultiplier);
    }

    public static GateLevelResult levelFromPos(class_3218 level, class_243 pos) {
        List<class_3222> nearby = LevelCalc.playersAround((class_1924)level, pos, 256.0);
        return new GateLevelResult(LevelCalc.levelFromPos(level, pos, nearby), nearby);
    }

    public static int levelFromPos(class_3218 level, class_243 pos, List<class_3222> list) {
        return Math.max(1, switch (MobConfig.gateLevelType) {
            default -> throw new MatchException(null, null);
            case MobConfig.GateLevelType.CONSTANT -> LevelCalc.randomizedLevel(level.field_9229, LevelCalc.getLevelFor(MobConfig.baseGateLevel, list, null));
            case MobConfig.GateLevelType.DISTANCESPAWN -> LevelCalc.randomizedLevel(level.field_9229, LevelCalc.getLevelFor(MobConfig.baseGateLevel + LevelCalc.distanceLevelFrom((class_1937)level, pos, level.method_43126()), list, null));
            case MobConfig.GateLevelType.DISTANCESPAWNPLAYER -> LevelCalc.randomizedLevel(level.field_9229, LevelCalc.getLevelFor(MobConfig.baseGateLevel, list, (player, d) -> {
                class_3222 serverPlayer = (class_3222)player;
                class_2338 center = serverPlayer.method_26281() != level.method_27983() || serverPlayer.method_26280() == null ? level.method_43126() : serverPlayer.method_26280();
                return LevelCalc.distanceLevelFrom((class_1937)level, pos, center);
            }));
            case MobConfig.GateLevelType.PLAYERLEVEL -> LevelCalc.randomizedLevel(level.field_9229, LevelCalc.getLevelFor(MobConfig.baseGateLevel, list, (p, d) -> d.getPlayerLevel().getLevel()));
        });
    }

    private static int getLevelFor(int base, List<class_3222> list, ToIntBiFunction<class_1657, PlayerData> levelFunc) {
        if (levelFunc == null && !MobConfig.playerLevelType.increased) {
            return base;
        }
        if (list.isEmpty()) {
            return base;
        }
        int lvl = 0;
        boolean mean = MobConfig.playerLevelType.mean;
        for (class_1657 class_16572 : list) {
            int pL;
            PlayerData data = Platform.INSTANCE.getPlayerData(class_16572);
            int n = pL = levelFunc != null ? levelFunc.applyAsInt(class_16572, data) : 0;
            if (MobConfig.playerLevelType.increased) {
                pL += data.getMobLevelIncrease();
            }
            if (mean) {
                lvl += pL;
                continue;
            }
            if (pL <= lvl) continue;
            lvl = pL;
        }
        lvl = mean ? lvl / list.size() : lvl;
        return base + lvl;
    }

    private static int distanceLevelFrom(class_1937 level, class_243 pos, class_2338 center) {
        class_243 spawn = class_243.method_24953((class_2382)center);
        double dX = spawn.field_1352 - pos.field_1352;
        double dZ = spawn.field_1350 - pos.field_1350;
        double dist = Math.sqrt(dX * dX + dZ * dZ);
        Pair<Float, DistanceZoningConfig.Zone> zone = MobConfig.levelZones.get((float)dist);
        return LevelCalc.randomizedLevel(level.field_9229, (int)((double)((DistanceZoningConfig.Zone)zone.getRight()).start() + (dist - (double)((Float)zone.getLeft()).floatValue()) * (double)((DistanceZoningConfig.Zone)zone.getRight()).increasePerBlock()));
    }

    public static List<class_3222> playersAround(class_1924 getter, class_243 pos, double radius) {
        ArrayList list = Lists.newArrayList();
        for (class_1657 player : getter.method_18456()) {
            if (!class_1301.field_6155.test(player) || !class_1301.field_6157.test(player) || !(player instanceof class_3222)) continue;
            class_3222 serverPlayer = (class_3222)player;
            if (!player.method_19538().method_24802((class_2374)pos, radius)) continue;
            list.add(serverPlayer);
        }
        return list;
    }

    public static int randomizedLevel(class_5819 random, int level) {
        return level + Math.round((float)((random.method_43058() * 2.0 - 1.0) * Math.ceil((double)level * 0.15)));
    }

    public static boolean useRP(PlayerData data, float amount, boolean hurt, float percent, boolean mean, Skills ... skills) {
        int skillVal = 0;
        if (skills.length == 0) {
            skillVal = 1;
        } else if (skills.length == 1) {
            skillVal = data.getSkillLevel(skills[0]).getLevel();
        } else if (mean) {
            float l = skills.length;
            float sLvl = 0.0f;
            for (Skills skill : skills) {
                sLvl += (float)data.getSkillLevel(skill).getLevel();
            }
            skillVal = (int)(sLvl / l);
        } else {
            for (Skills skill : skills) {
                int lvl = data.getSkillLevel(skill).getLevel();
                if (lvl <= skillVal) continue;
                skillVal = lvl;
            }
        }
        float skillReduction = Math.max(1.0f - (float)(skillVal - 1) * 0.0065f, 0.3f);
        float val = amount * skillReduction;
        float percentAmount = percent > 0.0f ? (float)data.getMaxRunePoints() * percent * skillReduction : 0.0f;
        val = Math.max(percentAmount, val);
        int usage = class_3532.method_15386((float)val);
        return data.useRunePoints(usage, hurt);
    }

    public static float getMultiplierInterval(int level, int interval, float max, float bonus) {
        if (level < interval || bonus == 0.0f) {
            return level - 1;
        }
        int mod = level % interval;
        int completed = level / interval;
        float multiplier = interval - 2;
        for (int i = 1; i < completed; ++i) {
            multiplier += (float)interval * Math.min(max, (float)i + bonus);
        }
        return multiplier += (float)(mod + 1) * Math.min(max, 1.0f + (float)completed * bonus);
    }

    @Nullable
    public static Skills getSkillFromElement(ItemElement element) {
        return switch (element) {
            case ItemElement.WATER -> Skills.WATER;
            case ItemElement.EARTH -> Skills.EARTH;
            case ItemElement.WIND -> Skills.WIND;
            case ItemElement.FIRE -> Skills.FIRE;
            case ItemElement.LIGHT -> Skills.LIGHT;
            case ItemElement.DARK -> Skills.DARK;
            case ItemElement.LOVE -> Skills.LOVE;
            default -> null;
        };
    }

    public record GateLevelResult(int level, List<class_3222> nearby) {
    }
}

