/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.world.data;

import io.github.flemmli97.runecraftory.api.calendar.DayOfWeek;
import io.github.flemmli97.runecraftory.api.calendar.Season;
import io.github.flemmli97.runecraftory.api.calendar.Weather;
import io.github.flemmli97.runecraftory.client.ClientCalendarHolder;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.network.S2CCalendar;
import io.github.flemmli97.runecraftory.common.utils.StreamCodecUtils;
import io.github.flemmli97.runecraftory.common.utils.WorldUtils;
import io.github.flemmli97.runecraftory.common.world.data.RunecraftorySavedData;
import io.github.flemmli97.runecraftory.integration.sereneseasons.SeasonsAccess;
import io.github.flemmli97.tenshilib.loader.LoaderNetwork;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class Calendar {
    @Nullable
    private final RunecraftorySavedData handler;
    private Date current = new Date(1, 1, DayOfWeek.MONDAY, Season.SPRING);
    private Weather[] todaysForecast = new Weather[]{Weather.CLEAR};
    private Weather currentWeather = Weather.CLEAR;
    private Weather[] nextForecast = new Weather[]{Weather.CLEAR};
    private int updateDelay;

    public Calendar(@Nullable RunecraftorySavedData handler) {
        this.handler = handler;
    }

    public static Calendar get(class_1937 level) {
        if (level.method_8608()) {
            return ClientCalendarHolder.CLIENT_CALENDAR;
        }
        return RunecraftorySavedData.get(level.method_8503()).getCalendar();
    }

    public static boolean canUpdateWeather(class_1937 level) {
        return GeneralConfig.modifyWeather && level.method_8450().method_8355(class_1928.field_19396);
    }

    public static boolean shouldUpdateWeather(class_1937 level, Weather currentWeather) {
        if (currentWeather == Weather.RUNEY || currentWeather == Weather.STORM) {
            return WorldUtils.dayTime(level) == 1;
        }
        long time = WorldUtils.dayTime(level);
        return time % 3000L == 1L;
    }

    public Season currentSeason() {
        return this.date().season();
    }

    public Date date() {
        return this.current;
    }

    public void setDateDayAndSeason(MinecraftServer server, int dayOfYear, int date, DayOfWeek day, Season season) {
        this.current = new Date(dayOfYear, date, day, season);
        LoaderNetwork.INSTANCE.sendToAll((class_8710)new S2CCalendar(this), server);
        this.setDirty();
    }

    public void tick(class_3218 level, boolean isUpdateTime) {
        SeasonsAccess.SeasonData seasons = SeasonsAccess.getDate((class_1937)level);
        if (seasons != null) {
            boolean changed;
            boolean bl = changed = this.current.dayOfYear() != seasons.dayOfYear() || this.current.season() != seasons.season();
            if (changed) {
                int diff;
                for (diff = seasons.dayOfYear() - this.current.dayOfYear(); diff < 0; diff += seasons.daysPerYear()) {
                }
                DayOfWeek day = DayOfWeek.values()[Math.floorMod(this.current.day().ordinal() + diff, DayOfWeek.values().length)];
                this.current = new Date(seasons.dayOfYear(), seasons.dayOfSeason(), day, seasons.season());
                LoaderNetwork.INSTANCE.sendToAll((class_8710)new S2CCalendar(this), level.method_8503());
                this.setDirty();
            }
        } else if (isUpdateTime) {
            this.increaseDay(level);
            this.createDailyWeather(level);
        }
        boolean doWeather = Calendar.canUpdateWeather((class_1937)level);
        if (doWeather && (isUpdateTime || Calendar.shouldUpdateWeather((class_1937)level, this.currentWeather()))) {
            this.updateWeatherTo(level, this.getCurrentWeatherFor(level));
        }
    }

    private void increaseDay(class_3218 level) {
        int date = WorldUtils.day((class_1937)level);
        DayOfWeek day = DayOfWeek.values()[Math.floorMod(date, DayOfWeek.values().length)];
        Season season = Season.values()[Math.floorMod(date / 30, Season.values().length)];
        this.setDateDayAndSeason(level.method_8503(), date % 120 + 1, date % 30 + 1, day, season);
        LoaderNetwork.INSTANCE.sendToAll((class_8710)new S2CCalendar(this), level.method_8503());
        this.setDirty();
    }

    public void updateWeatherTo(class_3218 level, Weather weather) {
        this.setWeather(level.method_8503(), weather);
        this.setMCWeather(level);
        this.updateDelay = 100;
        this.setDirty();
    }

    private void createDailyWeather(class_3218 level) {
        Weather[] nextWeather = new Weather[8];
        Season season = this.currentSeason();
        int rainCount = 0;
        for (int i = 0; i < nextWeather.length; ++i) {
            float rainAdd;
            float chance = level.field_9229.method_43057();
            if (i != 0) {
                if (nextWeather[0].wholeDay) {
                    nextWeather[i] = nextWeather[0];
                    return;
                }
            } else {
                float stormAdd;
                float f = stormAdd = season == Season.SUMMER || season == Season.WINTER ? 0.04f : 0.0f;
                if (chance < 0.03f) {
                    nextWeather[i] = Weather.RUNEY;
                } else if (chance < 0.015f + stormAdd) {
                    nextWeather[i] = Weather.STORM;
                }
                if (nextWeather[i] != null) {
                    return;
                }
            }
            float f = rainAdd = rainCount > 0 ? 0.5f - (float)(rainCount - 1) * 0.2f : 0.0f;
            if (i < 3) {
                rainAdd = (float)((double)rainAdd + (season == Season.SUMMER ? 0.1 : 0.05));
            }
            if (chance < 0.1f + rainAdd) {
                nextWeather[i] = Weather.RAIN;
                ++rainCount;
                continue;
            }
            nextWeather[i] = Weather.CLEAR;
        }
        this.updateWeathers(nextWeather);
    }

    private void setMCWeather(class_3218 level) {
        this.currentWeather().setWeather.accept(level);
    }

    private boolean isCorrectWeather(class_3218 level) {
        return switch (this.currentWeather()) {
            default -> throw new MatchException(null, null);
            case Weather.RAIN -> level.method_8419();
            case Weather.CLEAR, Weather.RUNEY, Weather.CLOUDY -> {
                if (!level.method_8419() && !level.method_8546()) {
                    yield true;
                }
                yield false;
            }
            case Weather.STORM -> level.method_8419() && level.method_8546();
        };
    }

    public Weather currentWeather() {
        return this.currentWeather;
    }

    public Weather getCurrentWeatherFor(class_3218 level) {
        int i = WorldUtils.dayTime((class_1937)level) / 3000;
        if (i >= 0 && i < this.todaysForecast.length) {
            return this.todaysForecast[i];
        }
        return Weather.CLEAR;
    }

    public Weather[] todaysForecast() {
        return this.todaysForecast;
    }

    public Weather[] tomorrowsForecast() {
        return this.nextForecast;
    }

    public void setWeather(MinecraftServer server, Weather weather) {
        this.currentWeather = weather;
        LoaderNetwork.INSTANCE.sendToAll((class_8710)new S2CCalendar(this), server);
    }

    public void updateWeathers(Weather[] nextDays) {
        this.todaysForecast = this.nextForecast;
        this.nextForecast = nextDays;
    }

    public void updateDirect(Date date, Weather weather) {
        this.current = date;
        this.currentWeather = weather;
    }

    private void setDirty() {
        if (this.handler != null) {
            this.handler.method_80();
        }
    }

    public void read(class_2487 nbt) {
        this.current = new Date(nbt.method_10550("DayOfYear"), nbt.method_10550("Date"), DayOfWeek.valueOf(nbt.method_10558("Day")), Season.valueOf(nbt.method_10558("Season")));
        this.currentWeather = Weather.valueOf(nbt.method_10558("Weather"));
        class_2499 list = nbt.method_10554("Forecast", 8);
        this.todaysForecast = (Weather[])list.stream().map(t -> Weather.valueOf(t.method_10714())).limit(8L).toArray(Weather[]::new);
        class_2499 next = nbt.method_10554("NextForecast", 8);
        this.nextForecast = (Weather[])next.stream().map(t -> Weather.valueOf(t.method_10714())).limit(8L).toArray(Weather[]::new);
    }

    public class_2487 write(class_2487 nbt) {
        nbt.method_10569("DayOfYear", this.current.dayOfYear());
        nbt.method_10569("Date", this.current.date());
        nbt.method_10582("Day", this.current.day().toString());
        nbt.method_10582("Season", this.current.season().toString());
        nbt.method_10582("Weather", this.currentWeather.toString());
        class_2499 list = new class_2499();
        Arrays.stream(this.todaysForecast).forEach(w -> list.add((Object)class_2519.method_23256((String)w.toString())));
        nbt.method_10566("Forecast", (class_2520)list);
        class_2499 next = new class_2499();
        Arrays.stream(this.nextForecast).forEach(w -> next.add((Object)class_2519.method_23256((String)w.toString())));
        nbt.method_10566("NextForecast", (class_2520)next);
        return nbt;
    }

    public record Date(int dayOfYear, int date, DayOfWeek day, Season season) {
        public static final class_9139<ByteBuf, Date> STREAM_CODEC = class_9139.method_56905((class_9139)class_9135.field_49675, Date::dayOfYear, (class_9139)class_9135.field_49675, Date::date, StreamCodecUtils.ofEnum(DayOfWeek.class), Date::day, StreamCodecUtils.ofEnum(Season.class), Date::season, Date::new);
    }
}

