/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.world.data.family;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.DynamicOps;
import io.github.flemmli97.runecraftory.api.datapack.npc.NPCData;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import io.github.flemmli97.runecraftory.common.world.data.family.FamilyHandler;
import io.github.flemmli97.runecraftory.common.world.data.family.SyncedFamilyData;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_8824;
import org.jetbrains.annotations.Nullable;

public class FamilyEntry {
    public static final int DEPTH = 3;
    private UUID father;
    private UUID mother;
    private final Set<UUID> siblings = new HashSet<UUID>();
    private final Set<UUID> children = new HashSet<UUID>();
    private class_2561 name;
    private NPCData.Gender gender;
    private UUID self;
    private UUID partner;
    private Relationship relationship = Relationship.NONE;
    private EntityState entityState;
    private final FamilyHandler familyHandler;

    public FamilyEntry(FamilyHandler familyHandler, UUID self, class_2561 name, NPCData.Gender gender, boolean player) {
        this.familyHandler = familyHandler;
        this.self = self;
        this.name = name;
        this.gender = gender;
        this.entityState = player ? EntityState.PLAYER : EntityState.ALIVE;
    }

    public FamilyEntry(FamilyHandler familyHandler, class_2487 tag, class_7225.class_7874 provider) {
        this.familyHandler = familyHandler;
        this.load(tag, provider);
    }

    public void setFather(UUID father) {
        if (this.father != null) {
            this.familyHandler.getFamily(this.father).ifPresent(e -> {
                e.children.forEach(child -> this.familyHandler.getFamily((UUID)child).ifPresent(ce -> ce.siblings.remove(this.self)));
                e.removeChild(this.self);
            });
        }
        this.father = father;
        this.familyHandler.getFamily(this.father).ifPresent(e -> e.addChild(this.self));
        this.familyHandler.method_80();
    }

    public void setMother(UUID mother) {
        if (this.mother != null) {
            this.familyHandler.getFamily(this.mother).ifPresent(e -> {
                e.children.forEach(child -> this.familyHandler.getFamily((UUID)child).ifPresent(ce -> ce.siblings.remove(this.self)));
                e.removeChild(this.self);
            });
        }
        this.mother = mother;
        this.familyHandler.getFamily(this.mother).ifPresent(e -> e.addChild(this.self));
        this.familyHandler.method_80();
    }

    public void addChild(UUID uuid) {
        if (this.partner != null) {
            this.familyHandler.getFamily(this.partner).ifPresent(e -> e.children.add(this.self));
        }
        this.children.add(uuid);
        this.children.forEach(child -> this.familyHandler.getFamily((UUID)child).ifPresent(e -> e.siblings.add(this.self)));
        this.familyHandler.method_80();
    }

    public void removeChild(UUID uuid) {
        if (this.partner != null) {
            this.familyHandler.getFamily(this.partner).ifPresent(e -> e.children.remove(this.self));
        }
        this.children.remove(uuid);
        this.children.forEach(child -> this.familyHandler.getFamily((UUID)child).ifPresent(e -> e.siblings.remove(this.self)));
        this.familyHandler.method_80();
    }

    public void addSibling(UUID uuid) {
        if (this.father != null) {
            this.familyHandler.getFamily(this.father).ifPresent(e -> e.children.add(this.self));
        }
        if (this.mother != null) {
            this.familyHandler.getFamily(this.mother).ifPresent(e -> e.children.add(this.self));
        }
        this.siblings.forEach(sibling -> this.familyHandler.getFamily((UUID)sibling).ifPresent(e -> e.siblings.add(uuid)));
        this.siblings.add(uuid);
        this.familyHandler.method_80();
    }

    public void removeSibling(UUID uuid) {
        if (this.father != null) {
            this.familyHandler.getFamily(this.father).ifPresent(e -> e.children.remove(this.self));
        }
        if (this.mother != null) {
            this.familyHandler.getFamily(this.mother).ifPresent(e -> e.children.remove(this.self));
        }
        this.siblings.remove(uuid);
        this.siblings.forEach(sibling -> this.familyHandler.getFamily((UUID)sibling).ifPresent(e -> e.siblings.remove(uuid)));
        this.familyHandler.method_80();
    }

    public void updateName(class_1297 entity) {
        this.name = entity.method_5477();
        this.familyHandler.method_80();
    }

    public void updateRelationship(Relationship relationship, UUID partner) {
        if (this.partner != null) {
            this.familyHandler.getFamily(this.partner).ifPresent(e -> {
                e.partner = null;
                e.relationship = Relationship.NONE;
            });
        }
        this.relationship = relationship;
        this.partner = partner;
        if (this.partner != null) {
            this.familyHandler.getFamily(this.partner).ifPresent(e -> {
                e.partner = this.self;
                e.relationship = relationship;
            });
        }
        this.familyHandler.method_80();
    }

    public Relationship getRelationship() {
        return this.relationship;
    }

    public UUID getPartner() {
        return this.partner;
    }

    public boolean hasPlayerRelationShip() {
        if (this.partner == null) {
            return false;
        }
        return this.familyHandler.getFamily(this.partner).map(FamilyEntry::isPlayer).orElse(false);
    }

    public boolean isRelated(UUID uuid) {
        return this.findRelativesRecursive(3, uuid);
    }

    @Nullable
    public FamilyRelation getRelativeState(UUID toFind) {
        return this.findRelativeStateRecursive(2, FamilyRelation.NONE, toFind);
    }

    private FamilyRelation findRelativeStateRecursive(int depth, FamilyRelation current, UUID toFind) {
        if (depth > 0) {
            FamilyRelation relation;
            FamilyRelation relation2;
            FamilyRelation next;
            if (this.father != null) {
                next = FamilyRelation.MAP.get((Object)((Object)current)).father;
                if (this.father.equals(toFind)) {
                    return next;
                }
                relation2 = this.familyHandler.getFamily(this.father).map(e -> this.findRelativeStateRecursive(depth - 1, next, toFind)).orElse(null);
                if (relation2 != null) {
                    return relation2;
                }
            }
            if (this.mother != null) {
                next = FamilyRelation.MAP.get((Object)((Object)current)).mother;
                if (this.mother.equals(toFind)) {
                    return next;
                }
                relation2 = this.familyHandler.getFamily(this.mother).map(e -> this.findRelativeStateRecursive(depth - 1, next, toFind)).orElse(null);
                if (relation2 != null) {
                    return relation2;
                }
            }
            for (UUID sibling : this.siblings) {
                relation = this.familyHandler.getFamily(sibling).map(e -> {
                    FamilyRelation next;
                    FamilyRelation familyRelation = next = e.gender == NPCData.Gender.MALE ? FamilyRelation.MAP.get((Object)((Object)((Object)current))).maleSibling : FamilyRelation.MAP.get((Object)((Object)((Object)current))).femaleSibling;
                    if (sibling.equals(toFind)) {
                        return next;
                    }
                    return this.findRelativeStateRecursive(depth - 1, next, toFind);
                }).orElse(null);
                if (relation == null) continue;
                return relation;
            }
            for (UUID child : this.children) {
                relation = this.familyHandler.getFamily(child).map(e -> {
                    FamilyRelation next;
                    FamilyRelation familyRelation = next = e.gender == NPCData.Gender.MALE ? FamilyRelation.MAP.get((Object)((Object)((Object)current))).maleChild : FamilyRelation.MAP.get((Object)((Object)((Object)current))).femaleChild;
                    if (child.equals(toFind)) {
                        return next;
                    }
                    return this.findRelativeStateRecursive(depth - 1, next, toFind);
                }).orElse(null);
                if (relation == null) continue;
                return relation;
            }
        }
        return null;
    }

    private boolean findRelativesRecursive(int depth, UUID toFind) {
        if (depth > 0) {
            if (this.father != null) {
                if (this.father.equals(toFind)) {
                    return true;
                }
                if (this.familyHandler.getFamily(this.father).map(e -> this.findRelativesRecursive(depth - 1, toFind)).orElse(false).booleanValue()) {
                    return true;
                }
            }
            if (this.mother != null) {
                if (this.mother.equals(toFind)) {
                    return true;
                }
                if (this.familyHandler.getFamily(this.mother).map(e -> this.findRelativesRecursive(depth - 1, toFind)).orElse(false).booleanValue()) {
                    return true;
                }
            }
            for (UUID sibling : this.siblings) {
                if (sibling.equals(toFind)) {
                    return true;
                }
                if (!this.familyHandler.getFamily(sibling).map(e -> this.findRelativesRecursive(depth - 1, toFind)).orElse(false).booleanValue()) continue;
                return true;
            }
            for (UUID child : this.children) {
                if (child.equals(toFind)) {
                    return true;
                }
                if (!this.familyHandler.getFamily(child).map(e -> this.findRelativesRecursive(depth - 1, toFind)).orElse(false).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isPlayer() {
        return this.entityState == EntityState.PLAYER;
    }

    public void markAsDead() {
        if (this.entityState != EntityState.PLAYER) {
            this.entityState = EntityState.DEAD;
        }
        this.familyHandler.method_80();
    }

    public boolean shouldPersist() {
        return this.shouldPersist(3);
    }

    private boolean shouldPersist(int depth) {
        if (this.entityState == EntityState.ALIVE || this.entityState == EntityState.PLAYER) {
            return true;
        }
        if (depth > 0) {
            if (this.partner != null && this.familyHandler.getFamily(this.partner).map(e -> {
                if (e.entityState == EntityState.ALIVE || e.entityState == EntityState.PLAYER) {
                    return true;
                }
                return e.shouldPersist(depth - 2);
            }).orElse(false).booleanValue()) {
                return true;
            }
            if (this.father != null && this.familyHandler.getFamily(this.father).map(e -> {
                if (e.entityState == EntityState.ALIVE || e.entityState == EntityState.PLAYER) {
                    return true;
                }
                return e.shouldPersist(depth - 2);
            }).orElse(false).booleanValue()) {
                return true;
            }
            if (this.mother != null && this.familyHandler.getFamily(this.mother).map(e -> {
                if (e.entityState == EntityState.ALIVE || e.entityState == EntityState.PLAYER) {
                    return true;
                }
                return e.shouldPersist(depth - 2);
            }).orElse(false).booleanValue()) {
                return true;
            }
            for (UUID sibling : this.siblings) {
                if (!this.familyHandler.getFamily(sibling).map(e -> {
                    if (e.entityState == EntityState.ALIVE || e.entityState == EntityState.PLAYER) {
                        return true;
                    }
                    return e.shouldPersist(depth - 2);
                }).orElse(false).booleanValue()) continue;
                return true;
            }
            for (UUID child : this.children) {
                if (!this.familyHandler.getFamily(child).map(e -> {
                    if (e.entityState == EntityState.ALIVE || e.entityState == EntityState.PLAYER) {
                        return true;
                    }
                    return e.shouldPersist(depth - 2);
                }).orElse(false).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    public class_2487 save(class_7225.class_7874 provider) {
        class_6903 ops = provider.method_57093((DynamicOps)class_2509.field_11560);
        class_2487 tag = new class_2487();
        if (this.father != null) {
            tag.method_25927("Father", this.father);
        }
        if (this.mother != null) {
            tag.method_25927("Mother", this.mother);
        }
        class_2499 siblings = new class_2499();
        this.siblings.forEach(uuid -> siblings.add((Object)class_2512.method_25929((UUID)uuid)));
        tag.method_10566("Siblings", (class_2520)siblings);
        class_2499 children = new class_2499();
        this.children.forEach(uuid -> children.add((Object)class_2512.method_25929((UUID)uuid)));
        tag.method_10566("Children", (class_2520)children);
        tag.method_10566("Name", (class_2520)class_8824.field_46597.encodeStart((DynamicOps)ops, (Object)this.name).getOrThrow());
        tag.method_10569("Gender", this.gender.ordinal());
        tag.method_25927("OwnID", this.self);
        if (this.partner != null) {
            tag.method_25927("Partner", this.partner);
        }
        tag.method_10569("RelationShip", this.relationship.ordinal());
        tag.method_10569("EntityState", this.entityState.ordinal());
        return tag;
    }

    public void load(class_2487 tag, class_7225.class_7874 provider) {
        class_6903 ops = provider.method_57093((DynamicOps)class_2509.field_11560);
        if (tag.method_25928("Father")) {
            this.father = tag.method_25926("Father");
        }
        if (tag.method_25928("Mother")) {
            this.mother = tag.method_25926("Mother");
        }
        class_2499 siblings = tag.method_10554("Siblings", 11);
        siblings.forEach(sibling -> this.siblings.add(class_2512.method_25930((class_2520)sibling)));
        class_2499 children = tag.method_10554("Children", 11);
        children.forEach(sibling -> this.children.add(class_2512.method_25930((class_2520)sibling)));
        this.name = (class_2561)class_8824.field_46597.parse((DynamicOps)ops, (Object)tag.method_10580("Name")).getOrThrow();
        this.gender = NPCData.Gender.values()[tag.method_10550("Gender")];
        this.self = tag.method_25926("OwnID");
        this.gender = NPCData.Gender.values()[tag.method_10550("Gender")];
        if (tag.method_25928("Partner")) {
            this.partner = tag.method_25926("Partner");
        }
        this.relationship = Relationship.values()[tag.method_10550("RelationShip")];
        this.entityState = EntityState.values()[tag.method_10550("EntityState")];
    }

    public SyncedFamilyData forSyncing(NPCEntity npc, class_3222 player) {
        class_2561 father = this.father != null ? (class_2561)this.familyHandler.getFamily(this.father).map(e -> e.name).orElse(null) : null;
        class_2561 mother = this.mother != null ? (class_2561)this.familyHandler.getFamily(this.mother).map(e -> e.name).orElse(null) : null;
        class_2561 partner = this.partner != null ? (class_2561)this.familyHandler.getFamily(this.partner).map(e -> e.name).orElse(null) : null;
        return new SyncedFamilyData(Optional.ofNullable(father), Optional.ofNullable(mother), Optional.ofNullable(partner), this.relationship, player.method_5667().equals(this.partner) && npc.canProcreate());
    }

    public static enum Relationship {
        NONE,
        DATING,
        MARRIED;

    }

    public static enum EntityState {
        ALIVE,
        DEAD,
        PLAYER;

    }

    public static enum FamilyRelation {
        NONE,
        FATHER,
        MOTHER,
        BROTHER,
        SISTER,
        SON,
        DAUGHTER,
        GRAND_SON,
        GRAND_DAUGHTER,
        NEPHEW,
        NIECE,
        UNCLE,
        AUNT,
        GRAND_FATHER,
        GRAND_MOTHER;

        private static final EnumMap<FamilyRelation, FamilyRelationRelation> MAP;

        static {
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            builder.put((Object)NONE, (Object)new FamilyRelationRelation(FATHER, MOTHER, BROTHER, SISTER, SON, DAUGHTER));
            builder.put((Object)FATHER, (Object)new FamilyRelationRelation(GRAND_FATHER, GRAND_MOTHER, UNCLE, AUNT, BROTHER, SISTER));
            builder.put((Object)MOTHER, (Object)new FamilyRelationRelation(GRAND_FATHER, GRAND_MOTHER, UNCLE, AUNT, BROTHER, SISTER));
            builder.put((Object)BROTHER, (Object)new FamilyRelationRelation(FATHER, MOTHER, BROTHER, SISTER, NEPHEW, NIECE));
            builder.put((Object)SISTER, (Object)new FamilyRelationRelation(FATHER, MOTHER, BROTHER, SISTER, NEPHEW, NIECE));
            builder.put((Object)SON, (Object)new FamilyRelationRelation(NONE, NONE, SON, DAUGHTER, GRAND_SON, GRAND_DAUGHTER));
            builder.put((Object)DAUGHTER, (Object)new FamilyRelationRelation(NONE, NONE, SON, DAUGHTER, GRAND_SON, GRAND_DAUGHTER));
            builder.put((Object)GRAND_SON, (Object)new FamilyRelationRelation(null, null, null, null, null, null));
            builder.put((Object)GRAND_DAUGHTER, (Object)new FamilyRelationRelation(null, null, null, null, null, null));
            builder.put((Object)NEPHEW, (Object)new FamilyRelationRelation(BROTHER, SISTER, NEPHEW, NIECE, null, null));
            builder.put((Object)NIECE, (Object)new FamilyRelationRelation(BROTHER, SISTER, NEPHEW, NIECE, null, null));
            builder.put((Object)UNCLE, (Object)new FamilyRelationRelation(GRAND_FATHER, GRAND_MOTHER, UNCLE, AUNT, null, null));
            builder.put((Object)AUNT, (Object)new FamilyRelationRelation(GRAND_FATHER, GRAND_MOTHER, UNCLE, AUNT, null, null));
            builder.put((Object)GRAND_FATHER, (Object)new FamilyRelationRelation(null, null, null, null, null, null));
            builder.put((Object)GRAND_MOTHER, (Object)new FamilyRelationRelation(null, null, null, null, null, null));
            MAP = new EnumMap(builder.build());
        }

        record FamilyRelationRelation(FamilyRelation father, FamilyRelation mother, FamilyRelation maleSibling, FamilyRelation femaleSibling, FamilyRelation maleChild, FamilyRelation femaleChild) {
        }
    }
}

