/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.mixinhelper;

import io.github.flemmli97.runecraftory.api.calendar.Season;
import io.github.flemmli97.runecraftory.client.ClientCalendarHolder;
import io.github.flemmli97.runecraftory.client.ClientCalls;
import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.client.model.armor.ArmorModels;
import io.github.flemmli97.runecraftory.common.attachment.EntityData;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerWeaponHandler;
import io.github.flemmli97.runecraftory.common.config.ClientConfig;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttackActions;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryDataComponentTypes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryItems;
import io.github.flemmli97.runecraftory.common.world.data.Calendar;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.client.model.ModelPartsContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimatedEntity;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1007;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4050;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5253;
import net.minecraft.class_5603;
import net.minecraft.class_572;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.class_742;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_9331;

public class ClientMixinUtils {
    public static final int LEAVE_SPRING = 870913;
    public static final int LEAVE_FALL = 0xFF4646;
    private static final Map<SeasonedTint, Integer> LEAVE_TINTS = new ConcurrentHashMap<SeasonedTint, Integer>();
    private static final Map<SeasonedTint, Integer> GRASS_TINTS = new ConcurrentHashMap<SeasonedTint, Integer>();
    private static boolean AnimatedItemHandRendering;

    public static int modifyColoredTint(class_1920 getter, int old) {
        Calendar calendar = ClientCalendarHolder.CLIENT_CALENDAR;
        if (calendar.currentSeason() == Season.SUMMER) {
            return old;
        }
        return LEAVE_TINTS.computeIfAbsent(new SeasonedTint(old, calendar.currentSeason()), ClientMixinUtils::getLeaveTint);
    }

    public static int modifyColoredTintGrass(class_1920 getter, int old) {
        Calendar calendar = ClientCalendarHolder.CLIENT_CALENDAR;
        if (calendar.currentSeason() == Season.SUMMER) {
            return old;
        }
        return GRASS_TINTS.computeIfAbsent(new SeasonedTint(old, calendar.currentSeason()), ClientMixinUtils::getGrassTint);
    }

    private static int getLeaveTint(SeasonedTint tint) {
        return switch (tint.season) {
            default -> throw new MatchException(null, null);
            case Season.SPRING -> ClientMixinUtils.desaturate(ClientMixinUtils.add(tint.origin, 870913), 0.1f);
            case Season.SUMMER -> tint.origin;
            case Season.AUTUMN -> ClientMixinUtils.desaturate(ClientMixinUtils.add(class_5253.class_5254.method_27763((int)tint.origin, (int)0xFF4646), 3939840), 0.2f);
            case Season.WINTER -> ClientMixinUtils.desaturate(ClientMixinUtils.add(class_5253.class_5254.method_27763((int)tint.origin, (int)0xFF4646), 3939840), 0.6f);
        };
    }

    private static int getGrassTint(SeasonedTint tint) {
        return switch (tint.season) {
            default -> throw new MatchException(null, null);
            case Season.SPRING -> ClientMixinUtils.desaturate(ClientMixinUtils.add(tint.origin, 870913), 0.1f);
            case Season.SUMMER -> tint.origin;
            case Season.AUTUMN -> ClientMixinUtils.desaturate(tint.origin, 0.25f);
            case Season.WINTER -> ClientMixinUtils.desaturate(tint.origin, 0.7f);
        };
    }

    private static int desaturate(int color, float perc) {
        int r = class_5253.class_5254.method_27765((int)color);
        int g = class_5253.class_5254.method_27766((int)color);
        int b = class_5253.class_5254.method_27767((int)color);
        int gray = Math.max(b, Math.max(r, g));
        return class_5253.class_5254.method_27764((int)class_5253.class_5254.method_27762((int)color), (int)((int)((float)r + (float)(gray - r) * perc)), (int)((int)((float)g + (float)(gray - g) * perc)), (int)((int)((float)b + (float)(gray - b) * perc)));
    }

    private static int add(int packedColourOne, int packedColorTwo) {
        return class_5253.class_5254.method_27764((int)Math.min(255, class_5253.class_5254.method_27762((int)packedColourOne) + class_5253.class_5254.method_27762((int)packedColorTwo)), (int)Math.min(255, class_5253.class_5254.method_27765((int)packedColourOne) + class_5253.class_5254.method_27765((int)packedColorTwo)), (int)Math.min(255, class_5253.class_5254.method_27766((int)packedColourOne) + class_5253.class_5254.method_27766((int)packedColorTwo)), (int)Math.min(255, class_5253.class_5254.method_27767((int)packedColourOne) + class_5253.class_5254.method_27767((int)packedColorTwo)));
    }

    public static void translateSleepingEntity(class_1309 entity, class_4587 poseStack, float flipDegrees) {
        if (EntityData.getSleepStateFrom(entity) == EntityData.SleepState.VANILLA && flipDegrees != 0.0f) {
            ClientCalls.SLEEP_ROTATED_TYPES.add(entity.method_5864());
            poseStack.method_22904(0.0, (double)entity.method_17681() * 0.15, 0.0);
            if (entity.method_18376() == class_4050.field_18078) {
                poseStack.method_22907(class_7833.field_40718.rotationDegrees(entity.method_5791() + 90.0f));
            } else {
                poseStack.method_22907(class_7833.field_40716.rotationDegrees(entity.field_6283 - entity.method_5791()));
                poseStack.method_22907(class_7833.field_40714.rotationDegrees(flipDegrees));
            }
            float standOffset = entity.method_18381(class_4050.field_18076) * 0.6f;
            poseStack.method_46416(0.0f, -standOffset, 0.0f);
        }
    }

    public static boolean shouldAnimate(class_1309 entity) {
        return entity instanceof class_1657 || entity instanceof AnimatedEntity;
    }

    public static void transformHumanoidModel(class_1309 entity, class_572<?> model) {
        PlayerWeaponHandler weaponHandler;
        class_1268 off;
        class_1268 main = entity.method_6068() == class_1306.field_6183 ? class_1268.field_5808 : class_1268.field_5810;
        class_1268 class_12682 = off = entity.method_6068() == class_1306.field_6183 ? class_1268.field_5810 : class_1268.field_5808;
        if (model.field_3395 == class_572.class_573.field_3410 && entity.method_5998(main).method_31574((class_1792)RuneCraftoryItems.UMBRELLA.get())) {
            model.field_3401.field_3654 -= 1.2217305f;
        }
        if (model.field_3399 == class_572.class_573.field_3410 && entity.method_5998(off).method_31574((class_1792)RuneCraftoryItems.UMBRELLA.get())) {
            model.field_27433.field_3654 -= 1.2217305f;
        }
        float partialTicks = ClientHandlers.getPartialTicks();
        if (entity instanceof AnimatedEntity) {
            boolean result = ClientHandlers.getAnimatedPlayerModel().setUpModel(entity, model, null, partialTicks);
            if (result) {
                ClientHandlers.getAnimatedPlayerModel().copyTo(model);
            }
            return;
        }
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            v1 = Platform.INSTANCE.getPlayerData(player).getWeaponHandler();
        } else {
            v1 = weaponHandler = null;
        }
        if (weaponHandler == null) {
            return;
        }
        boolean ignoreRiding = weaponHandler.getCurrentAction() == RuneCraftoryAttackActions.DUAL_USE.get();
        boolean result = ClientHandlers.getAnimatedPlayerModel().setUpModel(entity, model, weaponHandler, partialTicks);
        if (result) {
            ClientHandlers.getAnimatedPlayerModel().copyTo(model);
        }
    }

    public static void onRenderHand(class_4587 poseStack, class_742 player, boolean rightArm, class_591<class_742> arm, class_4597 buffer, int combinedLight) {
        for (class_1799 stack : player.method_5661()) {
            ArmorModels.FirstPersonArmorRenderer r;
            if (stack.method_7960() || (r = ArmorModels.getFirstPersonRenderer(stack)) == null) continue;
            r.render(player, stack, rightArm, arm, poseStack, buffer, combinedLight);
        }
    }

    public static boolean onRenderHeldItem(class_1309 livingEntity, class_1799 stack, class_811 transformType, boolean leftHand, class_4597 buffer, int combinedLight) {
        if (livingEntity instanceof class_742) {
            class_742 player = (class_742)livingEntity;
            if (transformType.method_29998()) {
                if (leftHand == (livingEntity.method_6068() == class_1306.field_6183) && AnimatedItemHandRendering) {
                    return true;
                }
                PlayerData data = Platform.INSTANCE.getPlayerData((class_1657)player);
                if (data != null) {
                    class_1007 renderer = (class_1007)class_310.method_1551().method_1561().method_3953((class_1297)player);
                    float partialTicks = ClientHandlers.getPartialTicks();
                    AnimatedItemHandRendering = ClientHandlers.getAnimatedPlayerModel().setUpModel((class_1309)player, null, data.getWeaponHandler(), partialTicks);
                    if (!AnimatedItemHandRendering) {
                        return false;
                    }
                    player.method_7350();
                    class_4587 poseStack = new class_4587();
                    poseStack.method_22903();
                    poseStack.method_22905(-0.5f, -0.5f, 0.5f);
                    poseStack.method_22904(0.0, 0.1, 0.0);
                    poseStack.method_22907(class_7833.field_40716.rotationDegrees(class_310.method_1551().field_1773.method_19418().method_19330() - 180.0f));
                    ClientHandlers.getAnimatedPlayerModel().copyTo((class_572)renderer.method_4038());
                    if (ClientConfig.renderHand) {
                        ((class_591)renderer.method_4038()).field_27433.method_22698(poseStack, buffer.getBuffer(class_1921.method_23572((class_2960)player.method_52814().comp_1626())), combinedLight, class_4608.field_21444);
                        ((class_591)renderer.method_4038()).field_3484.method_22698(poseStack, buffer.getBuffer(class_1921.method_23572((class_2960)player.method_52814().comp_1626())), combinedLight, class_4608.field_21444);
                        ((class_591)renderer.method_4038()).field_3401.method_22698(poseStack, buffer.getBuffer(class_1921.method_23572((class_2960)player.method_52814().comp_1626())), combinedLight, class_4608.field_21444);
                        ((class_591)renderer.method_4038()).field_3486.method_22698(poseStack, buffer.getBuffer(class_1921.method_23572((class_2960)player.method_52814().comp_1626())), combinedLight, class_4608.field_21444);
                    }
                    if (!stack.method_57826((class_9331)RuneCraftoryDataComponentTypes.INVISIBLE.get())) {
                        poseStack.method_22903();
                        ((class_591)renderer.method_4038()).method_2803(leftHand ? class_1306.field_6182 : class_1306.field_6183, poseStack);
                        poseStack.method_22907(class_7833.field_40714.rotationDegrees(-90.0f));
                        poseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
                        poseStack.method_22904(0.0625, 0.125, -0.625);
                        class_310.method_1551().method_1480().method_23177(livingEntity, stack, transformType, leftHand, poseStack, buffer, livingEntity.method_37908(), combinedLight, class_4608.field_21444, livingEntity.method_5628() + transformType.ordinal());
                        poseStack.method_22909();
                    }
                    if (!(stack = player.method_6079()).method_7960() && !stack.method_57826((class_9331)RuneCraftoryDataComponentTypes.INVISIBLE.get())) {
                        poseStack.method_22903();
                        ((class_591)renderer.method_4038()).method_2803(leftHand ? class_1306.field_6183 : class_1306.field_6182, poseStack);
                        poseStack.method_22907(class_7833.field_40714.rotationDegrees(-90.0f));
                        poseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
                        poseStack.method_22904(-0.0625, 0.125, -0.625);
                        class_310.method_1551().method_1480().method_23177(livingEntity, stack, transformType, leftHand, poseStack, buffer, livingEntity.method_37908(), combinedLight, class_4608.field_21444, livingEntity.method_5628() + transformType.ordinal());
                        poseStack.method_22909();
                    }
                    poseStack.method_22909();
                    return true;
                }
            }
        }
        AnimatedItemHandRendering = false;
        return stack.method_57826((class_9331)RuneCraftoryDataComponentTypes.INVISIBLE.get());
    }

    public static ModelPartsContainer.ModelPartExtended createPlayerItemPart(boolean left) {
        class_630 item = new class_630(List.of(), Map.of());
        item.method_32085(class_5603.method_32090((float)(left ? -1.0f : 1.0f), (float)-8.0f, (float)0.0f));
        class_630 root = new class_630(List.of(), Map.of(left ? "LeftItem" : "RightItem", item));
        root.method_32085(class_5603.method_32090((float)(left ? 1.0f : -1.0f), (float)8.0f, (float)0.0f));
        return new ModelPartsContainer.ModelPartExtended("root", null, root);
    }

    record SeasonedTint(int origin, Season season) {
    }
}

