/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.mixinhelper;

import io.github.flemmli97.runecraftory.api.registry.ArmorEffect;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.entities.utils.IBaseMob;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryArmorEffects;
import io.github.flemmli97.runecraftory.common.world.data.farming.FarmlandHandler;
import io.github.flemmli97.runecraftory.mixin.CropBlockAccessor;
import io.github.flemmli97.runecraftory.mixinhelper.PrevEntityPosition;
import io.github.flemmli97.runecraftory.platform.Platform;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3966;
import net.minecraft.class_4050;
import net.minecraft.class_6880;

public class MixinUtils {
    public static boolean playerPose(class_1657 player) {
        PlayerData data = Platform.INSTANCE.getPlayerData(player);
        class_4050 pose = data.getWeaponHandler().getCurrentAction().getPose((class_1309)player, data.getWeaponHandler());
        if (pose != null) {
            if (player.method_18376() != pose) {
                player.method_18380(pose);
            }
            return true;
        }
        return false;
    }

    public static void onPlayerThrowItem(class_1657 player, class_1542 entity) {
        if (!player.method_29504()) {
            entity.method_6981((class_1297)player);
            PrevEntityPosition pos = (PrevEntityPosition)player;
            double dX = player.method_23317() - pos.runecraftory$getOldPlayerX();
            double dZ = player.method_23321() - pos.runecraftory$getOldPlayerZ();
            double spd = dX * dX + dZ * dZ;
            if (spd > 0.01) {
                double scale = ArmorEffect.hasArmorEffect((class_1309)player, (class_6880<ArmorEffect>)RuneCraftoryArmorEffects.THROWING_RING.asHolder()) ? 2.5 : 1.7;
                entity.method_18799(entity.method_18798().method_1021(scale));
            }
        }
    }

    public static boolean handleEntityCollision(class_1542 entity) {
        if (entity.method_5799() || entity.method_5771() || entity.method_24921() == null || entity.method_37908().field_9236) {
            return true;
        }
        class_239 hitResult = class_1675.method_49997((class_1297)entity, t -> MixinUtils.canHitEntity(entity, t));
        if (hitResult.method_17783() == class_239.class_240.field_1332) {
            return true;
        }
        if (hitResult.method_17783() == class_239.class_240.field_1331) {
            class_3966 result = (class_3966)hitResult;
            class_1297 class_12972 = result.method_17782();
            if (class_12972 instanceof IBaseMob) {
                class_1657 thrower;
                IBaseMob mob = (IBaseMob)class_12972;
                class_1799 stack = entity.method_6983();
                class_1297 e = entity.method_24921();
                if (e instanceof class_1657 && mob.onGivingItem(thrower = (class_1657)e, stack) && stack.method_7960()) {
                    entity.method_31472();
                }
            }
            return true;
        }
        return false;
    }

    protected static boolean canHitEntity(class_1542 entity, class_1297 target) {
        class_1297 owner;
        if (target.method_7325() || !target.method_5805() || !target.method_5863() || (owner = entity.method_24921()) == null) {
            return false;
        }
        return !target.method_5667().equals(owner.method_5667());
    }

    public static void onBlockStateChange(class_3218 level, class_2338 pos, class_2680 blockState, class_2680 newState) {
        if (FarmlandHandler.isFarmBlock(newState)) {
            if (!FarmlandHandler.isFarmBlock(blockState) || FarmlandHandler.get(level.method_8503()).getData(level, pos).isEmpty()) {
                FarmlandHandler.get(level.method_8503()).onFarmlandPlace(level, pos);
            }
        } else if (FarmlandHandler.isFarmBlock(blockState)) {
            FarmlandHandler.get(level.method_8503()).onFarmlandRemove(level, pos);
        } else {
            class_2248 class_22482 = blockState.method_26204();
            if (class_22482 instanceof class_2302) {
                class_2302 pre = (class_2302)class_22482;
                class_2248 class_22483 = newState.method_26204();
                if (!(class_22483 instanceof class_2302)) {
                    FarmlandHandler.get(level.method_8503()).getData(level, pos.method_10074()).ifPresent(d -> d.onCropRemove(level, pos, newState));
                } else {
                    class_2302 post = (class_2302)class_22483;
                    if ((Integer)blockState.method_11654((class_2769)((CropBlockAccessor)pre).cropAgeProperty()) > (Integer)newState.method_11654((class_2769)((CropBlockAccessor)post).cropAgeProperty())) {
                        FarmlandHandler.get(level.method_8503()).getData(level, pos.method_10074()).ifPresent(d -> d.onRegrowableHarvest(level, pos, newState));
                    }
                }
            }
        }
    }

    public static void recheckFarmland(class_3218 level, class_2680 state, class_2338 pos) {
        if (FarmlandHandler.get(level.method_8503()).getData(level, pos).map(d -> !d.isFarmBlock()).orElse(true).booleanValue()) {
            FarmlandHandler.get(level.method_8503()).onFarmlandPlace(level, pos);
        }
    }

    public static void triggerArmorStepEffect(class_1309 living) {
        for (class_1304 slot : class_1304.values()) {
            if (slot.method_5925() != class_1304.class_1305.field_6178) continue;
            class_1799 stack = living.method_6118(slot);
            ArmorEffect.runArmorEffectFor(stack, effect -> effect.onStep(living, stack));
        }
    }
}

