/*
 * Decompiled with CFR 0.152.
 */
package com.Minecrafox.ttos.utils.handlers;

import com.Minecrafox.ttos.init.BiomeInit;
import com.Minecrafox.ttos.init.BlockInit;
import com.Minecrafox.ttos.init.ItemInit;
import com.Minecrafox.ttos.recipes.CraftingRecipes;
import com.Minecrafox.ttos.utils.interfaces.IHasModel;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class RegistryHandler {
    @SubscribeEvent
    public static void onItemRegister(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])ItemInit.ITEMS.toArray(new Item[0]));
    }

    @SubscribeEvent
    public static void onModelRegister(ModelRegistryEvent event) {
        for (Item item : ItemInit.ITEMS) {
            if (!(item instanceof IHasModel)) continue;
            ((IHasModel)item).registerModels();
        }
        for (Block block : BlockInit.BLOCKS) {
            if (!(block instanceof IHasModel)) continue;
            ((IHasModel)block).registerModels();
        }
    }

    @SubscribeEvent
    public static void onBlockRegister(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])BlockInit.BLOCKS.toArray(new Block[0]));
    }

    public static void preInitRegistries() {
        BiomeInit.regiterBiomes();
    }

    public static void initRegistries() {
        CraftingRecipes.init();
    }

    public static void postInitRegistries() {
    }

    public static void serverRegistries(FMLServerStartingEvent event) {
    }
}

