/*
 * Decompiled with CFR 0.152.
 */
package r0lanoff.adelcheck;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class Adelcheck
extends JavaPlugin
implements CommandExecutor,
Listener {
    private final Map<Player, Boolean> frozenPlayers = new HashMap<Player, Boolean>();
    private final Map<Player, Player> checkerPlayers = new HashMap<Player, Player>();

    public void onEnable() {
        this.saveDefaultConfig();
        this.getCommand("check").setExecutor((CommandExecutor)this);
        this.getCommand("uncheck").setExecutor((CommandExecutor)this);
        this.getCommand("contact").setExecutor((CommandExecutor)this);
        this.getCommand("ac").setExecutor((CommandExecutor)this);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.getConfigMessage("messages.onlyPlayer"));
            return true;
        }
        Player player = (Player)sender;
        if (cmd.getName().equalsIgnoreCase("check")) {
            if (!player.hasPermission("r0lanoff.check")) {
                sender.sendMessage(this.getConfigMessage("messages.noPermission"));
                return true;
            }
            if (args.length != 1) {
                sender.sendMessage(this.getConfigMessage("messages.usageCheck"));
                return true;
            }
            String playerName = args[0];
            Player checkerPlayer = Bukkit.getPlayer((String)playerName);
            if (checkerPlayer == null) {
                sender.sendMessage(this.getConfigMessage("messages.check.playerNotOnline").replace("%player%", playerName));
                return true;
            }
            this.freezePlayer(checkerPlayer);
            this.frozenPlayers.put(checkerPlayer, true);
            this.checkerPlayers.put(checkerPlayer, player);
            checkerPlayer.sendMessage(this.getConfigMessage("messages.check.startCheck"));
            this.showTitle(checkerPlayer);
            player.sendMessage(this.getConfigMessage("messages.check.startCheckNotifier").replace("%player%", playerName));
        } else if (cmd.getName().equalsIgnoreCase("uncheck")) {
            if (!player.hasPermission("r0lanoff.uncheck")) {
                sender.sendMessage(this.getConfigMessage("messages.noPermission"));
                return true;
            }
            if (args.length != 1) {
                sender.sendMessage(this.getConfigMessage("messages.usageUncheck"));
                return true;
            }
            String playerName = args[0];
            Player checkerPlayer = Bukkit.getPlayer((String)playerName);
            if (checkerPlayer == null) {
                sender.sendMessage(this.getConfigMessage("messages.uncheck.playerNotOnline").replace("%player%", playerName));
                return true;
            }
            this.unfreezePlayer(checkerPlayer);
            this.frozenPlayers.remove(checkerPlayer);
            this.checkerPlayers.remove(checkerPlayer);
            sender.sendMessage(this.getConfigMessage("messages.uncheck.stopCheck").replace("%player%", playerName));
        } else if (cmd.getName().equalsIgnoreCase("contact")) {
            if (args.length < 1) {
                sender.sendMessage(this.getConfigMessage("messages.contact.usage"));
                return true;
            }
            if (!this.checkerPlayers.containsKey(player)) {
                sender.sendMessage(this.getConfigMessage("messages.contact.notUnderCheck"));
                return true;
            }
            StringBuilder message = new StringBuilder();
            for (String arg : args) {
                message.append(arg).append(" ");
            }
            Player checkerPlayer = this.checkerPlayers.get(player);
            checkerPlayer.sendMessage(this.getConfigMessage("messages.contact.messageReceived").replace("%player%", player.getName()).replace("%message%", message.toString().trim()));
            player.sendMessage(this.getConfigMessage("messages.contact.messageSent").replace("%player%", checkerPlayer.getName()));
        } else if (cmd.getName().equalsIgnoreCase("ac")) {
            if (args.length == 1 && args[0].equalsIgnoreCase("reload")) {
                if (!player.hasPermission("ac.reload")) {
                    sender.sendMessage(this.getConfigMessage("messages.noPermission"));
                    return true;
                }
                this.reloadConfig();
                sender.sendMessage("\u00a7a\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u0430.");
                return true;
            }
            sender.sendMessage("\u00a7c\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435: /ac reload");
            return true;
        }
        return true;
    }

    private void freezePlayer(Player player) {
        if (player == null) {
            this.getLogger().warning("Player is null!");
        } else {
            player.setWalkSpeed(0.0f);
            player.setAllowFlight(false);
            player.setFlying(false);
            player.addPotionEffect(new PotionEffect(PotionEffectType.JUMP_BOOST, Integer.MAX_VALUE, -10, false, false));
            player.addPotionEffect(new PotionEffect(PotionEffectType.WEAKNESS, Integer.MAX_VALUE, 255, false, false));
        }
    }

    private void unfreezePlayer(Player player) {
        if (player == null) {
            this.getLogger().warning("Player is null!");
        } else {
            player.setWalkSpeed(0.2f);
            player.setAllowFlight(false);
            player.removePotionEffect(PotionEffectType.JUMP_BOOST);
            player.removePotionEffect(PotionEffectType.WEAKNESS);
            player.sendTitle("", "", 0, 1, 0);
        }
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        if (this.frozenPlayers.containsKey(player)) {
            event.setTo(event.getFrom());
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (this.frozenPlayers.containsKey(player)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        Player player;
        if (event.getEntity() instanceof Player && this.frozenPlayers.containsKey(player = (Player)event.getEntity())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        Player damager;
        if (event.getDamager() instanceof Player && this.frozenPlayers.containsKey(damager = (Player)event.getDamager())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (this.frozenPlayers.containsKey(player)) {
            this.frozenPlayers.remove(player);
            this.checkerPlayers.remove(player);
        }
    }

    private void showTitle(final Player player) {
        final FileConfiguration config = this.getConfig();
        new BukkitRunnable(){

            public void run() {
                if (Adelcheck.this.frozenPlayers.containsKey(player)) {
                    player.sendTitle(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("titles.checkTitle")), ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("titles.checkSubtitle")), config.getInt("titles.checkFadeIn"), config.getInt("titles.checkStay"), config.getInt("titles.checkFadeOut"));
                } else {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this, 0L, 60L);
    }

    private String getConfigMessage(String path) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString(path, "Message not found in config: " + path));
    }
}

