#version 150

#moj_import <fog.glsl>

uniform sampler2D Sampler0;

uniform vec4 ColorModulator;
uniform float FogStart;
uniform float FogEnd;
uniform vec4 FogColor;

in float vertexDistance;
in vec4 vertexColor;
in vec2 texCoord0;

out vec4 fragColor;

void main() {
    vec4 color;
    vec4 lodColor = textureLod(Sampler0, texCoord0, 0.0);
    if (lodColor.a < 5.0 / 100.0 && lodColor.a > 3.0 / 100) {
        discard;
    }
    if (lodColor.a == 1.0) {
        color = texture(Sampler0, texCoord0) * ColorModulator * vertexColor;
    } else {
        color = lodColor * 1.25;
        color.a = 1.0;
    }
    fragColor = linear_fog(color, vertexDistance, FogStart, FogEnd, FogColor);
}
