/*
 * Decompiled with CFR 0.152.
 */
package me.mraxetv.beastwithdraw.listener;

import me.mraxetv.beastlib.lib.nbtapi.NBTItem;
import me.mraxetv.beastwithdraw.BeastWithdrawPlugin;
import me.mraxetv.beastwithdraw.managers.AssetHandler;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.plugin.Plugin;

public class ItemDropListener
implements Listener {
    private BeastWithdrawPlugin pl;

    public ItemDropListener(BeastWithdrawPlugin pl) {
        this.pl = pl;
        pl.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)pl);
    }

    @EventHandler
    public void itemDrop(PlayerDropItemEvent e) {
        if (!e.getItemDrop().getItemStack().hasItemMeta()) {
            return;
        }
        NBTItem nbtItem = new NBTItem(e.getItemDrop().getItemStack());
        if (!nbtItem.hasTag("RedeemType")) {
            return;
        }
        String type = nbtItem.getString("RedeemType").toLowerCase();
        AssetHandler assetHandler = this.pl.getWithdrawManager().getAssetHandler(type);
        if (assetHandler.getConfig().isSet("Settings.CustomName")) {
            String hologram = assetHandler.getConfig().getString("Settings.CustomName");
            hologram = hologram.replace("%amount%", assetHandler.formatWithPreSuffix(nbtItem.getDouble(assetHandler.getNbtTag())));
            hologram = this.pl.getUtils().setPlaceholders(e.getPlayer(), hologram);
            e.getItemDrop().setCustomName(hologram);
            e.getItemDrop().setCustomNameVisible(true);
        }
    }
}

