/*
 * Decompiled with CFR 0.152.
 */
package me.mraxetv.beastwithdraw.utils;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import me.mraxetv.beastlib.utils.BUtils;
import me.mraxetv.beastwithdraw.BeastWithdrawPlugin;
import me.mraxetv.beastwithdraw.utils.ConfigLang;
import me.mraxetv.beastwithdraw.utils.MessagesLang;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.java.JavaPlugin;

public class Utils
extends BUtils
implements Listener {
    private BeastWithdrawPlugin pl;
    private String version;
    public static DecimalFormat df2;

    public Utils(BeastWithdrawPlugin plugin) {
        super((JavaPlugin)plugin);
        this.pl = plugin;
        df2 = this.pl.getConfig().getBoolean("Settings.DisableDecimalAmounts") ? new DecimalFormat("#", DecimalFormatSymbols.getInstance(Locale.ENGLISH)) : new DecimalFormat("0.00", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        df2.setRoundingMode(RoundingMode.DOWN);
    }

    public String getPrefix() {
        return Utils.setColor((String)BeastWithdrawPlugin.getInstance().getMessages().getString("Prefix"));
    }

    public static String formatStackSize(String message, int amount) {
        if (amount <= 1) {
            return message.replaceAll("%stack%", "");
        }
        return message.replaceAll("%stack%", MessagesLang.STACK_SIZE.replaceAll("%amount%", "" + amount));
    }

    public void sendMessage(CommandSender sender, String message) {
        if (sender instanceof Player) {
            message = this.setPlaceholders((Player)sender, message);
        }
        message = message.replaceAll("%prefix%", this.getPrefix());
        sender.sendMessage(Utils.setColor((String)message));
    }

    public void sendMessage(Player sender, String message) {
        sender.sendMessage(this.setPlaceholders(sender, message));
    }

    public void sendMessage(Player sender, String message, MessageType type) {
        switch (type) {
            case CHAT: {
                sender.sendMessage(this.setPlaceholders(sender, message));
                break;
            }
            case ACTION_BAR: {
                sender.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacy((String)this.setPlaceholders(sender, message)));
                break;
            }
            default: {
                sender.sendMessage(this.setPlaceholders(sender, message));
            }
        }
    }

    public void sendLog(String s) {
        s = ChatColor.translateAlternateColorCodes((char)'&', (String)s);
        this.pl.getServer().getConsoleSender().sendMessage(this.getPrefix() + s);
    }

    public static boolean isInt(String value) {
        try {
            Integer.parseInt(value);
        }
        catch (Exception efr) {
            return false;
        }
        return true;
    }

    public static boolean isDouble(String value) {
        try {
            Double.parseDouble(value);
        }
        catch (Exception efr) {
            return false;
        }
        return true;
    }

    public String setPlaceholders(Player p, String s) {
        s = s.replaceAll("%prefix%", this.getPrefix());
        s = s.replaceAll("%player%", p.getName());
        s = Utils.setColor((String)s);
        return s;
    }

    public void noPermission(Player p) {
        this.sendMessage(p, this.pl.getMessages().getString("Withdraws.NoPermission"));
    }

    public static String formatDouble(double number) {
        return ConfigLang.NUMBER_FORMAT.format(number);
    }

    public static String formatNumber(int number) {
        return NumberFormat.getInstance(Locale.ENGLISH).format(number);
    }

    public static enum MessageType {
        CHAT,
        ACTION_BAR;

    }
}

