/*
 * Decompiled with CFR 0.152.
 */
package me.mraxetv.beastwithdraw.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import me.mraxetv.beastlib.commands.builder.ShortCommand;
import me.mraxetv.beastwithdraw.BeastWithdrawPlugin;
import me.mraxetv.beastwithdraw.managers.AssetHandler;
import me.mraxetv.beastwithdraw.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;

public class WithdrawCMD
extends ShortCommand {
    private final BeastWithdrawPlugin pl;
    private final AssetHandler assetHandler;

    public WithdrawCMD(BeastWithdrawPlugin pl, AssetHandler assetHandler) {
        super((JavaPlugin)pl, assetHandler.getID(), assetHandler.getConfig().getStringList("Settings.Aliases"), "BeastWithdraw." + assetHandler.getID() + ".Withdraw");
        this.pl = pl;
        this.assetHandler = assetHandler;
    }

    public boolean execute(CommandSender sender, String cmd, String[] args) {
        if (!(sender instanceof Player)) {
            this.pl.getUtils().sendMessage(sender, "%prefix% Console can't use this command! /BeastWithdraw help");
            return true;
        }
        this.handleWithdraw((Player)sender, args);
        return true;
    }

    private void handleWithdraw(Player p, String[] args) {
        if (!p.hasPermission(this.getPermission())) {
            this.pl.getUtils().noPermission(p);
            return;
        }
        if (args.length == 0) {
            this.sendHelpMessage(p);
            return;
        }
        int stackSize = this.parseStackSize(p, args);
        if (stackSize == -1) {
            return;
        }
        double balance = this.assetHandler.getBalance(p);
        double takenAmount = this.parseWithdrawAmount(p, args[0], balance);
        if (takenAmount == -1.0) {
            return;
        }
        if (!this.validateInventorySpace(p)) {
            return;
        }
        if (!this.validateWithdrawLimits(p, takenAmount)) {
            return;
        }
        if (!this.validateBigAmount(p, takenAmount, stackSize)) {
            return;
        }
        if (!this.validateBalance(p, balance, takenAmount, stackSize)) {
            return;
        }
        if (!this.chargeFee(p, stackSize)) {
            return;
        }
        this.performWithdraw(p, takenAmount, stackSize);
    }

    protected void sendHelpMessage(Player p) {
        String helpMessage = this.assetHandler.getMessageSection().getString("Help");
        helpMessage = helpMessage.replaceAll("%balance%", this.assetHandler.formatWithPreSuffix(this.assetHandler.getBalance(p)));
        helpMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)helpMessage);
        this.pl.getUtils().sendMessage(p, helpMessage);
    }

    protected int parseStackSize(Player p, String[] args) {
        int maxStack;
        int stackSize;
        if (args.length != 2) {
            return 1;
        }
        if (!Utils.isInt(args[1])) {
            String s = this.pl.getMessages().getString("Withdraws.InvalidNumber");
            s = s.replace("%amount%", args[1]);
            this.pl.getUtils().sendMessage(p, s);
        }
        if ((stackSize = Math.abs(Integer.parseInt(args[1]))) > (maxStack = this.assetHandler.getConfig().getInt("Settings.MaxStackSize", 64))) {
            String s = this.assetHandler.getMessageSection().getString("MaxStackSize");
            s = s.replace("%stack%", Utils.formatNumber(stackSize));
            this.pl.getUtils().sendMessage(p, s);
            return maxStack;
        }
        return Math.max(stackSize, 1);
    }

    protected double parseWithdrawAmount(Player p, String arg, double balance) {
        if (arg.equalsIgnoreCase("all")) {
            if (!p.hasPermission(this.getPermission() + ".All")) {
                this.pl.getUtils().noPermission(p);
                return -1.0;
            }
            return balance;
        }
        if (!Utils.isInt(arg)) {
            String s = this.pl.getMessages().getString("Withdraws.InvalidNumber");
            s = s.replace("%amount%", arg);
            this.pl.getUtils().sendMessage(p, s);
            return -1.0;
        }
        return Math.abs(Double.parseDouble(arg));
    }

    protected boolean validateInventorySpace(Player p) {
        if (this.pl.getConfig().getBoolean("Settings.WithdrawDropFloor")) {
            return true;
        }
        if (p.getInventory().firstEmpty() == -1) {
            String s = this.pl.getMessages().getString("Withdraws.FullInventory");
            this.pl.getUtils().sendMessage(p, s);
            return false;
        }
        return true;
    }

    protected boolean validateWithdrawLimits(Player p, double takenAmount) {
        double min = this.getPermissionMin(p);
        double max = this.getPermissionMax(p);
        if (takenAmount <= 0.0 || takenAmount < min) {
            String s = this.assetHandler.getMessageSection().getString("Min");
            s = s.replace("%min-amount%", this.assetHandler.formatNumber(min));
            this.pl.getUtils().sendMessage(p, s);
            return false;
        }
        if (takenAmount > max) {
            String s = this.assetHandler.getMessageSection().getString("Max");
            s = s.replace("%max-amount%", this.assetHandler.formatNumber(max));
            this.pl.getUtils().sendMessage(p, s);
            return false;
        }
        return true;
    }

    private double getPermissionMin(Player p) {
        double min = this.assetHandler.getConfig().getDouble("Settings.Min");
        if (this.assetHandler.getConfig().getBoolean("Settings.PermissionNotes.Enabled")) {
            for (String key : this.assetHandler.getConfig().getConfigurationSection("Settings.PermissionNotes").getKeys(false)) {
                if (!p.isPermissionSet("BeastWithdraw." + this.assetHandler.getID() + ".PermissionNotes." + key)) continue;
                min = this.assetHandler.getConfig().getDouble("Settings.PermissionNotes." + key + ".Min");
            }
        }
        return min;
    }

    private double getPermissionMax(Player p) {
        double max = this.assetHandler.getConfig().getDouble("Settings.Max");
        if (this.assetHandler.getConfig().getBoolean("Settings.PermissionNotes.Enabled")) {
            for (String key : this.assetHandler.getConfig().getConfigurationSection("Settings.PermissionNotes").getKeys(false)) {
                if (!p.isPermissionSet("BeastWithdraw." + this.assetHandler.getID() + ".PermissionNotes." + key)) continue;
                max = this.assetHandler.getConfig().getDouble("Settings.PermissionNotes." + key + ".Max");
            }
        }
        return max;
    }

    protected boolean validateBigAmount(Player p, double takenAmount, int stackSize) {
        if (this.assetHandler.isToBigAmount(takenAmount * (double)stackSize)) {
            String s = this.assetHandler.getMessageSection().getString("ToBigNumber");
            s = s.replace("%amount%", this.assetHandler.formatWithPreSuffix(takenAmount * (double)stackSize));
            this.pl.getUtils().sendMessage(p, s);
            return false;
        }
        return true;
    }

    protected boolean validateBalance(Player p, double balance, double takenAmount, int stackSize) {
        if (balance < takenAmount * (double)stackSize) {
            String msg = this.assetHandler.getMessageSection().getString("NotEnough");
            msg = msg.replace("%balance%", this.assetHandler.formatWithPreSuffix(balance));
            msg = msg.replace("%amount%", this.assetHandler.formatWithPreSuffix(takenAmount * (double)stackSize));
            this.pl.getUtils().sendMessage(p, msg);
            return false;
        }
        return true;
    }

    protected boolean chargeFee(Player p, int stackSize) {
        if (p.hasPermission("BeastWithdraw." + this.assetHandler.getID() + ".ByPass.Fee")) {
            return true;
        }
        if (!this.assetHandler.getConfig().getBoolean("Settings.Charges.Fee.Enabled")) {
            return true;
        }
        double fee = this.assetHandler.getConfig().getDouble("Settings.Charges.Fee.Cost") * (double)stackSize;
        double balance = this.assetHandler.getBalance(p);
        if (balance < fee) {
            String s = this.assetHandler.getMessageSection().getString("Tax.NotEnough");
            s = s.replace("%amount%", this.assetHandler.formatWithPreSuffix(fee));
            this.pl.getUtils().sendMessage(p, s);
            return false;
        }
        this.assetHandler.withdrawAmount(p, fee);
        String s = this.assetHandler.getMessageSection().getString("Tax.TakenFee");
        s = s.replace("%fee%", this.assetHandler.formatWithPreSuffix(fee));
        this.pl.getUtils().sendMessage(p, s);
        return true;
    }

    protected void performWithdraw(Player p, double takenAmount, int stackSize) {
        this.assetHandler.withdrawAmount(p, takenAmount * (double)stackSize);
        String s = this.assetHandler.getMessageSection().getString("Withdraw");
        s = s.replace("%amount%", this.assetHandler.formatWithPreSuffix(takenAmount));
        s = Utils.formatStackSize(s, stackSize);
        s = s.replace("%balance%", this.assetHandler.formatWithPreSuffix(this.assetHandler.getBalance(p)));
        this.pl.getUtils().sendMessage(p, s);
        double tax = this.calculateTax(p);
        ItemStack item = this.assetHandler.getItem(p.getName(), takenAmount, stackSize, true, tax);
        if (p.getInventory().firstEmpty() != -1) {
            Utils.addItem((Player)p, (ItemStack)item);
        } else {
            p.getWorld().dropItem(p.getLocation(), item);
        }
        this.playWithdrawSound(p);
    }

    protected double calculateTax(Player p) {
        if (p.hasPermission("BeastWithdraw." + this.assetHandler.getID() + ".ByPass.Tax")) {
            return 0.0;
        }
        double tax = this.assetHandler.getConfig().getDouble("Settings.Charges.Tax.Percentage");
        if (this.assetHandler.getConfig().getBoolean("Settings.PermissionNotes.Enabled")) {
            for (String key : this.assetHandler.getConfig().getConfigurationSection("Settings.PermissionNotes").getKeys(false)) {
                if (!p.isPermissionSet("BeastWithdraw." + this.assetHandler.getID() + ".PermissionNotes." + key)) continue;
                tax = this.assetHandler.getConfig().getDouble("Settings.PermissionNotes." + key + ".Tax.Percentage");
            }
        }
        return tax;
    }

    protected void playWithdrawSound(Player p) {
        if (!this.assetHandler.getConfig().getBoolean("Settings.Sounds.Withdraw.Enabled")) {
            return;
        }
        try {
            String sound = this.assetHandler.getConfig().getString("Settings.Sounds.Withdraw.Sound");
            p.playSound(p.getLocation(), Sound.valueOf((String)sound), 1.0f, 1.0f);
        }
        catch (Exception e) {
            ConsoleCommandSender consoleCommandSender = Bukkit.getConsoleSender();
            StringBuilder stringBuilder = new StringBuilder();
            this.pl.getUtils();
            consoleCommandSender.sendMessage(stringBuilder.append(Utils.getPrefix()).append("\u00a7cBroken sound in ").append(this.assetHandler.getID()).append(" Withdraw section!").toString());
        }
    }

    public List<String> tabComplete(CommandSender sender, String alias, String[] args) {
        if (!(sender instanceof Player)) {
            return Collections.emptyList();
        }
        ArrayList<String> suggestions = new ArrayList<String>();
        if (args.length == 1) {
            suggestions.add("all");
            suggestions.add("100");
            suggestions.add("1000");
            suggestions.add("10000");
        } else if (args.length == 2) {
            suggestions.add("1");
            suggestions.add("5");
            suggestions.add("10");
            suggestions.add("64");
        }
        return suggestions.stream().filter(s -> s.toLowerCase().startsWith(args[args.length - 1].toLowerCase())).collect(Collectors.toList());
    }
}

