/*
 * Decompiled with CFR 0.152.
 */
package me.mraxetv.beastwithdraw.listener;

import java.util.HashSet;
import java.util.UUID;
import me.mraxetv.beastlib.lib.nbtapi.NBTItem;
import me.mraxetv.beastlib.lib.nbtapi.utils.MinecraftVersion;
import me.mraxetv.beastlib.lib.xmaterials.XMaterial;
import me.mraxetv.beastwithdraw.BeastWithdrawPlugin;
import me.mraxetv.beastwithdraw.events.BottleRedeemEvent;
import me.mraxetv.beastwithdraw.managers.assets.XpBottleHandler;
import me.mraxetv.beastwithdraw.utils.Utils;
import me.mraxetv.beastwithdraw.utils.XpManager;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ExpBottleEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class XpBottleRedeemListener
implements Listener {
    private BeastWithdrawPlugin pl;
    private HashSet<UUID> delayList;
    private boolean autoCollect = false;
    private XpBottleHandler assetHandler;

    public XpBottleRedeemListener(BeastWithdrawPlugin plugin, XpBottleHandler assetHandler) {
        this.pl = plugin;
        this.assetHandler = assetHandler;
        this.pl.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.pl);
        this.delayList = new HashSet();
        this.autoCollect = assetHandler.getConfig().getBoolean("Settings.AutoCollect");
        if (!this.autoCollect && assetHandler.getMaterial() != XMaterial.EXPERIENCE_BOTTLE.parseMaterial()) {
            this.autoCollect = true;
        }
    }

    @EventHandler
    public void redeemEvent(BottleRedeemEvent e) {
        Player p = e.getPlayer();
        if (e.isCancelled()) {
            return;
        }
        ItemStack item = e.getItem();
        int tax = (int)Math.ceil(this.assetHandler.calculateTax(p, e.getAmount(), e.getItem()));
        int amount = (int)e.getAmount() - tax;
        if (this.autoCollect) {
            XpManager.setTotalExperience(p, XpManager.getTotalExperience(p) + amount);
            String msg = tax == 0 ? this.assetHandler.getMessageSection().getString("Redeem") : this.assetHandler.getMessageSection().getString("RedeemAndTax");
            msg = msg.replace("%amount%", "" + this.assetHandler.formatWithPreSuffix(amount));
            msg = msg.replace("%balance%", "" + this.assetHandler.formatWithPreSuffix(this.assetHandler.getBalance(p)));
            msg = msg.replace("%tax%", "" + this.assetHandler.formatWithPreSuffix(tax));
            this.pl.getUtils().sendMessage(p, msg);
        } else {
            ThrownExpBottle t = (ThrownExpBottle)e.getPlayer().launchProjectile(ThrownExpBottle.class);
            if (MinecraftVersion.isAtLeastVersion((MinecraftVersion)MinecraftVersion.MC1_15_R1)) {
                t.setItem(item);
            } else {
                t.setCustomName("XPB:" + amount);
            }
        }
        if (this.assetHandler.getConfig().getBoolean("Settings.Sounds.Redeem.Enabled")) {
            try {
                String sound = this.assetHandler.getConfig().getString("Settings.Sounds.Redeem.Sound");
                p.playSound(p.getLocation(), Sound.valueOf((String)sound), 1.0f, 1.0f);
            }
            catch (Exception e1) {
                ConsoleCommandSender consoleCommandSender = Bukkit.getServer().getConsoleSender();
                StringBuilder stringBuilder = new StringBuilder();
                this.pl.getUtils();
                consoleCommandSender.sendMessage(stringBuilder.append(Utils.getPrefix()).append("\u00a7cBroken sound in XpBottle Redeem section!").toString());
            }
        }
        if (item.getAmount() > 1) {
            item.setAmount(item.getAmount() - 1);
        } else if (e.isOffHand()) {
            p.getInventory().setItemInOffHand(null);
        } else {
            p.getInventory().removeItem(new ItemStack[]{item});
        }
        p.updateInventory();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void xpThrow(ExpBottleEvent e) {
        if (MinecraftVersion.isAtLeastVersion((MinecraftVersion)MinecraftVersion.MC1_15_R1)) {
            ThrownExpBottle thrownExpBottle = e.getEntity();
            if (thrownExpBottle == null) {
                return;
            }
            NBTItem nbtItem = new NBTItem(e.getEntity().getItem());
            if (!nbtItem.hasKey(this.assetHandler.getConfig().getString("Settings.NBTKey")).booleanValue()) {
                return;
            }
            int xp = nbtItem.getInteger(this.assetHandler.getConfig().getString("Settings.NBTKey"));
            e.setExperience(xp - (int)this.assetHandler.calculateTax((Player)e.getEntity().getShooter(), xp, e.getEntity().getItem()));
        } else {
            if (e.getEntity().getCustomName() == null) {
                return;
            }
            if (!e.getEntity().getCustomName().startsWith("XPB:")) {
                return;
            }
            int xp = Integer.parseInt(e.getEntity().getCustomName().replaceAll("XPB:", ""));
            e.setExperience(xp);
        }
    }

    @EventHandler
    public void playerDeath(PlayerDeathEvent e) {
        if (!this.assetHandler.getConfig().getBoolean("Settings.DropOnDeath")) {
            return;
        }
        Player p = e.getEntity();
        if (!p.hasPermission("BeastWithdraw.XpBottle.Drop")) {
            return;
        }
        int xp = XpManager.getTotalExperience(p);
        if (xp <= 0) {
            return;
        }
        double dropPercentage = this.assetHandler.getConfig().getDouble("Settings.DropPercentage") / 100.0;
        xp = (int)((double)xp * dropPercentage);
        ItemStack xpbItemStack = this.assetHandler.getItem(p.getName(), xp, 1, true, this.assetHandler.getConfig().getDouble("Settings.Charges.Tax.Percentage"));
        p.getWorld().dropItem(p.getLocation(), xpbItemStack);
        p.setTotalExperience(0);
        p.setLevel(0);
        p.setExp(0.0f);
        e.setDroppedExp(0);
    }
}

