/*
 * Decompiled with CFR 0.152.
 */
package me.mraxetv.beastwithdraw.managers;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import me.mraxetv.beastlib.commands.builder.ShortCommand;
import me.mraxetv.beastlib.lib.nbtapi.NBTItem;
import me.mraxetv.beastlib.lib.nbtapi.utils.MinecraftVersion;
import me.mraxetv.beastlib.lib.xmaterials.XMaterial;
import me.mraxetv.beastwithdraw.BeastWithdrawPlugin;
import me.mraxetv.beastwithdraw.filemanager.FolderYaml;
import me.mraxetv.beastwithdraw.utils.Utils;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class AssetHandler<T extends Number>
extends ShortCommand {
    private BeastWithdrawPlugin pl;
    private String id;
    private FolderYaml config;
    private Material material;
    private String nbtTag;
    private TreeMap<Integer, Integer> amountModels = new TreeMap(Collections.reverseOrder());
    private DecimalFormat decimalFormat;

    public AssetHandler(BeastWithdrawPlugin pl, String id) {
        super((JavaPlugin)pl, id, new ArrayList(), "");
        this.pl = pl;
        this.id = id;
        this.config = new FolderYaml(pl, "Withdraws", id + ".yml");
        this.material = this.getConfig().isSet("Settings.Item") ? ((XMaterial)XMaterial.matchXMaterial((String)this.getConfig().getString("Settings.Item")).get()).parseMaterial() : XMaterial.PAPER.parseMaterial();
        this.nbtTag = this.getConfig().getString("Settings.NBTKey");
        this.setFormat();
        if (!this.getConfig().getBoolean("Settings.CustomModel.AmountModelData.Enabled")) {
            return;
        }
        if (!this.getConfig().isSet("Settings.CustomModel.AmountModelData.Range")) {
            return;
        }
        for (String s : this.getConfig().getStringList("Settings.CustomModel.AmountModelData.Range")) {
            String[] data;
            String[] args = s.split("-");
            if (!Utils.isInt(args[0]) || !Utils.isInt((data = args[1].split(":"))[1])) continue;
            this.amountModels.put(Integer.parseInt(args[0]), Integer.parseInt(data[1]));
        }
    }

    protected void setFormat() {
        this.decimalFormat = new DecimalFormat(this.getConfig().getString("Settings.AmountFormat", "###,##0.00"), DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        this.decimalFormat.setRoundingMode(RoundingMode.HALF_DOWN);
    }

    protected void setMaterial(Material m) {
        this.material = m;
    }

    public Material getMaterial() {
        return this.material;
    }

    public String formatNumber(double amount) {
        return this.decimalFormat.format(amount);
    }

    public String formatNumber(int amount) {
        return this.decimalFormat.format(amount);
    }

    public String formatWithPreSuffix(double amount) {
        return this.getConfig().getString("Settings.Messages.Prefix", "") + this.formatNumber(amount) + this.getConfig().getString("Settings.Messages.Suffix", "");
    }

    public abstract Double getBalance(Player var1);

    public abstract void withdrawAmount(Player var1, Double var2);

    public abstract void depositAmount(Player var1, Double var2);

    public FileConfiguration getConfig() {
        return this.config.getConfig();
    }

    public abstract boolean isToBigAmount(double var1);

    public ItemStack getItem(String owner, double value, int amount, boolean signed, double tax) {
        List<String> lore;
        String n;
        ItemStack item = new ItemStack(this.material, amount);
        if (this.getConfig().isSet("Settings.Data")) {
            item.setDurability((short)this.getConfig().getInt("Settings.Data"));
        }
        ItemMeta meta = item.getItemMeta();
        if (MinecraftVersion.isAtLeastVersion((MinecraftVersion)MinecraftVersion.MC1_14_R1)) {
            if (this.hasAmountModels()) {
                for (int i : this.amountModels.keySet()) {
                    if (!(value >= (double)i)) continue;
                    meta.setCustomModelData(this.amountModels.get(i));
                    break;
                }
            } else {
                meta.setCustomModelData(Integer.valueOf(this.getConfig().getInt("Settings.CustomModel.Data")));
            }
        }
        if (this.getConfig().getBoolean("Settings.Glow")) {
            meta.addEnchant(Enchantment.DURABILITY, 1, true);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        if (signed) {
            n = this.getConfig().getString("Settings.Player.Name");
            n = n.replaceAll("%player%", owner);
            n = n.replaceAll("%amount%", "" + this.formatNumber(value));
            meta.setDisplayName(Utils.setColor((String)n));
            lore = new ArrayList();
            for (String s : this.getConfig().getStringList("Settings.Player.Lore")) {
                s = s.replace("%player%", "" + owner);
                if ((s = s.replace("%amount%", "" + this.formatNumber(value))).contains("%tax%") && tax == 0.0) continue;
                s = Utils.setColor((String)s);
                lore.add(s);
            }
            if (tax > 0.0) {
                lore = this.getFormattedLore(lore, owner, value, tax);
            }
            meta.setLore(lore);
        } else {
            n = this.getConfig().getString("Settings.Server.Name");
            n = n.replaceAll("%amount%", "" + this.formatNumber(value));
            meta.setDisplayName(Utils.setColor((String)n));
            lore = new ArrayList<String>();
            for (String s : this.getConfig().getStringList("Settings.Server.Lore")) {
                if ((s = s.replace("%amount%", "" + this.formatNumber(value))).contains("%tax%") && tax == 0.0) continue;
                s = Utils.setColor((String)s);
                lore.add(s);
            }
            if (tax > 0.0) {
                lore = this.getFormattedLore(lore, owner, value, tax);
            }
            meta.setLore(lore);
        }
        item.setItemMeta(meta);
        NBTItem tag = new NBTItem(item);
        tag.setDouble(this.nbtTag, Double.valueOf(value));
        tag.setBoolean("bCraft", Boolean.valueOf(true));
        tag.setString("RedeemType", this.id);
        if (tax > 0.0) {
            tag.setDouble("Tax", Double.valueOf(tax));
        }
        item = tag.getItem();
        return item;
    }

    private List<String> getFormattedLore(List<String> baseLore, String owner, double value, double tax) {
        ArrayList<String> formatted = new ArrayList<String>();
        List taxLore = this.getConfig().getStringList("Settings.Tax.Lore");
        for (String line : baseLore) {
            if (line.contains("%tax%")) {
                for (String taxLine : taxLore) {
                    taxLine = taxLine.replace("%player%", owner);
                    taxLine = taxLine.replace("%amount%", this.formatNumber(value));
                    taxLine = taxLine.replace("%tax%", this.formatTax(tax));
                    formatted.add(Utils.setColor((String)taxLine));
                }
                continue;
            }
            line = line.replace("%player%", owner);
            line = line.replace("%amount%", this.formatNumber(value));
            line = line.replace("%tax%", this.formatTax(tax));
            formatted.add(Utils.setColor((String)line));
        }
        return formatted;
    }

    private String formatTax(double tax) {
        return String.format("%.0f%%", tax);
    }

    public ConfigurationSection getMessageSection() {
        return this.getConfig().getConfigurationSection("Settings.Messages");
    }

    public boolean hasAmountModels() {
        return this.amountModels.size() > 0;
    }

    public String getID() {
        return this.id;
    }

    public double calculateTax(Player p, double takenAmount, ItemStack itemStack) {
        NBTItem nbtItem = new NBTItem(itemStack);
        double taxPercentage = nbtItem.getDouble("Tax");
        if (taxPercentage <= 0.0) {
            return 0.0;
        }
        double tax = takenAmount * (Math.min(taxPercentage, 100.0) / 100.0);
        return tax;
    }

    public String getNbtTag() {
        return this.nbtTag;
    }
}

