/*
 * Decompiled with CFR 0.152.
 */
package me.mraxetv.beastwithdraw;

import me.mraxetv.beastlib.api.BeastLibAPI;
import me.mraxetv.beastlib.filemanager.MessagesYml;
import me.mraxetv.beastlib.lib.boostedyaml.YamlDocument;
import me.mraxetv.beastlib.lib.bstats.bukkit.Metrics;
import me.mraxetv.beastlib.lib.nbtapi.utils.MinecraftVersion;
import me.mraxetv.beastwithdraw.commands.admin.BeastWithdrawCMD;
import me.mraxetv.beastwithdraw.filemanager.FileYml;
import me.mraxetv.beastwithdraw.listener.CancelCraftingListener;
import me.mraxetv.beastwithdraw.listener.DispenserXpBottleListener;
import me.mraxetv.beastwithdraw.listener.ItemDropListener;
import me.mraxetv.beastwithdraw.managers.WithdrawManager;
import me.mraxetv.beastwithdraw.utils.BeastUtils;
import me.mraxetv.beastwithdraw.utils.ConfigLang;
import me.mraxetv.beastwithdraw.utils.MessagesLang;
import me.mraxetv.beastwithdraw.utils.Utils;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.HandlerList;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class BeastWithdrawPlugin
extends JavaPlugin
implements BeastLibAPI {
    public MessagesYml messages;
    private Utils utils;
    private ConfigLang configLang;
    private MessagesLang messagesLang;
    private FileYml fileYml;
    private static BeastWithdrawPlugin instance;
    private static Economy econ;
    private WithdrawManager withdrawManager;
    private Metrics metrics;
    private BeastWithdrawCMD beastWithdrawCMD;

    private boolean setupBeastLib() {
        return this.getServer().getPluginManager().isPluginEnabled("BeastLib");
    }

    public void onEnable() {
        if (!this.setupBeastLib()) {
            new BukkitRunnable(){

                public void run() {
                    BeastWithdrawPlugin.this.getServer().getLogger().severe("[" + BeastWithdrawPlugin.this.getDescription().getName() + "] is missing BeastLib dependency!");
                }
            }.runTaskLater((Plugin)this, 100L);
            return;
        }
        MinecraftVersion.disableUpdateCheck();
        MinecraftVersion.disableBStats();
        MinecraftVersion.disablePackageWarning();
        if (MinecraftVersion.isNewerThan((MinecraftVersion)MinecraftVersion.MC1_21_R5)) {
            new BukkitRunnable(){

                public void run() {
                    BeastWithdrawPlugin.this.getServer().getLogger().warning("[" + BeastWithdrawPlugin.this.getDescription().getName() + "] is not compatible with this minecraft version please do update to latest version!");
                }
            }.runTaskLater((Plugin)this, 100L);
            return;
        }
        instance = this;
        this.setupEconomy();
        this.registerConfigs();
        this.configLang = new ConfigLang(this);
        this.messagesLang = new MessagesLang(this);
        this.utils = new Utils(this);
        this.withdrawManager = new WithdrawManager(this);
        this.registerCommands();
        this.registerEvents();
        new BeastUtils((Plugin)this, "13896").getBVersion(version -> {
            if (this.getDescription().getVersion().equalsIgnoreCase((String)version)) {
                Bukkit.getConsoleSender().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7[&4Beast&bWithdraw&7] &6There is not a new update available."));
            } else {
                Bukkit.getConsoleSender().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7[&4Beast&bWithdraw&7] &4There is a new update available."));
            }
        });
        int pluginId = 9409;
        this.metrics = new Metrics((JavaPlugin)this, pluginId);
        Bukkit.getConsoleSender().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&7[&4Beast&bWithdraw&7] &2Version " + this.getDescription().getVersion() + " : has been enabled!")));
    }

    public void reload() {
        HandlerList.unregisterAll((Plugin)this);
        this.withdrawManager.unregisterAssetHandlers();
        this.reloadConfig();
        this.registerConfigs();
        this.configLang = new ConfigLang(this);
        this.messagesLang = new MessagesLang(this);
        this.utils = new Utils(this);
        this.withdrawManager = new WithdrawManager(this);
        this.registerEvents();
        this.registerCommands();
    }

    public void registerConfigs() {
        this.fileYml = new FileYml(this, "config.yml");
        this.messages = new MessagesYml((JavaPlugin)this);
    }

    public void registerCommands() {
        this.beastWithdrawCMD = new BeastWithdrawCMD(this, "beastwithdraw", "Main admin command for BeastWithdraw plugin", "/BeastWithdraw help", this.getConfig().getStringList("Settings.Aliases"));
    }

    public void registerEvents() {
        PluginManager pm = this.getServer().getPluginManager();
        if (this.getConfig().getBoolean("Settings.Withdraws.CashNote.Enabled")) {
            new CancelCraftingListener(this);
        }
        new DispenserXpBottleListener(this);
        new ItemDropListener(this);
    }

    public void onDisable() {
        if (this.metrics != null) {
            this.metrics.shutdown();
        }
    }

    public YamlDocument getMessages() {
        return this.messages.getConfig();
    }

    private void setupEconomy() {
        if (!this.getServer().getPluginManager().isPluginEnabled("Vault")) {
            return;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return;
        }
        econ = (Economy)rsp.getProvider();
    }

    public FileConfiguration getConfig() {
        return this.fileYml.getConfig();
    }

    public Utils getUtils() {
        return this.utils;
    }

    public MessagesLang getMessagesLang() {
        return this.messagesLang;
    }

    public static BeastWithdrawPlugin getInstance() {
        return instance;
    }

    public static Economy getEcon() {
        return econ;
    }

    public WithdrawManager getWithdrawManager() {
        return this.withdrawManager;
    }

    static {
        econ = null;
    }
}

