/*
 * Decompiled with CFR 0.152.
 */
package me.mraxetv.beastwithdraw.extensions;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.regex.Pattern;
import me.mraxetv.beastwithdraw.BeastWithdrawPlugin;
import me.mraxetv.beastwithdraw.extensions.Extension;
import org.apache.commons.lang.Validate;
import org.bukkit.plugin.InvalidDescriptionException;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.yaml.snakeyaml.error.YAMLException;

public class ExtensionLoader {
    BeastWithdrawPlugin pl;
    private final Pattern[] fileFilters = new Pattern[]{Pattern.compile("\\.jar$")};
    private final Map<String, Class<?>> classes = new ConcurrentHashMap();
    private final List<Extension> loaders = new CopyOnWriteArrayList<Extension>();

    public ExtensionLoader(BeastWithdrawPlugin pl) {
        this.pl = pl;
    }

    public Pattern[] getExtensionFileFilters() {
        return (Pattern[])this.fileFilters.clone();
    }

    public PluginDescriptionFile getExtensionsDescription(File file) throws InvalidDescriptionException {
        Validate.notNull((Object)file, (String)"File cannot be null");
        JarFile jar = null;
        InputStream stream = null;
        try {
            jar = new JarFile(file);
            JarEntry entry = jar.getJarEntry("plugin.yml");
            if (entry == null) {
                throw new InvalidDescriptionException((Throwable)new FileNotFoundException("Jar does not contain plugin.yml"));
            }
            stream = jar.getInputStream(entry);
            PluginDescriptionFile pluginDescriptionFile = new PluginDescriptionFile(stream);
            return pluginDescriptionFile;
        }
        catch (IOException ex) {
            throw new InvalidDescriptionException((Throwable)ex);
        }
        catch (YAMLException ex) {
            throw new InvalidDescriptionException((Throwable)ex);
        }
        finally {
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (IOException iOException) {}
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public Plugin loadPlugin(File file) throws InvalidPluginException {
        Extension loader;
        PluginDescriptionFile description;
        Validate.notNull((Object)file, (String)"File cannot be null");
        if (!file.exists()) {
            throw new InvalidPluginException((Throwable)new FileNotFoundException(file.getPath() + " does not exist"));
        }
        try {
            description = this.getExtensionsDescription(file);
        }
        catch (InvalidDescriptionException ex) {
            throw new InvalidPluginException((Throwable)ex);
        }
        File parentFile = file.getParentFile();
        File dataFolder = new File(parentFile, description.getName());
        File oldDataFolder = new File(parentFile, description.getRawName());
        if (!dataFolder.equals(oldDataFolder)) {
            if (dataFolder.isDirectory() && oldDataFolder.isDirectory()) {
                this.pl.getLogger().warning(String.format("While loading %s (%s) found old-data folder: `%s' next to the new one `%s'", description.getFullName(), file, oldDataFolder, dataFolder));
            } else if (oldDataFolder.isDirectory() && !dataFolder.exists()) {
                if (!oldDataFolder.renameTo(dataFolder)) {
                    throw new InvalidPluginException("Unable to rename old data folder: `" + oldDataFolder + "' to: `" + dataFolder + "'");
                }
                this.pl.getLogger().log(Level.INFO, String.format("While loading %s (%s) renamed data folder: `%s' to `%s'", description.getFullName(), file, oldDataFolder, dataFolder));
            }
        }
        if (dataFolder.exists() && !dataFolder.isDirectory()) {
            throw new InvalidPluginException(String.format("Projected datafolder: `%s' for %s (%s) exists and is not a directory", dataFolder, description.getFullName(), file));
        }
        try {
            loader = new Extension(this, this.getClass().getClassLoader(), description, dataFolder, file);
        }
        catch (InvalidPluginException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new InvalidPluginException(ex);
        }
        this.loaders.add(loader);
        return null;
    }
}

