/*
 * Decompiled with CFR 0.152.
 */
package me.mraxetv.beastwithdraw.extensions;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.mraxetv.beastwithdraw.BeastWithdrawPlugin;
import me.mraxetv.beastwithdraw.extensions.Extension;
import me.mraxetv.beastwithdraw.extensions.ExtensionLoader;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.plugin.InvalidDescriptionException;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.UnknownDependencyException;

public class ExtensionManager {
    private BeastWithdrawPlugin pl;
    private HashMap<String, Extension> extensionsList;
    private final Map<Pattern, ExtensionLoader> fileAssociations = new HashMap<Pattern, ExtensionLoader>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtensionManager(BeastWithdrawPlugin pl) {
        this.pl = pl;
        this.extensionsList = new HashMap();
        ExtensionLoader extensionLoader = new ExtensionLoader(pl);
        Pattern[] patterns = extensionLoader.getExtensionFileFilters();
        ExtensionManager extensionManager = this;
        synchronized (extensionManager) {
            for (Pattern pattern : patterns) {
                this.fileAssociations.put(pattern, extensionLoader);
            }
        }
        File extensionsFolder = new File(pl.getDataFolder() + "/Extensions");
        if (!extensionsFolder.exists()) {
            extensionsFolder.mkdir();
        }
        this.loadExtensions(extensionsFolder);
    }

    public void loadExtensions(File directory) {
        Validate.notNull((Object)directory, (String)"Directory cannot be null");
        Validate.isTrue((boolean)directory.isDirectory(), (String)"Directory must be a directory");
        Set<Pattern> filters = this.fileAssociations.keySet();
        for (File file : directory.listFiles()) {
            ExtensionLoader loader = null;
            for (Pattern filter : filters) {
                Matcher match = filter.matcher(file.getName());
                if (!match.find()) continue;
                loader = this.fileAssociations.get(filter);
                Bukkit.broadcastMessage((String)file.getName());
            }
            if (loader == null) continue;
            PluginDescriptionFile description = null;
            try {
                description = loader.getExtensionsDescription(file);
            }
            catch (InvalidDescriptionException e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized Extension loadExtension(File file) throws InvalidPluginException, UnknownDependencyException {
        Validate.notNull((Object)file, (String)"File cannot be null");
        Set<Pattern> filters = this.fileAssociations.keySet();
        Plugin result = null;
        for (Pattern filter : filters) {
            String name;
            Matcher match = filter.matcher(name = file.getName());
            if (!match.find()) continue;
            ExtensionLoader loader = this.fileAssociations.get(filter);
            result = loader.loadPlugin(file);
        }
        if (result != null) {
            for (String string : result.getDescription().getProvides()) {
            }
        }
        return null;
    }
}

