/*
 * Decompiled with CFR 0.152.
 */
package me.mraxetv.beastwithdraw.managers.assets;

import me.mraxetv.beasttokens.BeastTokensPlugin;
import me.mraxetv.beasttokens.api.BeastTokensAPI;
import me.mraxetv.beasttokens.api.handlers.BTTokensManager;
import me.mraxetv.beastwithdraw.BeastWithdrawPlugin;
import me.mraxetv.beastwithdraw.commands.WithdrawCMD;
import me.mraxetv.beastwithdraw.commands.tokenwithdraw.BeastTokenNoteCMD;
import me.mraxetv.beastwithdraw.events.BTokensRedeemEvent;
import me.mraxetv.beastwithdraw.managers.AssetHandler;
import me.mraxetv.beastwithdraw.managers.redeem.RedeemRegistry;
import org.bukkit.entity.Player;

public class BeastTokensHandler
extends AssetHandler<Double> {
    private BTTokensManager api = BeastTokensAPI.getTokensManager();
    private BeastTokenNoteCMD beastTokenNoteCMD;

    public BeastTokensHandler(BeastWithdrawPlugin pl, String id) {
        super(pl, id);
        this.beastTokenNoteCMD = new BeastTokenNoteCMD(pl, this);
        if (pl.getServer().getPluginManager().getPlugin("BeastTokens") != null) {
            BeastTokensPlugin.getInstance().getDeposit().disable();
        }
        RedeemRegistry.register(id, BTokensRedeemEvent::new);
    }

    @Override
    public Double getBalance(Player p) {
        return this.api.getTokens(p);
    }

    @Override
    public void withdrawAmount(Player p, Double amount) {
        this.api.removeTokens(p, amount.doubleValue());
    }

    @Override
    public void depositAmount(Player p, Double amount) {
        this.api.addTokens(p, amount.doubleValue());
    }

    @Override
    public boolean isToBigAmount(double amount) {
        return false;
    }

    @Override
    public WithdrawCMD getWithdrawCMD() {
        return this.beastTokenNoteCMD;
    }
}

