/*
 * Decompiled with CFR 0.152.
 */
package me.mraxetv.beastwithdraw.listener;

import java.util.HashSet;
import java.util.UUID;
import me.mraxetv.beastlib.lib.nbtapi.NBTItem;
import me.mraxetv.beastlib.lib.nbtapi.utils.MinecraftVersion;
import me.mraxetv.beastlib.lib.xmaterials.XMaterial;
import me.mraxetv.beastwithdraw.BeastWithdrawPlugin;
import me.mraxetv.beastwithdraw.events.BottleRedeemEvent;
import me.mraxetv.beastwithdraw.managers.assets.XpBottleHandler;
import me.mraxetv.beastwithdraw.utils.Utils;
import me.mraxetv.beastwithdraw.utils.XpManager;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ExpBottleEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class XpBottleRedeemListener
implements Listener {
    private BeastWithdrawPlugin pl;
    private HashSet<UUID> delayList;
    private boolean autoCollect = false;
    private XpBottleHandler assetHandler;

    public XpBottleRedeemListener(BeastWithdrawPlugin plugin, XpBottleHandler assetHandler) {
        this.pl = plugin;
        this.assetHandler = assetHandler;
        this.pl.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.pl);
        this.delayList = new HashSet();
        this.autoCollect = assetHandler.getConfig().getBoolean("Settings.AutoCollect");
        if (!this.autoCollect && assetHandler.getMaterial() != XMaterial.EXPERIENCE_BOTTLE.parseMaterial()) {
            this.autoCollect = true;
        }
    }

    @EventHandler
    public void redeemEvent(BottleRedeemEvent e) {
        Player p = e.getPlayer();
        if (e.isCancelled()) {
            return;
        }
        ItemStack item = e.getItem();
        int stackSize = 1;
        boolean fullStack = false;
        if (!p.hasPermission("BeastWithdraw." + this.assetHandler.getID() + ".Redeem")) {
            this.pl.getUtils().noPermission(p);
            return;
        }
        if (item.getAmount() > 1 && p.isSneaking() && p.hasPermission("BeastWithdraw." + this.assetHandler.getID() + ".Redeem.Stacked")) {
            stackSize = item.getAmount();
            fullStack = true;
        }
        int singleAmount = (int)e.getAmount();
        int singleTax = (int)Math.ceil(this.assetHandler.calculateTax(p, singleAmount, item));
        int singleAfterTax = singleAmount - singleTax;
        int totalAmount = singleAmount * stackSize;
        int totalTax = singleTax * stackSize;
        int finalAmount = totalAmount - totalTax;
        if (this.autoCollect) {
            XpManager.setTotalExperience(p, XpManager.getTotalExperience(p) + finalAmount);
            String msg = totalTax == 0 ? this.assetHandler.getMessageSection().getString("Redeem") : this.assetHandler.getMessageSection().getString("RedeemAndTax");
            msg = msg.replace("%amount%", this.assetHandler.formatWithPreSuffix(singleAfterTax));
            msg = msg.replace("%tax%", this.assetHandler.formatWithPreSuffix(singleTax));
            msg = msg.replace("%balance%", this.assetHandler.formatWithPreSuffix(this.assetHandler.getBalance(p)));
            msg = Utils.formatStackSize(msg, stackSize);
            msg = msg.replace("%stacked-amount%", this.assetHandler.formatWithPreSuffix(finalAmount));
            msg = msg.replace("%stacked-tax%", this.assetHandler.formatWithPreSuffix(totalTax));
            this.pl.getUtils().sendMessage((CommandSender)p, msg);
        } else {
            ThrownExpBottle t = (ThrownExpBottle)p.launchProjectile(ThrownExpBottle.class);
            if (MinecraftVersion.isAtLeastVersion((MinecraftVersion)MinecraftVersion.MC1_15_R1)) {
                NBTItem nbtItem = new NBTItem(item);
                nbtItem.setInteger(this.assetHandler.getConfig().getString("Settings.NBTKey"), Integer.valueOf(finalAmount));
                t.setItem(nbtItem.getItem());
            } else {
                t.setCustomName("XPB:" + finalAmount);
            }
        }
        if (this.assetHandler.getConfig().getBoolean("Settings.Sounds.Redeem.Enabled")) {
            String soundName = this.assetHandler.getConfig().getString("Settings.Sounds.Redeem.Sound");
            float volume = (float)this.assetHandler.getConfig().getDouble("Settings.Sounds.Redeem.Volume", 1.0);
            float pitch = (float)this.assetHandler.getConfig().getDouble("Settings.Sounds.Redeem.Pitch", 1.0);
            try {
                Sound sound = Sound.valueOf((String)soundName.toUpperCase());
                p.playSound(p.getLocation(), sound, volume, pitch);
            }
            catch (Exception e1) {
                Bukkit.getServer().getConsoleSender().sendMessage(this.pl.getUtils().getPrefix() + "\u00a7cBroken sound in XpBottle Redeem section!");
            }
        }
        if (fullStack) {
            if (e.isOffHand()) {
                p.getInventory().setItemInOffHand(null);
            } else {
                p.getInventory().removeItem(new ItemStack[]{item});
            }
        } else if (item.getAmount() > 1) {
            item.setAmount(item.getAmount() - 1);
        } else if (e.isOffHand()) {
            p.getInventory().setItemInOffHand(null);
        } else {
            p.getInventory().removeItem(new ItemStack[]{item});
        }
        p.updateInventory();
    }

    @EventHandler(priority=EventPriority.LOW)
    public void xpThrow(ExpBottleEvent e) {
        if (MinecraftVersion.isAtLeastVersion((MinecraftVersion)MinecraftVersion.MC1_15_R1)) {
            ThrownExpBottle thrownExpBottle = e.getEntity();
            if (thrownExpBottle == null) {
                return;
            }
            NBTItem nbtItem = new NBTItem(e.getEntity().getItem());
            if (!nbtItem.hasKey(this.assetHandler.getConfig().getString("Settings.NBTKey")).booleanValue()) {
                return;
            }
            int xp = nbtItem.getInteger(this.assetHandler.getConfig().getString("Settings.NBTKey"));
            e.setExperience(xp);
        } else {
            if (e.getEntity().getCustomName() == null) {
                return;
            }
            if (!e.getEntity().getCustomName().startsWith("XPB:")) {
                return;
            }
            int xp = Integer.parseInt(e.getEntity().getCustomName().replaceAll("XPB:", ""));
            e.setExperience(xp);
        }
    }

    @EventHandler
    public void playerDeath(PlayerDeathEvent e) {
        if (!this.assetHandler.getConfig().getBoolean("Settings.DropOnDeath")) {
            return;
        }
        Player p = e.getEntity();
        if (!p.hasPermission("BeastWithdraw.XpBottle.Drop")) {
            return;
        }
        int xp = XpManager.getTotalExperience(p);
        if (xp <= 0) {
            return;
        }
        double dropPercentage = this.assetHandler.getConfig().getDouble("Settings.DropPercentage") / 100.0;
        xp = (int)((double)xp * dropPercentage);
        ItemStack xpbItemStack = this.assetHandler.getItem(p.getName(), xp, 1, true, this.assetHandler.getConfig().getDouble("Settings.Charges.Tax.Percentage"));
        p.getWorld().dropItem(p.getLocation(), xpbItemStack);
        p.setTotalExperience(0);
        p.setLevel(0);
        p.setExp(0.0f);
        e.setDroppedExp(0);
    }
}

