/*
 * Decompiled with CFR 0.152.
 */
package me.mraxetv.beastwithdraw.commands.xpbottle;

import me.mraxetv.beastwithdraw.BeastWithdrawPlugin;
import me.mraxetv.beastwithdraw.commands.WithdrawCMD;
import me.mraxetv.beastwithdraw.managers.assets.XpBottleHandler;
import me.mraxetv.beastwithdraw.utils.Utils;
import me.mraxetv.beastwithdraw.utils.XpManager;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class XpBottleCMD
extends WithdrawCMD {
    private final BeastWithdrawPlugin pl;
    private final XpBottleHandler assetHandler;

    public XpBottleCMD(BeastWithdrawPlugin plugin, XpBottleHandler assetHandler) {
        super(plugin, assetHandler);
        this.pl = plugin;
        this.assetHandler = assetHandler;
    }

    @Override
    public boolean execute(CommandSender sender, String cmd, String[] args) {
        if (!(sender instanceof Player)) {
            this.pl.getUtils().sendMessage(sender, "%prefix% Console can't use this command! /BeastWithdraw help");
            return true;
        }
        this.handleWithdraw((Player)sender, args);
        return true;
    }

    private void handleWithdraw(Player player, String[] args) {
        if (!player.hasPermission(this.getPermission())) {
            this.pl.getUtils().noPermission(player);
            return;
        }
        if (args.length == 0) {
            this.sendHelpMessage(player);
            return;
        }
        int stackSize = this.parseStackSize(player, args);
        if (stackSize == -1) {
            return;
        }
        double balance = this.assetHandler.getBalance(player);
        double takenAmount = this.parseWithdrawAmount(player, args[0], balance);
        if (takenAmount == -1.0) {
            return;
        }
        if (!this.validateInventorySpace(player)) {
            return;
        }
        if (!this.validateWithdrawLimits(player, takenAmount)) {
            return;
        }
        if (!this.validateBigAmount(player, takenAmount, stackSize)) {
            return;
        }
        if (!this.validateBalance(player, balance, takenAmount, stackSize)) {
            return;
        }
        if (!this.chargeFee(player, stackSize)) {
            return;
        }
        this.performWithdraw(player, takenAmount, stackSize);
    }

    @Override
    protected void performWithdraw(Player p, double takenAmount, int stackSize) {
        this.assetHandler.withdrawAmount(p, takenAmount * (double)stackSize);
        String s = this.assetHandler.getMessageSection().getString("Withdraw");
        s = s.replace("%amount%", this.assetHandler.formatWithPreSuffix(takenAmount));
        s = s.replace("%stacked-amount%", this.assetHandler.formatWithPreSuffix(takenAmount * (double)stackSize));
        s = s.replace("%level-amount%", this.assetHandler.formatNumber(XpManager.getLevelFromExp((int)takenAmount)));
        s = Utils.formatStackSize(s, stackSize);
        s = s.replace("%balance%", this.assetHandler.formatWithPreSuffix(this.assetHandler.getBalance(p)));
        this.pl.getUtils().sendMessage((CommandSender)p, s);
        double tax = this.calculateTax(p);
        ItemStack item = this.assetHandler.getItem(p.getName(), takenAmount, stackSize, true, tax);
        if (p.getInventory().firstEmpty() != -1) {
            Utils.addItem((Player)p, (ItemStack)item);
        } else {
            p.getWorld().dropItem(p.getLocation(), item);
        }
        this.playWithdrawSound(p);
    }

    @Override
    protected double parseWithdrawAmount(Player p, String arg, double balance) {
        if (arg.equalsIgnoreCase("all")) {
            if (!p.hasPermission(this.getPermission() + ".All")) {
                this.pl.getUtils().noPermission(p);
                return -1.0;
            }
            return balance;
        }
        if (arg.toLowerCase().endsWith("l") && arg.toLowerCase().split("l").length == 1 && Utils.isInt(arg.toLowerCase().split("l")[0])) {
            int lv = Math.abs(Integer.parseInt(arg.toLowerCase().split("l")[0]));
            if (lv > p.getLevel()) {
                String s = this.assetHandler.getMessageSection().getString("NotEnoughLevels");
                s = s.replace("%amount%", "" + lv);
                this.pl.getUtils().sendMessage((CommandSender)p, s);
                return -1.0;
            }
            int ofSetLevel = p.getLevel() - lv;
            int offSetXp = XpManager.getExpToLevel(ofSetLevel);
            return (double)XpManager.getExpToLevel(lv + ofSetLevel) - (double)offSetXp;
        }
        if (!Utils.isInt(arg)) {
            String s = this.pl.getMessages().getString("Withdraws.InvalidNumber");
            s = s.replace("%amount%", arg);
            this.pl.getUtils().sendMessage((CommandSender)p, s);
            return -1.0;
        }
        return Math.abs(Double.parseDouble(arg));
    }
}

