/*
 * Decompiled with CFR 0.152.
 */
package me.mraxetv.beastwithdraw.filemanager;

import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import me.mraxetv.beastwithdraw.filemanager.YamlCommentor;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class FileYml {
    private JavaPlugin pl;
    private String name;
    public File configf;
    public FileConfiguration config;

    public FileYml(JavaPlugin plugin, String n) {
        this.pl = plugin;
        this.name = n;
        this.createFiles(this.name);
        this.configUpdate();
    }

    public FileYml(JavaPlugin plugin, String n, boolean setDefaults) {
        this.pl = plugin;
        this.name = n;
        this.createFiles(this.name);
        this.configUpdate();
        if (setDefaults) {
            this.addDefaults();
        }
    }

    public void reloadConfig() {
        this.createFiles(this.name);
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public void saveConfig() {
        YamlCommentor.saveCommented(this.config, this.configf);
    }

    public void addDefaults() {
        InputStreamReader defaultConfigStream = null;
        YamlConfiguration defaultConfig = null;
        try {
            defaultConfigStream = new InputStreamReader(this.pl.getResource(this.name), "UTF-8");
            if (defaultConfigStream != null) {
                defaultConfig = YamlConfiguration.loadConfiguration((Reader)defaultConfigStream);
                Set keys = this.config.getKeys(true);
                for (String s : defaultConfig.getKeys(true)) {
                    if (keys.contains(s)) continue;
                    this.config.setDefaults((Configuration)defaultConfig);
                    this.config.options().copyDefaults(true);
                    this.saveConfig();
                    return;
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public void createFiles(String name) {
        this.configf = new File(this.pl.getDataFolder(), name);
        if (!this.configf.exists()) {
            this.configf.getParentFile().mkdirs();
            this.pl.saveResource(name, false);
        }
        this.config = new YamlConfiguration();
        try {
            this.config.load(this.configf);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void configUpdate() {
        InputStreamReader oldConfigStream = null;
        YamlConfiguration oldConfig = null;
        try {
            oldConfigStream = new InputStreamReader(this.pl.getResource(this.name), "UTF-8");
            if (oldConfigStream != null) {
                oldConfig = YamlConfiguration.loadConfiguration((Reader)oldConfigStream);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        if (this.getConfig().getDouble("ConfigVersion") < oldConfig.getDouble("ConfigVersion") || !this.getConfig().isSet("ConfigVersion")) {
            double oldVersion = this.getConfig().getDouble("ConfigVersion");
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy_MM_dd-HH.mm.ss");
            Date date = new Date();
            File file = new File(this.pl.getDataFolder(), this.name);
            boolean renameResult = file.renameTo(new File(this.pl.getDataFolder(), this.name.replace("\\.yml", "") + "_" + dateFormat.format(date) + "_old.yml"));
            if (renameResult) {
                this.pl.saveResource(this.name, false);
                this.createFiles(this.name);
                Bukkit.getConsoleSender().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&7" + this.pl.getDescription().getPrefix() + " &4Old " + this.name + " " + oldVersion + " has been replaced with new version!")));
            } else {
                Bukkit.getConsoleSender().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&7" + this.pl.getDescription().getPrefix() + " &4Server has failed to replace old version of " + this.config + " please contact author MrAxeTv!")));
            }
        }
    }
}

