/*
 * Decompiled with CFR 0.152.
 */
package me.mraxetv.beastwithdraw.listener;

import me.mraxetv.beastlib.lib.nbtapi.NBTItem;
import me.mraxetv.beastlib.lib.nbtapi.utils.MinecraftVersion;
import me.mraxetv.beastlib.lib.xmaterials.XMaterial;
import me.mraxetv.beastwithdraw.BeastWithdrawPlugin;
import me.mraxetv.beastwithdraw.managers.WithdrawManager;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.Dispenser;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class DispenserXpBottleListener
implements Listener {
    private BeastWithdrawPlugin pl;
    private String id;
    private Material xpBottleMaterial = XMaterial.EXPERIENCE_BOTTLE.parseMaterial();

    public DispenserXpBottleListener(BeastWithdrawPlugin pl) {
        if (MinecraftVersion.isNewerThan((MinecraftVersion)MinecraftVersion.MC1_15_R1)) {
            return;
        }
        this.pl = pl;
        pl.getWithdrawManager();
        this.id = WithdrawManager.XP_BOTTLE.getConfig().getString("Settings.NBTKey");
        pl.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)pl);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onDispense(final BlockDispenseEvent e) {
        if (e.getItem().getType() == this.xpBottleMaterial) {
            NBTItem nbtItem = new NBTItem(e.getItem());
            if (!nbtItem.hasKey(this.id).booleanValue()) {
                return;
            }
            Location dispenserLocation = e.getBlock().getLocation();
            World world = dispenserLocation.getWorld();
            ThrownExpBottle thrownExpBottle = (ThrownExpBottle)world.spawn(DispenserXpBottleListener.getBlockFacingDispenser(e.getBlock()).getLocation().add(0.5, 0.5, 0.5), ThrownExpBottle.class);
            thrownExpBottle.setVelocity(e.getVelocity());
            this.pl.getWithdrawManager();
            int singleTax = (int)Math.ceil(WithdrawManager.XP_BOTTLE.calculateTax(nbtItem.getInteger(this.id).intValue(), e.getItem()));
            thrownExpBottle.setCustomName("XPB:" + (nbtItem.getInteger(this.id) - singleTax));
            final org.bukkit.block.Dispenser state = (org.bukkit.block.Dispenser)e.getBlock().getState();
            e.setCancelled(true);
            new BukkitRunnable(){

                public void run() {
                    Inventory inv = state.getInventory();
                    if (inv.containsAtLeast(e.getItem(), 1)) {
                        inv.removeItem(new ItemStack[]{e.getItem()});
                    }
                }
            }.runTaskLater((Plugin)this.pl, 1L);
        }
    }

    public static Block getBlockFacingDispenser(Block dispenserBlock) {
        if (dispenserBlock.getType() == Material.DISPENSER) {
            Dispenser dispenserData = (Dispenser)dispenserBlock.getState().getData();
            BlockFace facing = dispenserData.getFacing();
            return dispenserBlock.getRelative(facing);
        }
        return null;
    }
}

