/*
 * Decompiled with CFR 0.152.
 */
package me.mraxetv.beastwithdraw.listener;

import me.mraxetv.beastlib.lib.nbtapi.NBTItem;
import me.mraxetv.beastwithdraw.BeastWithdrawPlugin;
import me.mraxetv.beastwithdraw.managers.AssetHandler;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Item;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class ItemDropListener
implements Listener {
    private BeastWithdrawPlugin pl;

    public ItemDropListener(BeastWithdrawPlugin pl) {
        this.pl = pl;
        pl.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)pl);
    }

    @EventHandler
    public void itemDrop(PlayerDropItemEvent e) {
        if (!e.getItemDrop().getItemStack().hasItemMeta()) {
            return;
        }
        NBTItem nbtItem = new NBTItem(e.getItemDrop().getItemStack());
        if (!nbtItem.hasTag("RedeemType")) {
            return;
        }
        String type = nbtItem.getString("RedeemType").toLowerCase();
        AssetHandler assetHandler = this.pl.getWithdrawManager().getAssetHandler(type);
        if (assetHandler.getConfig().isSet("Settings.CustomName")) {
            String hologram = assetHandler.getConfig().getString("Settings.CustomName");
            hologram = hologram.replace("%amount%", assetHandler.formatWithPreSuffix(nbtItem.getDouble(assetHandler.getNbtTag())));
            hologram = this.pl.getUtils().setPlaceholders((CommandSender)e.getPlayer(), hologram);
            e.getItemDrop().setCustomName(hologram);
            e.getItemDrop().setCustomNameVisible(true);
            if (assetHandler.getConfig().getBoolean("Settings.Glow.Enabled") && assetHandler.getConfig().isSet("Settings.Glow.Color")) {
                this.setGlowColor(e.getItemDrop(), ChatColor.valueOf((String)assetHandler.getConfig().getString("Settings.Glow.Color")));
            }
        }
    }

    public void setGlowColor(Item item, ChatColor color) {
        item.setGlowing(true);
        Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
        String teamName = "glow_" + color.name().toLowerCase();
        Team team = scoreboard.getTeam(teamName);
        if (team == null) {
            team = scoreboard.registerNewTeam(teamName);
            team.setColor(color);
        }
        String entry = item.getUniqueId().toString();
        team.addEntry(entry);
    }
}

