/*
 * Decompiled with CFR 0.152.
 */
package me.mraxetv.beastwithdraw.listener;

import java.util.HashSet;
import java.util.UUID;
import me.mraxetv.beastlib.lib.nbtapi.NBTItem;
import me.mraxetv.beastlib.lib.nbtapi.utils.MinecraftVersion;
import me.mraxetv.beastwithdraw.BeastWithdrawPlugin;
import me.mraxetv.beastwithdraw.events.BTokensRedeemEvent;
import me.mraxetv.beastwithdraw.events.CashRedeemEvent;
import me.mraxetv.beastwithdraw.events.CustomRedeemEvent;
import me.mraxetv.beastwithdraw.managers.AssetHandler;
import me.mraxetv.beastwithdraw.managers.redeem.RedeemRegistry;
import me.mraxetv.beastwithdraw.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class RedeemListener
implements Listener {
    private BeastWithdrawPlugin pl;
    private HashSet<UUID> delayList;

    public RedeemListener(BeastWithdrawPlugin plugin) {
        this.pl = plugin;
        this.pl.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.pl);
        this.delayList = new HashSet();
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void mainHand(PlayerInteractEvent e) {
        if (!e.hasItem()) {
            return;
        }
        if (e.getItem().getType() == Material.AIR) {
            return;
        }
        ItemStack item = e.getItem();
        if (!item.hasItemMeta()) {
            return;
        }
        if (e.getAction() != Action.RIGHT_CLICK_AIR && e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        NBTItem nbtItem = new NBTItem(item);
        if (!nbtItem.hasKey("RedeemType").booleanValue()) {
            return;
        }
        String type = nbtItem.getString("RedeemType").toLowerCase();
        AssetHandler assetHandler = this.pl.getWithdrawManager().getAssetHandler(type);
        double amount = nbtItem.getDouble(assetHandler.getNbtTag());
        final UUID uuid = e.getPlayer().getUniqueId();
        if (this.delayList.contains(uuid)) {
            return;
        }
        this.delayList.add(uuid);
        new BukkitRunnable(){

            public void run() {
                RedeemListener.this.delayList.remove(uuid);
            }
        }.runTaskLater((Plugin)this.pl, 1L);
        e.setCancelled(true);
        boolean offHand = false;
        if (MinecraftVersion.isAtLeastVersion((MinecraftVersion)MinecraftVersion.MC1_9_R1) && item.equals((Object)e.getPlayer().getInventory().getItemInOffHand())) {
            offHand = true;
        }
        CustomRedeemEvent event = RedeemRegistry.createEvent(type, e.getPlayer(), item, amount, offHand);
        Bukkit.getPluginManager().callEvent((Event)event);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void redeemEvent(BTokensRedeemEvent e) {
        this.handleGenericRedeem(e);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void redeemEvent(CashRedeemEvent e) {
        this.handleGenericRedeem(e);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void redeemEvent(CustomRedeemEvent e) {
        if (!((Object)((Object)e)).getClass().equals(CustomRedeemEvent.class)) {
            return;
        }
        this.handleGenericRedeem(e);
    }

    private void handleGenericRedeem(CustomRedeemEvent e) {
        if (e.isCancelled()) {
            return;
        }
        Player p = e.getPlayer();
        ItemStack item = e.getItem();
        int stackSize = 1;
        AssetHandler assetHandler = this.pl.getWithdrawManager().getAssetHandler(e.getType());
        if (!p.hasPermission("BeastWithdraw." + assetHandler.getID() + ".Redeem")) {
            this.pl.getUtils().noPermission(p);
            return;
        }
        boolean fullStack = false;
        if (item.getAmount() > 1 && p.isSneaking() && p.hasPermission("BeastWithdraw." + assetHandler.getID() + ".Redeem.Stacked")) {
            stackSize = item.getAmount();
            fullStack = true;
        }
        double singleAmount = e.getAmount();
        double singleTax = Math.ceil(assetHandler.calculateTax(singleAmount, item));
        double singleAfterTax = singleAmount - singleTax;
        double totalAmount = singleAmount * (double)stackSize;
        double totalTax = singleTax * (double)stackSize;
        double finalAmount = totalAmount - totalTax;
        assetHandler.depositAmount(p, finalAmount);
        String msg = totalTax == 0.0 ? assetHandler.getMessageSection().getString("Redeem") : assetHandler.getMessageSection().getString("RedeemAndTax");
        msg = msg.replace("%amount%", assetHandler.formatWithPreSuffix(singleAfterTax));
        msg = msg.replace("%tax%", assetHandler.formatWithPreSuffix(singleTax));
        msg = msg.replace("%balance%", assetHandler.formatWithPreSuffix(assetHandler.getBalance(p)));
        msg = Utils.formatStackSize(msg, stackSize);
        msg = msg.replace("%stacked-amount%", assetHandler.formatWithPreSuffix(finalAmount));
        msg = msg.replace("%stacked-tax%", assetHandler.formatWithPreSuffix(totalTax));
        this.pl.getUtils().sendMessage((CommandSender)p, msg);
        if (fullStack) {
            if (e.isOffHand()) {
                p.getInventory().setItemInOffHand(null);
            } else {
                p.getInventory().removeItem(new ItemStack[]{item});
            }
        } else if (item.getAmount() > 1) {
            item.setAmount(item.getAmount() - 1);
        } else if (e.isOffHand()) {
            p.getInventory().setItemInOffHand(null);
        } else {
            p.getInventory().removeItem(new ItemStack[]{item});
        }
        p.updateInventory();
        if (assetHandler.getConfig().getBoolean("Settings.Sounds.Redeem.Enabled")) {
            String soundName = assetHandler.getConfig().getString("Settings.Sounds.Redeem.Sound");
            float volume = (float)assetHandler.getConfig().getDouble("Settings.Sounds.Redeem.Volume", 1.0);
            float pitch = (float)assetHandler.getConfig().getDouble("Settings.Sounds.Redeem.Pitch", 1.0);
            try {
                Sound sound = Sound.valueOf((String)soundName.toUpperCase());
                p.playSound(p.getLocation(), sound, volume, pitch);
            }
            catch (Exception ex) {
                Bukkit.getServer().getConsoleSender().sendMessage(this.pl.getUtils().getPrefix() + "\u00a7cBroken sound in BeastWithdraw redeem section!");
            }
        }
        if (assetHandler.getConfig().getBoolean("Settings.Logs.Redeem", true)) {
            Location location = p.getLocation();
        }
    }
}

