/*
 * Decompiled with CFR 0.152.
 */
package me.mraxetv.beastwithdraw.managers;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import me.mraxetv.beastlib.BeastLib;
import me.mraxetv.beastlib.lib.nbtapi.NBTItem;
import me.mraxetv.beastlib.lib.nbtapi.utils.MinecraftVersion;
import me.mraxetv.beastlib.lib.tgui.gui.components.util.SkullUtil;
import me.mraxetv.beastlib.lib.xmaterials.XMaterial;
import me.mraxetv.beastwithdraw.BeastWithdrawPlugin;
import me.mraxetv.beastwithdraw.commands.WithdrawCMD;
import me.mraxetv.beastwithdraw.filemanager.FolderYaml;
import me.mraxetv.beastwithdraw.utils.Utils;
import me.mraxetv.beastwithdraw.utils.XpManager;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public abstract class AssetHandler<T extends Number> {
    private BeastWithdrawPlugin pl;
    private String id;
    private FolderYaml config;
    private Material material;
    private String nbtTag;
    private TreeMap<Integer, Integer> amountModels = new TreeMap(Collections.reverseOrder());
    private DecimalFormat decimalFormat;

    public AssetHandler(BeastWithdrawPlugin pl, String id) {
        this.pl = pl;
        this.id = id;
        this.config = new FolderYaml(pl, "Withdraws", id + ".yml");
        this.material = this.getConfig().isSet("Settings.Item") ? ((XMaterial)XMaterial.matchXMaterial((String)this.getConfig().getString("Settings.Item")).get()).parseMaterial() : XMaterial.PAPER.parseMaterial();
        this.nbtTag = this.getConfig().getString("Settings.NBTKey");
        this.setFormat();
        if (!this.getConfig().getBoolean("Settings.CustomModel.AmountModelData.Enabled")) {
            return;
        }
        if (!this.getConfig().isSet("Settings.CustomModel.AmountModelData.Range")) {
            return;
        }
        for (String s : this.getConfig().getStringList("Settings.CustomModel.AmountModelData.Range")) {
            String[] data;
            String[] args = s.split("-");
            if (!Utils.isInt(args[0]) || !Utils.isInt((data = args[1].split(":"))[1])) continue;
            this.amountModels.put(Integer.parseInt(args[0]), Integer.parseInt(data[1]));
        }
    }

    protected void setFormat() {
        String[] parts = this.getConfig().getString("Settings.Locale", "en_US").split("_");
        Locale locale = parts.length == 1 ? new Locale(parts[0]) : (parts.length == 2 ? new Locale(parts[0], parts[1]) : Locale.ENGLISH);
        this.decimalFormat = new DecimalFormat(this.getConfig().getString("Settings.AmountFormat", "###,##0.00"), DecimalFormatSymbols.getInstance(locale));
        this.decimalFormat.setRoundingMode(RoundingMode.HALF_DOWN);
    }

    protected void setMaterial(Material m) {
        this.material = m;
    }

    public Material getMaterial() {
        return this.material;
    }

    public String formatNumber(double amount) {
        String formatted = this.decimalFormat.format(amount);
        if (formatted.endsWith(".00")) {
            return formatted.substring(0, formatted.length() - 3);
        }
        return formatted;
    }

    public String formatAmount(double amount) {
        String formatted = this.decimalFormat.format(amount);
        if (formatted.endsWith(".00")) {
            return formatted.substring(0, formatted.length() - 3);
        }
        return formatted;
    }

    public String formatNumber(int amount) {
        return this.decimalFormat.format(amount);
    }

    public String formatWithPreSuffix(double amount) {
        return this.getConfig().getString("Settings.Messages.Prefix", "") + this.formatNumber(amount) + this.getConfig().getString("Settings.Messages.Suffix", "");
    }

    public abstract Double getBalance(Player var1);

    public abstract void withdrawAmount(Player var1, Double var2);

    public abstract void depositAmount(Player var1, Double var2);

    public FileConfiguration getConfig() {
        return this.config.getConfig();
    }

    public abstract boolean isToBigAmount(double var1);

    public int getModelDataFor(double amount, FileConfiguration config) {
        ConfigurationSection section = config.getConfigurationSection("Settings.CustomModel.AmountModelData");
        if (section == null || !section.getBoolean("Enabled")) {
            return config.getInt("Settings.CustomModel.DefaultModelData", 0);
        }
        List ranges = section.getMapList("Ranges");
        for (Map entry : ranges) {
            double max;
            double min = ((Number)entry.get("min")).doubleValue();
            double d = max = entry.containsKey("max") ? ((Number)entry.get("max")).doubleValue() : Double.POSITIVE_INFINITY;
            if (!(amount >= min) || !(amount <= max)) continue;
            return ((Number)entry.get("model")).intValue();
        }
        return config.getInt("CustomModel.DefaultModelData", 0);
    }

    public ItemStack getItem(String owner, double value, int amount, boolean signed, double tax) {
        ArrayList<String> lore;
        ItemStack item = new ItemStack(this.material, amount);
        if (this.getConfig().isSet("Settings.Data")) {
            item.setDurability((short)this.getConfig().getInt("Settings.Data"));
        }
        ItemMeta meta = item.getItemMeta();
        if (MinecraftVersion.isAtLeastVersion((MinecraftVersion)MinecraftVersion.MC1_14_R1)) {
            meta.setCustomModelData(Integer.valueOf(this.getModelDataFor(value, this.getConfig())));
        }
        if (this.getConfig().getBoolean("Settings.Glow")) {
            meta.addEnchant(Enchantment.DURABILITY, 1, true);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        if (signed) {
            String n = this.getConfig().getString("Settings.Player.Name");
            n = n.replace("%player%", owner);
            n = n.replace("%amount%", this.formatWithPreSuffix(value));
            n = n.replace("%level-amount%", this.formatNumber(XpManager.getLevelFromExp((int)value)));
            meta.setDisplayName(Utils.setColor((String)n));
            lore = new ArrayList();
            for (String s : this.getFormattedLore(this.getConfig().getStringList("Settings.Server.Lore"), owner, value, tax)) {
                s = s.replace("%player%", owner);
                s = s.replace("%amount%", this.formatWithPreSuffix(value));
                if ((s = s.replace("%level-amount%", this.formatNumber(XpManager.getLevelFromExp((int)value)))).contains("%tax%") && tax == 0.0) continue;
                s = Utils.setColor((String)s);
                lore.add(s);
            }
            meta.setLore(lore);
        } else {
            String n = this.getConfig().getString("Settings.Server.Name");
            n = n.replace("%amount%", this.formatWithPreSuffix(value));
            n = n.replace("%level-amount%", this.formatNumber(XpManager.getLevelFromExp((int)value)));
            meta.setDisplayName(Utils.setColor((String)n));
            lore = new ArrayList<String>();
            for (String s : this.getFormattedLore(this.getConfig().getStringList("Settings.Server.Lore"), owner, value, tax)) {
                s = s.replace("%amount%", this.formatWithPreSuffix(value));
                if ((s = s.replace("%level-amount%", this.formatNumber(XpManager.getLevelFromExp((int)value)))).contains("%tax%") && tax == 0.0) continue;
                s = Utils.setColor((String)s);
                lore.add(s);
            }
            meta.setLore(lore);
        }
        this.setFlags(meta, this.getConfig().getStringList("Settings.Flags"));
        item.setItemMeta(meta);
        NBTItem tag = new NBTItem(item);
        tag.setDouble(this.nbtTag, Double.valueOf(value));
        tag.setBoolean("bCraft", Boolean.valueOf(true));
        tag.setString("RedeemType", this.id);
        if (tax > 0.0) {
            tag.setDouble("Tax", Double.valueOf(tax));
        }
        if (SkullUtil.isPlayerSkull((ItemStack)(item = tag.getItem())) && this.getConfig().isSet("Settings.SkullTexture")) {
            String skullTexture = this.getConfig().getString("Settings.SkullTexture");
            skullTexture = skullTexture.replace("%player%", owner);
            if (!BeastLib.getInstance().getUtils().hasFetchedHeadTexture(skullTexture)) {
                BeastLib.getInstance().getUtils().fetchHeadTexture(skullTexture);
            }
            BeastLib.getInstance().getUtils().setHeadTexture(item, skullTexture);
        }
        return item;
    }

    private List<String> getFormattedLore(List<String> baseLore, String owner, double value, double tax) {
        if (tax <= 0.0) {
            return baseLore;
        }
        ArrayList<String> formatted = new ArrayList<String>();
        List taxLore = this.getConfig().getStringList("Settings.Tax.Lore");
        for (String line : baseLore) {
            if (line.contains("%tax%")) {
                for (String taxLine : taxLore) {
                    taxLine = taxLine.replace("%player%", owner);
                    taxLine = taxLine.replace("%amount%", this.formatWithPreSuffix(value));
                    taxLine = taxLine.replace("%tax%", this.formatTax(tax));
                    formatted.add(taxLine);
                }
                continue;
            }
            line = line.replace("%player%", owner);
            line = line.replace("%amount%", this.formatWithPreSuffix(value));
            line = line.replace("%tax%", this.formatTax(tax));
            formatted.add(line);
        }
        return formatted;
    }

    private void setFlags(ItemMeta itemMeta, List<String> flags) {
        if (flags == null || flags.isEmpty()) {
            return;
        }
        for (String s : flags) {
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.valueOf((String)s.toUpperCase())});
        }
    }

    private String formatTax(double tax) {
        return String.format("%.0f%%", tax);
    }

    public ConfigurationSection getMessageSection() {
        return this.getConfig().getConfigurationSection("Settings.Messages");
    }

    public boolean hasAmountModels() {
        return this.amountModels.size() > 0;
    }

    public String getID() {
        return this.id;
    }

    public double calculateTax(double takenAmount, ItemStack itemStack) {
        NBTItem nbtItem = new NBTItem(itemStack);
        double taxPercentage = nbtItem.getDouble("Tax");
        if (taxPercentage <= 0.0) {
            return 0.0;
        }
        double tax = takenAmount * (Math.min(taxPercentage, 100.0) / 100.0);
        return tax;
    }

    public abstract WithdrawCMD getWithdrawCMD();

    public String getNbtTag() {
        return this.nbtTag;
    }
}

