/*
 * Decompiled with CFR 0.152.
 */
package me.mraxetv.beastwithdraw.utils;

import java.text.NumberFormat;
import java.util.Locale;
import me.mraxetv.beastlib.utils.BUtils;
import me.mraxetv.beastwithdraw.BeastWithdrawPlugin;
import me.mraxetv.beastwithdraw.utils.ConfigLang;
import me.mraxetv.beastwithdraw.utils.MessagesLang;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.java.JavaPlugin;

public class Utils
extends BUtils
implements Listener {
    private BeastWithdrawPlugin pl;
    private String version;

    public Utils(BeastWithdrawPlugin plugin) {
        super((JavaPlugin)plugin);
        this.pl = plugin;
    }

    public String getPrefix() {
        return BeastWithdrawPlugin.getInstance().getMessages().getString("Prefix");
    }

    public static String formatStackSize(String message, int amount) {
        if (amount <= 1) {
            return message.replace("%stack%", "");
        }
        return message.replace("%stack%", MessagesLang.STACK_SIZE.replace("%amount%", "" + amount));
    }

    public void sendMessage(CommandSender sender, String message) {
        super.sendMessage(sender, message);
    }

    public void sendLog(String s) {
        s = ChatColor.translateAlternateColorCodes((char)'&', (String)s);
        this.pl.getServer().getConsoleSender().sendMessage(this.getPrefix() + s);
    }

    public static boolean isInt(String value) {
        try {
            Integer.parseInt(value);
        }
        catch (Exception efr) {
            return false;
        }
        return true;
    }

    public static boolean isDouble(String value) {
        try {
            Double.parseDouble(value);
        }
        catch (Exception efr) {
            return false;
        }
        return true;
    }

    public String setPlaceholders(CommandSender sender, String s) {
        s = s.replace("%prefix%", this.getPrefix());
        if (sender instanceof Player) {
            s = s.replace("%player%", sender.getName());
        }
        s = Utils.setColor((String)s);
        return s;
    }

    public void noPermission(Player p) {
        this.sendMessage((CommandSender)p, this.pl.getMessages().getString("Withdraws.NoPermission"));
    }

    public static String formatDouble(double number) {
        return ConfigLang.NUMBER_FORMAT.format(number);
    }

    public static String formatNumber(int number) {
        return NumberFormat.getInstance(Locale.ENGLISH).format(number);
    }
}

