/*
 * Decompiled with CFR 0.152.
 */
package me.mraxetv.beastwithdraw.filemanager;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class FolderYaml {
    private JavaPlugin pl;
    private String name;
    private String folder;
    public File configf;
    public FileConfiguration config;

    public FolderYaml(JavaPlugin plugin, String folder, String n) {
        this.pl = plugin;
        this.name = n;
        this.folder = folder;
        this.createFiles(this.name);
        this.configUpdate();
    }

    public void reloadConfig() {
        this.createFiles(this.name);
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public void saveConfig() {
        try {
            this.config.save(this.configf);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void createFiles(String name) {
        this.configf = new File(this.pl.getDataFolder() + "/" + this.folder, name);
        if (!this.configf.exists()) {
            this.configf.getParentFile().mkdirs();
            this.pl.saveResource(this.folder + "\\" + name, false);
        }
        this.config = new YamlConfiguration();
        try {
            this.config.load(this.configf);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void configUpdate() {
        InputStreamReader jarInputStream = null;
        YamlConfiguration jarConfig = null;
        try {
            jarInputStream = new InputStreamReader(this.pl.getResource(this.folder + "/" + this.name), "UTF-8");
            if (jarInputStream != null) {
                jarConfig = YamlConfiguration.loadConfiguration((Reader)jarInputStream);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        if (this.getConfig().getDouble("ConfigVersion") < jarConfig.getDouble("ConfigVersion") || !this.getConfig().isSet("ConfigVersion")) {
            double oldVersion = this.getConfig().getDouble("ConfigVersion");
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy_MM_dd-HH.mm.ss");
            Date date = new Date();
            boolean renameResult = this.configf.renameTo(new File(this.pl.getDataFolder() + "/" + this.folder, this.name.replaceAll("\\.yml", "") + "_" + dateFormat.format(date) + "_old.yml"));
            if (renameResult) {
                this.pl.saveResource(this.folder + "\\" + this.name, false);
                this.createFiles(this.name);
                Bukkit.getConsoleSender().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&7[&4Beast&bTokens&7] &4Old " + this.name + " " + oldVersion + " has been replaced with new " + jarConfig.getDouble("ConfigVersion") + " version!")));
            } else {
                Bukkit.getConsoleSender().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&7[&4Beast&bTokens&7] &4Server has failed to replace old version of " + this.config + " please contact author MrAxeTv!")));
            }
        }
    }
}

