/*
 * Decompiled with CFR 0.152.
 */
package me.mraxetv.beastwithdraw.listener;

import java.util.HashSet;
import java.util.UUID;
import me.mraxetv.beastlib.lib.nbtapi.NBTItem;
import me.mraxetv.beastlib.lib.nbtapi.utils.MinecraftVersion;
import me.mraxetv.beastwithdraw.BeastWithdrawPlugin;
import me.mraxetv.beastwithdraw.events.BTokensRedeemEvent;
import me.mraxetv.beastwithdraw.events.CashRedeemEvent;
import me.mraxetv.beastwithdraw.events.CustomRedeemEvent;
import me.mraxetv.beastwithdraw.managers.AssetHandler;
import me.mraxetv.beastwithdraw.managers.redeem.RedeemRegistry;
import me.mraxetv.beastwithdraw.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class RedeemListener
implements Listener {
    private BeastWithdrawPlugin pl;
    private HashSet<UUID> delayList;

    public RedeemListener(BeastWithdrawPlugin plugin) {
        this.pl = plugin;
        this.pl.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.pl);
        this.delayList = new HashSet();
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void mainHand(PlayerInteractEvent e) {
        if (!e.hasItem()) {
            return;
        }
        if (e.getItem().getType() == Material.AIR) {
            return;
        }
        ItemStack item = e.getItem();
        if (!item.hasItemMeta()) {
            return;
        }
        if (e.getAction() != Action.RIGHT_CLICK_AIR && e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        NBTItem nbtItem = new NBTItem(item);
        if (!nbtItem.hasKey("RedeemType").booleanValue()) {
            return;
        }
        String type = nbtItem.getString("RedeemType").toLowerCase();
        AssetHandler assetHandler = this.pl.getWithdrawManager().getAssetHandler(type);
        double amount = nbtItem.getDouble(assetHandler.getNbtTag());
        final UUID uuid = e.getPlayer().getUniqueId();
        if (this.delayList.contains(uuid)) {
            return;
        }
        this.delayList.add(uuid);
        new BukkitRunnable(){

            public void run() {
                RedeemListener.this.delayList.remove(uuid);
            }
        }.runTaskLater((Plugin)this.pl, 1L);
        e.setCancelled(true);
        boolean offHand = false;
        if (MinecraftVersion.isAtLeastVersion((MinecraftVersion)MinecraftVersion.MC1_9_R1) && item.equals((Object)e.getPlayer().getInventory().getItemInOffHand())) {
            offHand = true;
        }
        CustomRedeemEvent event = RedeemRegistry.createEvent(type, e.getPlayer(), item, amount, offHand);
        Bukkit.getPluginManager().callEvent((Event)event);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void redeemEvent(BTokensRedeemEvent e) {
        this.handleGenericRedeem(e);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void redeemEvent(CashRedeemEvent e) {
        this.handleGenericRedeem(e);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void redeemEvent(CustomRedeemEvent e) {
        if (!((Object)((Object)e)).getClass().equals(CustomRedeemEvent.class)) {
            return;
        }
        this.handleGenericRedeem(e);
    }

    private void handleGenericRedeem(CustomRedeemEvent e) {
        if (e.isCancelled()) {
            return;
        }
        ItemStack item = e.getItem();
        Player p = e.getPlayer();
        AssetHandler assetHandler = this.pl.getWithdrawManager().getAssetHandler(e.getType());
        double tax = assetHandler.calculateTax(p, e.getAmount(), e.getItem());
        double amount = e.getAmount() - tax;
        assetHandler.depositAmount(p, amount);
        String msg = tax == 0.0 ? assetHandler.getMessageSection().getString("Redeem") : assetHandler.getMessageSection().getString("RedeemAndTax");
        msg = msg.replace("%amount%", "" + assetHandler.formatWithPreSuffix(amount));
        msg = msg.replace("%balance%", "" + assetHandler.formatWithPreSuffix(assetHandler.getBalance(p)));
        msg = msg.replace("%tax%", "" + assetHandler.formatWithPreSuffix(tax));
        this.pl.getUtils().sendMessage(p, msg);
        if (assetHandler.getConfig().getBoolean("Settings.Sounds.Redeem.Enabled")) {
            try {
                String sound = assetHandler.getConfig().getString("Settings.Sounds.Redeem.Sound");
                e.getPlayer().playSound(e.getPlayer().getLocation(), Sound.valueOf((String)sound), 1.0f, 1.0f);
            }
            catch (Exception e1) {
                ConsoleCommandSender consoleCommandSender = Bukkit.getServer().getConsoleSender();
                StringBuilder stringBuilder = new StringBuilder();
                this.pl.getUtils();
                consoleCommandSender.sendMessage(stringBuilder.append(Utils.getPrefix()).append("\ufffdcBroken sound in BeastTokensNote Redeem section!").toString());
            }
        }
        if (item.getAmount() > 1) {
            item.setAmount(item.getAmount() - 1);
        } else if (e.isOffHand()) {
            p.getInventory().setItemInOffHand(null);
        } else {
            p.getInventory().removeItem(new ItemStack[]{item});
        }
        p.updateInventory();
    }
}

