/*
 * Decompiled with CFR 0.152.
 */
package me.mraxetv.beastwithdraw.managers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import me.mraxetv.beastwithdraw.BeastWithdrawPlugin;
import me.mraxetv.beastwithdraw.managers.AssetHandler;
import me.mraxetv.beastwithdraw.managers.assets.BeastTokensHandler;
import me.mraxetv.beastwithdraw.managers.assets.CashNoteHandler;
import me.mraxetv.beastwithdraw.managers.assets.PlayerPointsHandler;
import me.mraxetv.beastwithdraw.managers.assets.XpBottleHandler;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class WithdrawManager {
    private BeastWithdrawPlugin pl;
    public static XpBottleHandler XP_BOTTLE = null;
    public static CashNoteHandler CASH_NOTE = null;
    public static BeastTokensHandler BEASTTOKENS_NOTE = null;
    public static PlayerPointsHandler PLAYERPOINTS_NOTE = null;
    private static HashMap<String, AssetHandler> assetsList;

    public WithdrawManager(BeastWithdrawPlugin pl) {
        this.pl = pl;
        this.initAssets();
    }

    public void initAssets() {
        assetsList = new HashMap();
        if (this.pl.getConfig().getBoolean("Settings.Withdraws.XpBottle.Enabled")) {
            XP_BOTTLE = new XpBottleHandler(BeastWithdrawPlugin.getInstance(), "XpBottle");
            assetsList.put("xpbottle", XP_BOTTLE);
        }
        if (this.pl.getConfig().getBoolean("Settings.Withdraws.CashNote.Enabled")) {
            if (this.pl.getServer().getPluginManager().isPluginEnabled("Vault")) {
                CASH_NOTE = new CashNoteHandler(BeastWithdrawPlugin.getInstance(), "CashNote");
                assetsList.put("cashnote", CASH_NOTE);
            } else {
                this.pl.getServer().getConsoleSender().sendMessage("[" + this.pl.getDescription().getPrefix() + "] Server is missing 'Vault' plugin which you need for economy(money) to work!");
            }
        }
        if (this.pl.getConfig().getBoolean("Settings.Withdraws.BeastTokensNote.Enabled")) {
            if (this.pl.getServer().getPluginManager().isPluginEnabled("BeastTokens")) {
                BEASTTOKENS_NOTE = new BeastTokensHandler(BeastWithdrawPlugin.getInstance(), "BeastTokensNote");
                assetsList.put("beasttokensnote", BEASTTOKENS_NOTE);
            } else {
                BeastWithdrawPlugin.getInstance().getUtils().sendMessage((CommandSender)this.pl.getServer().getConsoleSender(), "&4[" + this.pl.getDescription().getName() + "] &cServer is missing 'BeastTokens' plugin which you need for 'Tokens Note' to work!");
            }
        }
        if (this.pl.getConfig().getBoolean("Settings.Withdraws.PlayerPointsNote.Enabled")) {
            if (this.pl.getServer().getPluginManager().isPluginEnabled("PlayerPoints")) {
                PLAYERPOINTS_NOTE = new PlayerPointsHandler(BeastWithdrawPlugin.getInstance(), "PlayerPointsNote");
                assetsList.put("playerpointsnote", PLAYERPOINTS_NOTE);
            } else {
                BeastWithdrawPlugin.getInstance().getUtils().sendMessage((CommandSender)this.pl.getServer().getConsoleSender(), "&4[" + this.pl.getDescription().getName() + "] &cServer is missing 'PlayerPoints' plugin which you need for 'PlayerPoints Note' to work!");
            }
        }
        new BukkitRunnable(){

            public void run() {
                try {
                    Bukkit.getServer().getClass().getMethod("syncCommands", new Class[0]).invoke((Object)Bukkit.getServer(), new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.runTaskLater((Plugin)this.pl, 1L);
    }

    public List<String> getAssetHandlerList() {
        return new ArrayList<String>(assetsList.keySet());
    }

    public AssetHandler getAssetHandler(String id) {
        return assetsList.get(id.toLowerCase());
    }

    public boolean hasAssetHandler(String id) {
        return assetsList.containsKey(id.toLowerCase());
    }
}

