/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.hex.config;

import com.mrbysco.hex.Hex;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class HexConfig {
    public static final ModConfigSpec commonSpec;
    public static final Common COMMON;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        Hex.LOGGER.debug("Loaded Hex's config file {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading configEvent) {
        Hex.LOGGER.debug("Hex's config just got changed on the file system!");
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(Common::new);
        commonSpec = (ModConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ModConfigSpec.DoubleValue affectionPercentage;
        public final ModConfigSpec.BooleanValue avoidingUponDeath;

        Common(ModConfigSpec.Builder builder) {
            builder.comment("General settings").push("General");
            this.affectionPercentage = builder.comment("Defines the durability percentage that affects the Affection Enchantment [Default: 0.01 (1%)]").defineInRange("affectionPercentage", 0.01, 0.01, 1.0);
            this.avoidingUponDeath = builder.comment("Defines if the Avoiding Enchantment should teleport the item to world spawn upon death [Default: true]").define("avoidingUponDeath", true);
            builder.pop();
        }
    }
}

