/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.hex.datagen;

import com.mrbysco.hex.registry.EnchantmentRegistry;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.EnchantmentTagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.item.enchantment.Enchantment;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber
public class HexDatagen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent.Client event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(true, (DataProvider)new ModDatapackProvider(packOutput, event.getLookupProvider(), Set.of("hex")));
        generator.addProvider(true, (DataProvider)new ModEnchantmentTagProvider(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new HexLanguage(packOutput));
    }

    public static class ModDatapackProvider
    extends DatapackBuiltinEntriesProvider {
        public static final RegistrySetBuilder BUILDER = new RegistrySetBuilder().add(Registries.ENCHANTMENT, EnchantmentRegistry::bootstrap);

        public ModDatapackProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, Set<String> modIds) {
            super(output, registries, BUILDER, modIds);
        }
    }

    private static class ModEnchantmentTagProvider
    extends EnchantmentTagsProvider {
        public ModEnchantmentTagProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
            super(output, lookupProvider, "hex");
        }

        protected void addTags(HolderLookup.Provider pProvider) {
            this.tag(EnchantmentTags.CURSE).addOptional(EnchantmentRegistry.AFFECTION).addOptional(EnchantmentRegistry.NONCOMBINING);
            this.tag(EnchantmentTags.TREASURE).addOptional(EnchantmentRegistry.AFFECTION).addOptional(EnchantmentRegistry.NONCOMBINING);
            this.tag(EnchantmentTags.NON_TREASURE).addOptional(EnchantmentRegistry.CULTIVATION).addOptional(EnchantmentRegistry.YIELDING).addOptional(EnchantmentRegistry.YING).addOptional(EnchantmentRegistry.YANG).addOptional(EnchantmentRegistry.GOLDEN_GLINT).addOptional(EnchantmentRegistry.AVOIDING).addOptional(EnchantmentRegistry.CHEAPSKATE);
        }
    }

    private static class HexLanguage
    extends LanguageProvider {
        public HexLanguage(PackOutput gen) {
            super(gen, "hex", "en_us");
        }

        protected void addTranslations() {
            this.addEnchantment(EnchantmentRegistry.CULTIVATION, "Cultivation");
            this.addEnchantmentDescription(EnchantmentRegistry.CULTIVATION, "Tills an area around water when right-clicked");
            this.addEnchantment(EnchantmentRegistry.YIELDING, "Yielding");
            this.addEnchantmentDescription(EnchantmentRegistry.YIELDING, "Increases the amount of crops you can harvest");
            this.addEnchantment(EnchantmentRegistry.AFFECTION, "Curse of Affection");
            this.addEnchantmentDescription(EnchantmentRegistry.AFFECTION, "Prevents the item from reaching durability 0");
            this.addEnchantment(EnchantmentRegistry.YING, "Ying");
            this.addEnchantmentDescription(EnchantmentRegistry.YING, "Repairs the item up to 50% while in darkness");
            this.addEnchantment(EnchantmentRegistry.YANG, "Yang");
            this.addEnchantmentDescription(EnchantmentRegistry.YANG, "Repairs the item up to 50% while in light");
            this.addEnchantment(EnchantmentRegistry.GOLDEN_GLINT, "Golden Glint");
            this.addEnchantmentDescription(EnchantmentRegistry.GOLDEN_GLINT, "Tricks Piglins into thinking you are wearing gold armor");
            this.addEnchantment(EnchantmentRegistry.AVOIDING, "Avoiding");
            this.addEnchantmentDescription(EnchantmentRegistry.AVOIDING, "Upon falling into the void teleports the item to world spawn");
            this.addEnchantment(EnchantmentRegistry.CHEAPSKATE, "Cheap Skate");
            this.addEnchantmentDescription(EnchantmentRegistry.CHEAPSKATE, "Locks the base repair level of an item");
            this.addEnchantment(EnchantmentRegistry.NONCOMBINING, "Curse of Non Combining");
            this.addEnchantmentDescription(EnchantmentRegistry.NONCOMBINING, "Stops the tool from being used in repair recipes");
        }

        private void addEnchantment(ResourceKey<Enchantment> key, String name) {
            ResourceLocation location = key.location();
            this.add("enchantment." + location.getNamespace() + "." + location.getPath(), name);
        }

        private void addEnchantmentDescription(ResourceKey<Enchantment> key, String description) {
            ResourceLocation location = key.location();
            this.add("enchantment." + location.getNamespace() + "." + location.getPath() + ".desc", description);
        }
    }
}

