/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.hex.handler;

import com.mrbysco.hex.config.HexConfig;
import com.mrbysco.hex.registry.EnchantmentEffectRegistry;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;

public class AvoidingHandler {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onLivingDrops(LivingDropsEvent event) {
        Collection drops = event.getDrops();
        ArrayList<ItemEntity> toRemove = new ArrayList<ItemEntity>();
        boolean avoidingFlag = (Boolean)HexConfig.COMMON.avoidingUponDeath.get();
        if (avoidingFlag) {
            for (ItemEntity drop : drops) {
                ItemStack stack = drop.getItem().copy();
                if (!EnchantmentHelper.has((ItemStack)stack, (DataComponentType)((DataComponentType)EnchantmentEffectRegistry.AVOIDING.get()))) continue;
                Level level = drop.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    if (!level.dimension().location().equals((Object)Level.OVERWORLD.location())) {
                        MinecraftServer server = serverLevel.getServer();
                        serverLevel = server.overworld();
                    }
                    BlockPos spawnPos = serverLevel.getRespawnData().pos();
                    ItemEntity newEntity = new ItemEntity((Level)serverLevel, (double)spawnPos.getX(), (double)spawnPos.getY() + 0.5, (double)spawnPos.getZ(), stack);
                    serverLevel.addFreshEntity((Entity)newEntity);
                }
                toRemove.add(drop);
            }
        }
        drops.removeAll(toRemove);
    }

    public static void entityLeaveWorldEvent(ItemEntity itemEntity) {
        Level level = itemEntity.level();
        ItemStack stack = itemEntity.getItem().copy();
        if (!level.isClientSide() && EnchantmentHelper.has((ItemStack)stack, (DataComponentType)((DataComponentType)EnchantmentEffectRegistry.AVOIDING.get()))) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!level.dimension().location().equals((Object)Level.OVERWORLD.location())) {
                MinecraftServer server = serverLevel.getServer();
                serverLevel = server.getLevel(Level.OVERWORLD);
            }
            BlockPos spawnPos = serverLevel.getRespawnData().pos();
            ItemEntity newEntity = new ItemEntity((Level)serverLevel, (double)spawnPos.getX(), (double)spawnPos.getY() + 0.5, (double)spawnPos.getZ(), stack);
            serverLevel.addFreshEntity((Entity)newEntity);
        }
    }
}

