/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.hex.handler;

import com.mrbysco.hex.config.HexConfig;
import com.mrbysco.hex.registry.EnchantmentEffectRegistry;
import com.mrbysco.hex.registry.EnchantmentRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.ICancellableEvent;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class EnchantmentHandler {
    @SubscribeEvent
    public void onPlayerLeftClickEmpty(PlayerInteractEvent.LeftClickEmpty event) {
        ItemStack stack = event.getItemStack();
        this.handleAffection(stack, (Event)event);
    }

    @SubscribeEvent
    public void onPlayerLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        ItemStack stack = event.getItemStack();
        this.handleAffection(stack, (Event)event);
    }

    @SubscribeEvent
    public void onPlayerLeftClickEmpty(PlayerInteractEvent.RightClickEmpty event) {
        ItemStack stack = event.getItemStack();
        this.handleAffection(stack, (Event)event);
    }

    @SubscribeEvent
    public void onPlayerLeftClickBlock(PlayerInteractEvent.RightClickBlock event) {
        ItemStack stack = event.getItemStack();
        this.handleAffection(stack, (Event)event);
    }

    @SubscribeEvent
    public void onPlayerEntityInteract(PlayerInteractEvent.EntityInteract event) {
        ItemStack stack = event.getItemStack();
        this.handleAffection(stack, (Event)event);
    }

    @SubscribeEvent
    public void onPlayerEntityInteractSpecific(PlayerInteractEvent.EntityInteractSpecific event) {
        ItemStack stack = event.getItemStack();
        this.handleAffection(stack, (Event)event);
    }

    @SubscribeEvent
    public void onPlayerAttack(AttackEntityEvent event) {
        Player player = event.getEntity();
        this.handleAffection(player.getMainHandItem(), (Event)event);
    }

    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        BlockHitResult hitResult;
        BlockHitResult oldHitResult = event.getHitVec();
        Level level = event.getLevel();
        Player player = event.getEntity();
        ItemStack stack = event.getItemStack();
        int cultivationLevel = stack.getEnchantmentLevel(level.holderOrThrow(EnchantmentRegistry.CULTIVATION));
        if (cultivationLevel > 0 && (hitResult = EnchantmentHandler.getPlayerPOVHitResult(level, player, ClipContext.Fluid.ANY)).getType() != HitResult.Type.MISS && hitResult.getType() == HitResult.Type.BLOCK) {
            FluidState state;
            BlockPos blockpos = hitResult.getBlockPos();
            Direction direction = hitResult.getDirection();
            BlockPos relativePos = blockpos.relative(direction);
            if (level.mayInteract((Entity)player, blockpos) && player.mayUseItemAt(relativePos, direction, stack) && (state = level.getFluidState(blockpos)).is(FluidTags.WATER)) {
                for (int x = -cultivationLevel; x <= cultivationLevel; ++x) {
                    for (int y = -cultivationLevel; y <= cultivationLevel; ++y) {
                        Vec3 vec3 = oldHitResult.getLocation().add((double)x, 0.0, (double)y);
                        BlockPos newPos = blockpos.offset(x, 0, y);
                        stack.useOn(new UseOnContext(player, event.getHand(), new BlockHitResult(vec3, Direction.UP, newPos, false)));
                    }
                }
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        Level level = event.getLevel();
        Player player = event.getEntity();
        ItemStack stack = event.getItemStack();
        BlockPos blockpos = event.getPos();
        InteractionHand hand = event.getHand();
        int yieldingLevel = stack.getEnchantmentLevel(level.holderOrThrow(EnchantmentRegistry.YIELDING));
        if (yieldingLevel > 0) {
            for (int x = -yieldingLevel; x <= yieldingLevel; ++x) {
                for (int y = -yieldingLevel; y <= yieldingLevel; ++y) {
                    BlockPos newPos = blockpos.offset(x, 0, y);
                    BlockState state = level.getBlockState(newPos);
                    if (!(state.getBlock() instanceof BushBlock) && !(state.getBlock() instanceof LeavesBlock)) continue;
                    EquipmentSlot slot = hand == InteractionHand.OFF_HAND ? EquipmentSlot.OFFHAND : EquipmentSlot.MAINHAND;
                    Block block = state.getBlock();
                    if (block instanceof CropBlock) {
                        CropBlock cropBlock = (CropBlock)block;
                        if (cropBlock.isMaxAge(state)) {
                            if (!player.isCreative()) {
                                stack.hurtAndBreak(1, (LivingEntity)player, slot);
                            }
                            level.destroyBlock(newPos, !player.isCreative(), (Entity)player);
                        }
                    } else {
                        if (!player.isCreative()) {
                            stack.hurtAndBreak(1, (LivingEntity)player, slot);
                        }
                        level.destroyBlock(newPos, true, (Entity)player);
                    }
                    event.setCanceled(true);
                }
            }
        }
    }

    private void handleAffection(ItemStack stack, Event event) {
        if (event instanceof ICancellableEvent) {
            int minAllowed;
            int maxDamage;
            int damage;
            ICancellableEvent cancellableEvent = (ICancellableEvent)event;
            if (EnchantmentHelper.has((ItemStack)stack, (DataComponentType)((DataComponentType)EnchantmentEffectRegistry.AFFECTION.get())) && (damage = (maxDamage = stack.getMaxDamage()) - stack.getDamageValue()) <= (minAllowed = (int)Math.floor((double)maxDamage * (Double)HexConfig.COMMON.affectionPercentage.get()) + 1)) {
                cancellableEvent.setCanceled(true);
            }
        }
    }

    protected static BlockHitResult getPlayerPOVHitResult(Level level, Player player, ClipContext.Fluid fluidContext) {
        float xRot = player.getXRot();
        float yRot = player.getYRot();
        Vec3 eyePosition = player.getEyePosition();
        float f2 = Mth.cos((float)(-yRot * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.sin((float)(-yRot * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.cos((float)(-xRot * ((float)Math.PI / 180)));
        float f5 = Mth.sin((float)(-xRot * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double reach = player.blockInteractionRange();
        Vec3 vec31 = eyePosition.add((double)f6 * reach, (double)f5 * reach, (double)f7 * reach);
        return level.clip(new ClipContext(eyePosition, vec31, ClipContext.Block.OUTLINE, fluidContext, (Entity)player));
    }
}

