/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.hex.handler;

import com.mrbysco.hex.registry.EnchantmentEffectRegistry;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public class YingYangHandler {
    @SubscribeEvent
    public void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        Level level = player.level();
        if (!level.isClientSide() && player != null) {
            BlockPos pos = player.blockPosition();
            if (!player.isSpectator() && level.getGameTime() % 50L == 0L) {
                int lightEmission = level.getRawBrightness(pos, 0);
                this.repairYingItems(player, lightEmission);
                this.repairYangItems(player, lightEmission);
            }
        }
    }

    private void repairYingItems(Player player, int lightValue) {
        Predicate<ItemStack> stackPredicate = stack -> stack.isDamaged() && stack.getDamageValue() > (int)((double)stack.getMaxDamage() / 2.0) && EnchantmentHelper.has((ItemStack)stack, (DataComponentType)((DataComponentType)EnchantmentEffectRegistry.YING.get()));
        if (lightValue <= 7) {
            ItemStack stack2;
            for (EquipmentSlot slot : EquipmentSlotGroup.ARMOR) {
                stack2 = player.getItemBySlot(slot);
                if (!stackPredicate.test(stack2)) continue;
                stack2.setDamageValue(stack2.getDamageValue() - 1);
            }
            for (EquipmentSlot slot : EquipmentSlotGroup.HAND) {
                stack2 = player.getItemBySlot(slot);
                if (!stackPredicate.test(stack2)) continue;
                stack2.setDamageValue(stack2.getDamageValue() - 1);
            }
        }
    }

    private void repairYangItems(Player player, int lightValue) {
        Predicate<ItemStack> stackPredicate = stack -> stack.isDamaged() && stack.getDamageValue() > (int)((double)stack.getMaxDamage() / 2.0) && EnchantmentHelper.has((ItemStack)stack, (DataComponentType)((DataComponentType)EnchantmentEffectRegistry.YANG.get()));
        if (lightValue > 7) {
            ItemStack stack2;
            for (EquipmentSlot slot : EquipmentSlotGroup.ARMOR) {
                stack2 = player.getItemBySlot(slot);
                if (!stackPredicate.test(stack2)) continue;
                stack2.setDamageValue(stack2.getDamageValue() - 1);
            }
            for (EquipmentSlot slot : EquipmentSlotGroup.HAND) {
                stack2 = player.getItemBySlot(slot);
                if (!stackPredicate.test(stack2)) continue;
                stack2.setDamageValue(stack2.getDamageValue() - 1);
            }
        }
    }
}

