/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.hex.registry;

import com.mrbysco.hex.registry.EnchantmentEffectRegistry;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.item.enchantment.Enchantment;

public class EnchantmentRegistry {
    public static final ResourceKey<Enchantment> CULTIVATION = EnchantmentRegistry.key("cultivation");
    public static final ResourceKey<Enchantment> YIELDING = EnchantmentRegistry.key("yielding");
    public static final ResourceKey<Enchantment> AFFECTION = EnchantmentRegistry.key("affection");
    public static final ResourceKey<Enchantment> YING = EnchantmentRegistry.key("ying");
    public static final ResourceKey<Enchantment> YANG = EnchantmentRegistry.key("yang");
    public static final ResourceKey<Enchantment> GOLDEN_GLINT = EnchantmentRegistry.key("golden_glint");
    public static final ResourceKey<Enchantment> AVOIDING = EnchantmentRegistry.key("avoiding");
    public static final ResourceKey<Enchantment> CHEAPSKATE = EnchantmentRegistry.key("cheapskate");
    public static final ResourceKey<Enchantment> NONCOMBINING = EnchantmentRegistry.key("noncombining");

    public static void bootstrap(BootstrapContext<Enchantment> context) {
        HolderGetter itemHolderGetter = context.lookup(Registries.ITEM);
        EnchantmentRegistry.register(context, CULTIVATION, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)itemHolderGetter.getOrThrow(ItemTags.HOES), (int)5, (int)3, (Enchantment.Cost)Enchantment.dynamicCost((int)12, (int)7), (Enchantment.Cost)Enchantment.constantCost((int)50), (int)2, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.MAINHAND})));
        EnchantmentRegistry.register(context, YIELDING, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)itemHolderGetter.getOrThrow(ItemTags.HOES), (int)5, (int)4, (Enchantment.Cost)Enchantment.dynamicCost((int)12, (int)7), (Enchantment.Cost)Enchantment.constantCost((int)50), (int)2, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.MAINHAND})));
        EnchantmentRegistry.register(context, AFFECTION, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)itemHolderGetter.getOrThrow(ItemTags.VANISHING_ENCHANTABLE), (int)1, (int)1, (Enchantment.Cost)Enchantment.constantCost((int)25), (Enchantment.Cost)Enchantment.constantCost((int)50), (int)2, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.ANY})).withEffect((DataComponentType)EnchantmentEffectRegistry.AFFECTION.get()));
        EnchantmentRegistry.register(context, YING, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)itemHolderGetter.getOrThrow(ItemTags.VANISHING_ENCHANTABLE), (int)2, (int)1, (Enchantment.Cost)Enchantment.constantCost((int)30), (Enchantment.Cost)Enchantment.constantCost((int)80), (int)2, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.ANY})).withEffect((DataComponentType)EnchantmentEffectRegistry.YING.get()));
        EnchantmentRegistry.register(context, YANG, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)itemHolderGetter.getOrThrow(ItemTags.VANISHING_ENCHANTABLE), (int)2, (int)1, (Enchantment.Cost)Enchantment.constantCost((int)30), (Enchantment.Cost)Enchantment.constantCost((int)80), (int)2, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.ANY})).withEffect((DataComponentType)EnchantmentEffectRegistry.YANG.get()));
        EnchantmentRegistry.register(context, GOLDEN_GLINT, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)itemHolderGetter.getOrThrow(ItemTags.VANISHING_ENCHANTABLE), (int)1, (int)1, (Enchantment.Cost)Enchantment.constantCost((int)25), (Enchantment.Cost)Enchantment.constantCost((int)75), (int)2, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.ARMOR})).withEffect((DataComponentType)EnchantmentEffectRegistry.GOLDEN_GLINT.get()));
        EnchantmentRegistry.register(context, AVOIDING, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)itemHolderGetter.getOrThrow(ItemTags.VANISHING_ENCHANTABLE), (int)2, (int)1, (Enchantment.Cost)Enchantment.constantCost((int)32), (Enchantment.Cost)Enchantment.constantCost((int)82), (int)2, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.ANY})).withEffect((DataComponentType)EnchantmentEffectRegistry.AVOIDING.get()));
        EnchantmentRegistry.register(context, CHEAPSKATE, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)itemHolderGetter.getOrThrow(ItemTags.DURABILITY_ENCHANTABLE), (int)5, (int)1, (Enchantment.Cost)Enchantment.constantCost((int)10), (Enchantment.Cost)Enchantment.constantCost((int)15), (int)2, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.ANY})));
        EnchantmentRegistry.register(context, NONCOMBINING, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)itemHolderGetter.getOrThrow(ItemTags.DURABILITY_ENCHANTABLE), (int)1, (int)1, (Enchantment.Cost)Enchantment.constantCost((int)25), (Enchantment.Cost)Enchantment.constantCost((int)50), (int)1, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.ANY})).withEffect((DataComponentType)EnchantmentEffectRegistry.NON_COMBINING.get()));
    }

    private static ResourceKey<Enchantment> key(String path) {
        return ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"hex", (String)path));
    }

    private static void register(BootstrapContext<Enchantment> context, ResourceKey<Enchantment> resourceKey, Enchantment.Builder builder) {
        context.register(resourceKey, (Object)builder.build(resourceKey.location()));
    }
}

