/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.JsonParseException;
import com.google.gson.ToNumberStrategy;
import com.google.gson.internal.LazilyParsedNumber;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.MalformedJsonException;
import java.math.BigDecimal;

public enum ToNumberPolicy implements ToNumberStrategy
{
    DOUBLE{

        @Override
        public final /* synthetic */ Number readNumber(JsonReader jsonReader) {
            return jsonReader.nextDouble();
        }
    }
    ,
    LAZILY_PARSED_NUMBER{

        /*
         * WARNING - void declaration
         */
        @Override
        public final Number readNumber(JsonReader in) {
            void var1_1;
            return new LazilyParsedNumber(var1_1.nextString());
        }
    }
    ,
    LONG_OR_DOUBLE{

        /*
         * WARNING - void declaration
         */
        @Override
        public final Number readNumber(JsonReader in) {
            String string = in.nextString();
            try {
                return Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    Double d2 = Double.valueOf(string);
                    if ((d2.isInfinite() || d2.isNaN()) && !in.isLenient()) {
                        throw new MalformedJsonException("JSON forbids NaN and infinities: " + d2 + "; at path " + in.getPreviousPath());
                    }
                    return d2;
                }
                catch (NumberFormatException numberFormatException2) {
                    void var1_1;
                    throw new JsonParseException("Cannot parse " + string + "; at path " + var1_1.getPreviousPath(), numberFormatException2);
                }
            }
        }
    }
    ,
    BIG_DECIMAL{

        private static BigDecimal a(JsonReader jsonReader) {
            String string = jsonReader.nextString();
            try {
                return new BigDecimal(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new JsonParseException("Cannot parse " + string + "; at path " + jsonReader.getPreviousPath(), numberFormatException);
            }
        }

        @Override
        public final /* synthetic */ Number readNumber(JsonReader jsonReader) {
            return 4.a(jsonReader);
        }
    };


    private ToNumberPolicy() {
    }

    /*
     * WARNING - void declaration
     */
    /* synthetic */ ToNumberPolicy(String x0, int x1, byte by) {
        this();
        void var2_2;
        void var1_1;
    }
}

