/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.JavaVersion;
import com.google.gson.internal.PreJava9DateFormatProvider;
import com.google.gson.internal.bind.TypeAdapters;
import com.google.gson.internal.bind.util.ISO8601Utils;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public final class DefaultDateTypeAdapter<T extends Date>
extends TypeAdapter<T> {
    private final DateType<T> a;
    private final List<DateFormat> b = new ArrayList<DateFormat>();

    /*
     * WARNING - void declaration
     */
    private DefaultDateTypeAdapter(DateType<T> dateType, String datePattern) {
        void var1_1;
        this.a = (DateType)Objects.requireNonNull(var1_1);
        this.b.add(new SimpleDateFormat(datePattern, Locale.US));
        if (!Locale.getDefault().equals(Locale.US)) {
            void var2_2;
            this.b.add(new SimpleDateFormat((String)var2_2));
        }
    }

    /*
     * WARNING - void declaration
     */
    private DefaultDateTypeAdapter(DateType<T> dateType, int style) {
        void var1_1;
        this.a = (DateType)Objects.requireNonNull(var1_1);
        this.b.add(DateFormat.getDateInstance(style, Locale.US));
        if (!Locale.getDefault().equals(Locale.US)) {
            this.b.add(DateFormat.getDateInstance(style));
        }
        if (JavaVersion.isJava9OrLater()) {
            void var2_2;
            this.b.add(PreJava9DateFormatProvider.getUSDateFormat((int)var2_2));
        }
    }

    /*
     * WARNING - void declaration
     */
    private DefaultDateTypeAdapter(DateType<T> dateType, int dateStyle, int timeStyle) {
        void var1_1;
        this.a = (DateType)Objects.requireNonNull(var1_1);
        this.b.add(DateFormat.getDateTimeInstance(dateStyle, timeStyle, Locale.US));
        if (!Locale.getDefault().equals(Locale.US)) {
            this.b.add(DateFormat.getDateTimeInstance(dateStyle, timeStyle));
        }
        if (JavaVersion.isJava9OrLater()) {
            void var3_3;
            void var2_2;
            this.b.add(PreJava9DateFormatProvider.getUSDateTimeFormat((int)var2_2, (int)var3_3));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void write(JsonWriter out, Date value) {
        void var1_1;
        String string;
        if (value == null) {
            out.nullValue();
            return;
        }
        DateFormat dateFormat = this.b.get(0);
        List<DateFormat> list = this.b;
        synchronized (list) {
            string = dateFormat.format((Date)((Object)string));
        }
        var1_1.value(string);
    }

    @Override
    public final T read(JsonReader in) {
        Date date;
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        date = this.a((JsonReader)((Object)date));
        return this.a.a(date);
    }

    private Date a(JsonReader jsonReader) {
        String string = jsonReader.nextString();
        List<DateFormat> list = this.b;
        synchronized (list) {
            for (DateFormat dateFormat : this.b) {
                try {
                    return dateFormat.parse(string);
                }
                catch (ParseException parseException) {
                }
            }
            try {
                return ISO8601Utils.parse(string, new ParsePosition(0));
            }
            catch (ParseException parseException) {
                throw new JsonSyntaxException("Failed parsing '" + string + "' as Date; at path " + jsonReader.getPreviousPath(), parseException);
            }
        }
    }

    public final String toString() {
        DateFormat dateFormat = this.b.get(0);
        if (dateFormat instanceof SimpleDateFormat) {
            return "DefaultDateTypeAdapter(" + ((SimpleDateFormat)dateFormat).toPattern() + ')';
        }
        return "DefaultDateTypeAdapter(" + dateFormat.getClass().getSimpleName() + ')';
    }

    /*
     * WARNING - void declaration
     */
    /* synthetic */ DefaultDateTypeAdapter(DateType x0, String x1, byte by) {
        this((DateType<T>)var1_1, (String)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    /* synthetic */ DefaultDateTypeAdapter(DateType x0, int x1, byte by) {
        this((DateType<T>)var1_1, (int)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    /* synthetic */ DefaultDateTypeAdapter(DateType x0, int x1, int x2, byte by) {
        this((DateType<T>)var1_1, (int)var2_2, (int)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    public static abstract class DateType<T extends Date> {
        public static final DateType<Date> DATE = new DateType<Date>(Date.class){

            @Override
            protected final Date a(Date date) {
                return date;
            }
        };
        private final Class<T> a;

        /*
         * WARNING - void declaration
         */
        protected DateType(Class<T> dateClass) {
            void var1_1;
            this.a = var1_1;
        }

        protected abstract T a(Date var1);

        private TypeAdapterFactory a(DefaultDateTypeAdapter<T> defaultDateTypeAdapter) {
            return TypeAdapters.newFactory(this.a, defaultDateTypeAdapter);
        }

        /*
         * WARNING - void declaration
         */
        public final TypeAdapterFactory createAdapterFactory(String datePattern) {
            void var1_1;
            return this.a(new DefaultDateTypeAdapter(this, (String)var1_1, 0));
        }

        /*
         * WARNING - void declaration
         */
        public final TypeAdapterFactory createAdapterFactory(int style) {
            void var1_1;
            return this.a(new DefaultDateTypeAdapter(this, (int)var1_1, 0));
        }

        /*
         * WARNING - void declaration
         */
        public final TypeAdapterFactory createAdapterFactory(int dateStyle, int timeStyle) {
            void var2_2;
            void var1_1;
            return this.a(new DefaultDateTypeAdapter(this, (int)var1_1, (int)var2_2, 0));
        }

        public final TypeAdapterFactory createDefaultsAdapterFactory() {
            return this.a(new DefaultDateTypeAdapter(this, 2, 2, 0));
        }
    }
}

