/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.internal.LazilyParsedNumber;
import com.google.gson.internal.bind.JsonTreeReader;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Currency;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;

public final class TypeAdapters {
    public static final TypeAdapter<Class> CLASS = new TypeAdapter<Class>(){

        @Override
        public final /* synthetic */ Object read(JsonReader jsonReader) {
            throw new UnsupportedOperationException("Attempted to deserialize a java.lang.Class. Forgot to register a type adapter?");
        }

        @Override
        public final /* synthetic */ void write(JsonWriter object, Object object2) {
            object = (Class)object2;
            throw new UnsupportedOperationException("Attempted to serialize java.lang.Class: " + ((Class)object).getName() + ". Forgot to register a type adapter?");
        }
    }.nullSafe();
    public static final TypeAdapterFactory CLASS_FACTORY = TypeAdapters.newFactory(Class.class, CLASS);
    public static final TypeAdapter<BitSet> BIT_SET = new TypeAdapter<BitSet>(){

        @Override
        public final /* synthetic */ Object read(JsonReader jsonReader) {
            BitSet bitSet = new BitSet();
            jsonReader.beginArray();
            int n2 = 0;
            JsonToken jsonToken = jsonReader.peek();
            while (jsonToken != JsonToken.END_ARRAY) {
                int n3;
                switch (jsonToken) {
                    case NUMBER: 
                    case STRING: {
                        n3 = jsonReader.nextInt();
                        if (n3 == 0) {
                            n3 = 0;
                            break;
                        }
                        if (n3 == 1) {
                            n3 = 1;
                            break;
                        }
                        throw new JsonSyntaxException("Invalid bitset value " + n3 + ", expected 0 or 1; at path " + jsonReader.getPreviousPath());
                    }
                    case BOOLEAN: {
                        n3 = jsonReader.nextBoolean();
                        break;
                    }
                    default: {
                        throw new JsonSyntaxException("Invalid bitset value type: " + (Object)((Object)jsonToken) + "; at path " + jsonReader.getPath());
                    }
                }
                if (n3 != 0) {
                    bitSet.set(n2);
                }
                ++n2;
                jsonToken = jsonReader.peek();
            }
            jsonReader.endArray();
            return bitSet;
        }

        @Override
        public final /* synthetic */ void write(JsonWriter jsonWriter, Object object) {
            object = (BitSet)object;
            jsonWriter.beginArray();
            int n2 = ((BitSet)object).length();
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = ((BitSet)object).get(i2) ? 1 : 0;
                jsonWriter.value(n3);
            }
            jsonWriter.endArray();
        }
    }.nullSafe();
    public static final TypeAdapterFactory BIT_SET_FACTORY = TypeAdapters.newFactory(BitSet.class, BIT_SET);
    public static final TypeAdapter<Boolean> BOOLEAN = new TypeAdapter<Boolean>(){

        @Override
        public final /* synthetic */ Object read(JsonReader jsonReader) {
            JsonToken jsonToken = jsonReader.peek();
            if (jsonToken == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            if (jsonToken == JsonToken.STRING) {
                return Boolean.parseBoolean(jsonReader.nextString());
            }
            return jsonReader.nextBoolean();
        }

        @Override
        public final /* synthetic */ void write(JsonWriter jsonWriter, Object object) {
            object = (Boolean)object;
            jsonWriter.value((Boolean)object);
        }
    };
    public static final TypeAdapter<Boolean> BOOLEAN_AS_STRING = new TypeAdapter<Boolean>(){

        @Override
        public final /* synthetic */ Object read(JsonReader jsonReader) {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            return Boolean.valueOf(jsonReader.nextString());
        }

        @Override
        public final /* synthetic */ void write(JsonWriter jsonWriter, Object object) {
            jsonWriter.value((object = (Boolean)object) == null ? "null" : ((Boolean)object).toString());
        }
    };
    public static final TypeAdapterFactory BOOLEAN_FACTORY = TypeAdapters.newFactory(Boolean.TYPE, Boolean.class, BOOLEAN);
    public static final TypeAdapter<Number> BYTE = new TypeAdapter<Number>(){

        private static Number a(JsonReader jsonReader) {
            int n2;
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            try {
                n2 = jsonReader.nextInt();
            }
            catch (NumberFormatException numberFormatException) {
                throw new JsonSyntaxException(numberFormatException);
            }
            if (n2 > 255 || n2 < -128) {
                throw new JsonSyntaxException("Lossy conversion from " + n2 + " to byte; at path " + jsonReader.getPreviousPath());
            }
            return (byte)n2;
        }

        @Override
        public final /* synthetic */ Object read(JsonReader jsonReader) {
            return 31.a(jsonReader);
        }

        @Override
        public final /* synthetic */ void write(JsonWriter jsonWriter, Object object) {
            if ((object = (Number)object) == null) {
                jsonWriter.nullValue();
                return;
            }
            jsonWriter.value(((Number)object).byteValue());
        }
    };
    public static final TypeAdapterFactory BYTE_FACTORY = TypeAdapters.newFactory(Byte.TYPE, Byte.class, BYTE);
    public static final TypeAdapter<Number> SHORT = new TypeAdapter<Number>(){

        private static Number a(JsonReader jsonReader) {
            int n2;
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            try {
                n2 = jsonReader.nextInt();
            }
            catch (NumberFormatException numberFormatException) {
                throw new JsonSyntaxException(numberFormatException);
            }
            if (n2 > 65535 || n2 < Short.MIN_VALUE) {
                throw new JsonSyntaxException("Lossy conversion from " + n2 + " to short; at path " + jsonReader.getPreviousPath());
            }
            return (short)n2;
        }

        @Override
        public final /* synthetic */ Object read(JsonReader jsonReader) {
            return 32.a(jsonReader);
        }

        @Override
        public final /* synthetic */ void write(JsonWriter jsonWriter, Object object) {
            if ((object = (Number)object) == null) {
                jsonWriter.nullValue();
                return;
            }
            jsonWriter.value(((Number)object).shortValue());
        }
    };
    public static final TypeAdapterFactory SHORT_FACTORY = TypeAdapters.newFactory(Short.TYPE, Short.class, SHORT);
    public static final TypeAdapter<Number> INTEGER = new TypeAdapter<Number>(){

        private static Number a(JsonReader jsonReader) {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            try {
                return jsonReader.nextInt();
            }
            catch (NumberFormatException numberFormatException) {
                throw new JsonSyntaxException(numberFormatException);
            }
        }

        @Override
        public final /* synthetic */ Object read(JsonReader jsonReader) {
            return 33.a(jsonReader);
        }

        @Override
        public final /* synthetic */ void write(JsonWriter jsonWriter, Object object) {
            if ((object = (Number)object) == null) {
                jsonWriter.nullValue();
                return;
            }
            jsonWriter.value(((Number)object).intValue());
        }
    };
    public static final TypeAdapterFactory INTEGER_FACTORY = TypeAdapters.newFactory(Integer.TYPE, Integer.class, INTEGER);
    public static final TypeAdapter<AtomicInteger> ATOMIC_INTEGER = new TypeAdapter<AtomicInteger>(){

        private static AtomicInteger a(JsonReader jsonReader) {
            try {
                return new AtomicInteger(jsonReader.nextInt());
            }
            catch (NumberFormatException numberFormatException) {
                throw new JsonSyntaxException(numberFormatException);
            }
        }

        @Override
        public final /* synthetic */ Object read(JsonReader jsonReader) {
            return 34.a(jsonReader);
        }

        @Override
        public final /* synthetic */ void write(JsonWriter jsonWriter, Object object) {
            object = (AtomicInteger)object;
            jsonWriter.value(((AtomicInteger)object).get());
        }
    }.nullSafe();
    public static final TypeAdapterFactory ATOMIC_INTEGER_FACTORY = TypeAdapters.newFactory(AtomicInteger.class, ATOMIC_INTEGER);
    public static final TypeAdapter<AtomicBoolean> ATOMIC_BOOLEAN = new TypeAdapter<AtomicBoolean>(){

        @Override
        public final /* synthetic */ Object read(JsonReader jsonReader) {
            return new AtomicBoolean(jsonReader.nextBoolean());
        }

        @Override
        public final /* synthetic */ void write(JsonWriter jsonWriter, Object object) {
            object = (AtomicBoolean)object;
            jsonWriter.value(((AtomicBoolean)object).get());
        }
    }.nullSafe();
    public static final TypeAdapterFactory ATOMIC_BOOLEAN_FACTORY = TypeAdapters.newFactory(AtomicBoolean.class, ATOMIC_BOOLEAN);
    public static final TypeAdapter<AtomicIntegerArray> ATOMIC_INTEGER_ARRAY = new TypeAdapter<AtomicIntegerArray>(){

        private static AtomicIntegerArray a(JsonReader object) {
            int n2;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            ((JsonReader)object).beginArray();
            while (((JsonReader)object).hasNext()) {
                try {
                    n2 = ((JsonReader)object).nextInt();
                    arrayList.add(n2);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new JsonSyntaxException(numberFormatException);
                }
            }
            ((JsonReader)object).endArray();
            n2 = arrayList.size();
            object = new AtomicIntegerArray(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                ((AtomicIntegerArray)object).set(i2, (Integer)arrayList.get(i2));
            }
            return object;
        }

        @Override
        public final /* synthetic */ Object read(JsonReader jsonReader) {
            return 2.a(jsonReader);
        }

        @Override
        public final /* synthetic */ void write(JsonWriter jsonWriter, Object object) {
            object = (AtomicIntegerArray)object;
            jsonWriter.beginArray();
            int n2 = ((AtomicIntegerArray)object).length();
            for (int i2 = 0; i2 < n2; ++i2) {
                jsonWriter.value(((AtomicIntegerArray)object).get(i2));
            }
            jsonWriter.endArray();
        }
    }.nullSafe();
    public static final TypeAdapterFactory ATOMIC_INTEGER_ARRAY_FACTORY = TypeAdapters.newFactory(AtomicIntegerArray.class, ATOMIC_INTEGER_ARRAY);
    public static final TypeAdapter<Number> LONG = new TypeAdapter<Number>(){

        private static Number a(JsonReader jsonReader) {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            try {
                return jsonReader.nextLong();
            }
            catch (NumberFormatException numberFormatException) {
                throw new JsonSyntaxException(numberFormatException);
            }
        }

        @Override
        public final /* synthetic */ Object read(JsonReader jsonReader) {
            return 3.a(jsonReader);
        }

        @Override
        public final /* synthetic */ void write(JsonWriter jsonWriter, Object object) {
            if ((object = (Number)object) == null) {
                jsonWriter.nullValue();
                return;
            }
            jsonWriter.value(((Number)object).longValue());
        }
    };
    public static final TypeAdapter<Number> FLOAT = new TypeAdapter<Number>(){

        @Override
        public final /* synthetic */ Object read(JsonReader jsonReader) {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            return Float.valueOf((float)jsonReader.nextDouble());
        }

        @Override
        public final /* synthetic */ void write(JsonWriter jsonWriter, Object object) {
            if ((object = (Number)object) == null) {
                jsonWriter.nullValue();
                return;
            }
            object = object instanceof Float ? object : Float.valueOf(((Number)object).floatValue());
            jsonWriter.value((Number)object);
        }
    };
    public static final TypeAdapter<Number> DOUBLE = new TypeAdapter<Number>(){

        @Override
        public final /* synthetic */ Object read(JsonReader jsonReader) {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            return jsonReader.nextDouble();
        }

        @Override
        public final /* synthetic */ void write(JsonWriter jsonWriter, Object object) {
            if ((object = (Number)object) == null) {
                jsonWriter.nullValue();
                return;
            }
            jsonWriter.value(((Number)object).doubleValue());
        }
    };
    public static final TypeAdapter<Character> CHARACTER = new TypeAdapter<Character>(){

        @Override
        public final /* synthetic */ Object read(JsonReader jsonReader) {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            String string = jsonReader.nextString();
            if (string.length() != 1) {
                throw new JsonSyntaxException("Expecting character, got: " + string + "; at " + jsonReader.getPreviousPath());
            }
            return Character.valueOf(string.charAt(0));
        }

        @Override
        public final /* synthetic */ void write(JsonWriter jsonWriter, Object object) {
            jsonWriter.value((object = (Character)object) == null ? null : String.valueOf(object));
        }
    };
    public static final TypeAdapterFactory CHARACTER_FACTORY = TypeAdapters.newFactory(Character.TYPE, Character.class, CHARACTER);
    public static final TypeAdapter<String> STRING = new TypeAdapter<String>(){

        @Override
        public final /* synthetic */ Object read(JsonReader jsonReader) {
            JsonToken jsonToken = jsonReader.peek();
            if (jsonToken == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            if (jsonToken == JsonToken.BOOLEAN) {
                return Boolean.toString(jsonReader.nextBoolean());
            }
            return jsonReader.nextString();
        }

        @Override
        public final /* synthetic */ void write(JsonWriter jsonWriter, Object object) {
            object = (String)object;
            jsonWriter.value((String)object);
        }
    };
    public static final TypeAdapter<BigDecimal> BIG_DECIMAL = new TypeAdapter<BigDecimal>(){

        private static BigDecimal a(JsonReader jsonReader) {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            String string = jsonReader.nextString();
            try {
                return new BigDecimal(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new JsonSyntaxException("Failed parsing '" + string + "' as BigDecimal; at path " + jsonReader.getPreviousPath(), numberFormatException);
            }
        }

        @Override
        public final /* synthetic */ Object read(JsonReader jsonReader) {
            return 8.a(jsonReader);
        }

        @Override
        public final /* synthetic */ void write(JsonWriter jsonWriter, Object object) {
            object = (BigDecimal)object;
            jsonWriter.value((Number)object);
        }
    };
    public static final TypeAdapter<BigInteger> BIG_INTEGER = new TypeAdapter<BigInteger>(){

        private static BigInteger a(JsonReader jsonReader) {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            String string = jsonReader.nextString();
            try {
                return new BigInteger(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new JsonSyntaxException("Failed parsing '" + string + "' as BigInteger; at path " + jsonReader.getPreviousPath(), numberFormatException);
            }
        }

        @Override
        public final /* synthetic */ Object read(JsonReader jsonReader) {
            return 9.a(jsonReader);
        }

        @Override
        public final /* synthetic */ void write(JsonWriter jsonWriter, Object object) {
            object = (BigInteger)object;
            jsonWriter.value((Number)object);
        }
    };
    public static final TypeAdapter<LazilyParsedNumber> LAZILY_PARSED_NUMBER = new TypeAdapter<LazilyParsedNumber>(){

        @Override
        public final /* synthetic */ Object read(JsonReader jsonReader) {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            return new LazilyParsedNumber(jsonReader.nextString());
        }

        @Override
        public final /* synthetic */ void write(JsonWriter jsonWriter, Object object) {
            object = (LazilyParsedNumber)object;
            jsonWriter.value((Number)object);
        }
    };
    public static final TypeAdapterFactory STRING_FACTORY = TypeAdapters.newFactory(String.class, STRING);
    public static final TypeAdapter<StringBuilder> STRING_BUILDER = new TypeAdapter<StringBuilder>(){

        @Override
        public final /* synthetic */ Object read(JsonReader jsonReader) {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            return new StringBuilder(jsonReader.nextString());
        }

        @Override
        public final /* synthetic */ void write(JsonWriter jsonWriter, Object object) {
            jsonWriter.value((object = (StringBuilder)object) == null ? null : ((StringBuilder)object).toString());
        }
    };
    public static final TypeAdapterFactory STRING_BUILDER_FACTORY = TypeAdapters.newFactory(StringBuilder.class, STRING_BUILDER);
    public static final TypeAdapter<StringBuffer> STRING_BUFFER = new TypeAdapter<StringBuffer>(){

        @Override
        public final /* synthetic */ Object read(JsonReader jsonReader) {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            return new StringBuffer(jsonReader.nextString());
        }

        @Override
        public final /* synthetic */ void write(JsonWriter jsonWriter, Object object) {
            jsonWriter.value((object = (StringBuffer)object) == null ? null : ((StringBuffer)object).toString());
        }
    };
    public static final TypeAdapterFactory STRING_BUFFER_FACTORY = TypeAdapters.newFactory(StringBuffer.class, STRING_BUFFER);
    public static final TypeAdapter<URL> URL = new TypeAdapter<URL>(){

        @Override
        public final /* synthetic */ Object read(JsonReader object) {
            if (((JsonReader)object).peek() == JsonToken.NULL) {
                ((JsonReader)object).nextNull();
                return null;
            }
            if ("null".equals(object = ((JsonReader)object).nextString())) {
                return null;
            }
            return new URL((String)object);
        }

        @Override
        public final /* synthetic */ void write(JsonWriter jsonWriter, Object object) {
            jsonWriter.value((object = (URL)object) == null ? null : ((URL)object).toExternalForm());
        }
    };
    public static final TypeAdapterFactory URL_FACTORY = TypeAdapters.newFactory(URL.class, URL);
    public static final TypeAdapter<URI> URI = new TypeAdapter<URI>(){

        private static URI a(JsonReader object) {
            if (((JsonReader)object).peek() == JsonToken.NULL) {
                ((JsonReader)object).nextNull();
                return null;
            }
            try {
                object = ((JsonReader)object).nextString();
                if ("null".equals(object)) {
                    return null;
                }
                return new URI((String)object);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new JsonIOException(uRISyntaxException);
            }
        }

        @Override
        public final /* synthetic */ Object read(JsonReader jsonReader) {
            return 15.a(jsonReader);
        }

        @Override
        public final /* synthetic */ void write(JsonWriter jsonWriter, Object object) {
            jsonWriter.value((object = (URI)object) == null ? null : ((URI)object).toASCIIString());
        }
    };
    public static final TypeAdapterFactory URI_FACTORY = TypeAdapters.newFactory(URI.class, URI);
    public static final TypeAdapter<InetAddress> INET_ADDRESS = new TypeAdapter<InetAddress>(){

        @Override
        public final /* synthetic */ Object read(JsonReader jsonReader) {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            return InetAddress.getByName(jsonReader.nextString());
        }

        @Override
        public final /* synthetic */ void write(JsonWriter jsonWriter, Object object) {
            jsonWriter.value((object = (InetAddress)object) == null ? null : ((InetAddress)object).getHostAddress());
        }
    };
    public static final TypeAdapterFactory INET_ADDRESS_FACTORY = TypeAdapters.newTypeHierarchyFactory(InetAddress.class, INET_ADDRESS);
    public static final TypeAdapter<UUID> UUID = new TypeAdapter<UUID>(){

        private static UUID a(JsonReader jsonReader) {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            String string = jsonReader.nextString();
            try {
                return java.util.UUID.fromString(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new JsonSyntaxException("Failed parsing '" + string + "' as UUID; at path " + jsonReader.getPreviousPath(), illegalArgumentException);
            }
        }

        @Override
        public final /* synthetic */ Object read(JsonReader jsonReader) {
            return 17.a(jsonReader);
        }

        @Override
        public final /* synthetic */ void write(JsonWriter jsonWriter, Object object) {
            jsonWriter.value((object = (UUID)object) == null ? null : ((UUID)object).toString());
        }
    };
    public static final TypeAdapterFactory UUID_FACTORY = TypeAdapters.newFactory(UUID.class, UUID);
    public static final TypeAdapter<Currency> CURRENCY = new TypeAdapter<Currency>(){

        private static Currency a(JsonReader jsonReader) {
            String string = jsonReader.nextString();
            try {
                return Currency.getInstance(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new JsonSyntaxException("Failed parsing '" + string + "' as Currency; at path " + jsonReader.getPreviousPath(), illegalArgumentException);
            }
        }

        @Override
        public final /* synthetic */ Object read(JsonReader jsonReader) {
            return 18.a(jsonReader);
        }

        @Override
        public final /* synthetic */ void write(JsonWriter jsonWriter, Object object) {
            object = (Currency)object;
            jsonWriter.value(((Currency)object).getCurrencyCode());
        }
    }.nullSafe();
    public static final TypeAdapterFactory CURRENCY_FACTORY = TypeAdapters.newFactory(Currency.class, CURRENCY);
    public static final TypeAdapter<Calendar> CALENDAR = new TypeAdapter<Calendar>(){

        @Override
        public final /* synthetic */ Object read(JsonReader jsonReader) {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            jsonReader.beginObject();
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            while (jsonReader.peek() != JsonToken.END_OBJECT) {
                String string = jsonReader.nextName();
                int n8 = jsonReader.nextInt();
                if ("year".equals(string)) {
                    n2 = n8;
                    continue;
                }
                if ("month".equals(string)) {
                    n3 = n8;
                    continue;
                }
                if ("dayOfMonth".equals(string)) {
                    n4 = n8;
                    continue;
                }
                if ("hourOfDay".equals(string)) {
                    n5 = n8;
                    continue;
                }
                if ("minute".equals(string)) {
                    n6 = n8;
                    continue;
                }
                if (!"second".equals(string)) continue;
                n7 = n8;
            }
            jsonReader.endObject();
            return new GregorianCalendar(n2, n3, n4, n5, n6, n7);
        }

        @Override
        public final /* synthetic */ void write(JsonWriter jsonWriter, Object object) {
            if ((object = (Calendar)object) == null) {
                jsonWriter.nullValue();
                return;
            }
            jsonWriter.beginObject();
            jsonWriter.name("year");
            jsonWriter.value(((Calendar)object).get(1));
            jsonWriter.name("month");
            jsonWriter.value(((Calendar)object).get(2));
            jsonWriter.name("dayOfMonth");
            jsonWriter.value(((Calendar)object).get(5));
            jsonWriter.name("hourOfDay");
            jsonWriter.value(((Calendar)object).get(11));
            jsonWriter.name("minute");
            jsonWriter.value(((Calendar)object).get(12));
            jsonWriter.name("second");
            jsonWriter.value(((Calendar)object).get(13));
            jsonWriter.endObject();
        }
    };
    public static final TypeAdapterFactory CALENDAR_FACTORY = TypeAdapters.newFactoryForMultipleTypes(Calendar.class, GregorianCalendar.class, CALENDAR);
    public static final TypeAdapter<Locale> LOCALE = new TypeAdapter<Locale>(){

        @Override
        public final /* synthetic */ Object read(JsonReader object) {
            if (((JsonReader)object).peek() == JsonToken.NULL) {
                ((JsonReader)object).nextNull();
                return null;
            }
            object = ((JsonReader)object).nextString();
            object = new StringTokenizer((String)object, "_");
            String string = null;
            String string2 = null;
            String string3 = null;
            if (((StringTokenizer)object).hasMoreElements()) {
                string = ((StringTokenizer)object).nextToken();
            }
            if (((StringTokenizer)object).hasMoreElements()) {
                string2 = ((StringTokenizer)object).nextToken();
            }
            if (((StringTokenizer)object).hasMoreElements()) {
                string3 = ((StringTokenizer)object).nextToken();
            }
            if (string2 == null && string3 == null) {
                return new Locale(string);
            }
            if (string3 == null) {
                return new Locale(string, string2);
            }
            return new Locale(string, string2, string3);
        }

        @Override
        public final /* synthetic */ void write(JsonWriter jsonWriter, Object object) {
            jsonWriter.value((object = (Locale)object) == null ? null : ((Locale)object).toString());
        }
    };
    public static final TypeAdapterFactory LOCALE_FACTORY = TypeAdapters.newFactory(Locale.class, LOCALE);
    public static final TypeAdapter<JsonElement> JSON_ELEMENT = new TypeAdapter<JsonElement>(){

        private static JsonElement a(JsonReader jsonReader, JsonToken jsonToken) {
            switch (jsonToken) {
                case BEGIN_ARRAY: {
                    jsonReader.beginArray();
                    return new JsonArray();
                }
                case BEGIN_OBJECT: {
                    jsonReader.beginObject();
                    return new JsonObject();
                }
            }
            return null;
        }

        private static JsonElement b(JsonReader object, JsonToken jsonToken) {
            switch (jsonToken) {
                case STRING: {
                    return new JsonPrimitive(((JsonReader)object).nextString());
                }
                case NUMBER: {
                    object = ((JsonReader)object).nextString();
                    return new JsonPrimitive(new LazilyParsedNumber((String)object));
                }
                case BOOLEAN: {
                    return new JsonPrimitive(((JsonReader)object).nextBoolean());
                }
                case NULL: {
                    ((JsonReader)object).nextNull();
                    return JsonNull.INSTANCE;
                }
            }
            throw new IllegalStateException("Unexpected token: " + (Object)((Object)jsonToken));
        }

        /*
         * Enabled aggressive block sorting
         */
        private void a(JsonWriter jsonWriter, JsonElement iterator) {
            if (iterator == null || ((JsonElement)((Object)iterator)).isJsonNull()) {
                jsonWriter.nullValue();
                return;
            }
            if (((JsonElement)((Object)iterator)).isJsonPrimitive()) {
                if (((JsonPrimitive)((Object)(iterator = ((JsonElement)((Object)iterator)).getAsJsonPrimitive()))).isNumber()) {
                    jsonWriter.value(((JsonElement)((Object)iterator)).getAsNumber());
                    return;
                }
                if (((JsonPrimitive)((Object)iterator)).isBoolean()) {
                    jsonWriter.value(((JsonElement)((Object)iterator)).getAsBoolean());
                    return;
                }
                jsonWriter.value(((JsonElement)((Object)iterator)).getAsString());
                return;
            }
            if (((JsonElement)((Object)iterator)).isJsonArray()) {
                jsonWriter.beginArray();
                iterator = ((JsonElement)((Object)iterator)).getAsJsonArray().iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        jsonWriter.endArray();
                        return;
                    }
                    JsonElement jsonElement = iterator.next();
                    this.a(jsonWriter, jsonElement);
                }
            }
            if (!((JsonElement)((Object)iterator)).isJsonObject()) throw new IllegalArgumentException("Couldn't write " + iterator.getClass());
            jsonWriter.beginObject();
            iterator = ((JsonElement)((Object)iterator)).getAsJsonObject().entrySet().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    jsonWriter.endObject();
                    return;
                }
                Map.Entry entry = (Map.Entry)iterator.next();
                jsonWriter.name((String)entry.getKey());
                this.a(jsonWriter, (JsonElement)entry.getValue());
            }
        }

        @Override
        public final /* synthetic */ Object read(JsonReader object) {
            JsonReader jsonReader = object;
            object = this;
            if (jsonReader instanceof JsonTreeReader) {
                return ((JsonTreeReader)jsonReader).a();
            }
            JsonToken jsonToken = jsonReader.peek();
            object = 21.a(jsonReader, jsonToken);
            if (object == null) {
                return 21.b(jsonReader, jsonToken);
            }
            ArrayDeque<Object> arrayDeque = new ArrayDeque<Object>();
            while (true) {
                if (jsonReader.hasNext()) {
                    JsonElement jsonElement;
                    boolean bl;
                    String string = null;
                    if (object instanceof JsonObject) {
                        string = jsonReader.nextName();
                    }
                    boolean bl2 = bl = (jsonElement = 21.a(jsonReader, jsonToken = jsonReader.peek())) != null;
                    if (jsonElement == null) {
                        jsonElement = 21.b(jsonReader, jsonToken);
                    }
                    if (object instanceof JsonArray) {
                        ((JsonArray)object).add(jsonElement);
                    } else {
                        ((JsonObject)object).add(string, jsonElement);
                    }
                    if (!bl) continue;
                    arrayDeque.addLast(object);
                    object = jsonElement;
                    continue;
                }
                if (object instanceof JsonArray) {
                    jsonReader.endArray();
                } else {
                    jsonReader.endObject();
                }
                if (arrayDeque.isEmpty()) {
                    return object;
                }
                object = (JsonElement)arrayDeque.removeLast();
            }
        }

        @Override
        public final /* synthetic */ void write(JsonWriter jsonWriter, Object object) {
            this.a(jsonWriter, (JsonElement)object);
        }
    };
    public static final TypeAdapterFactory JSON_ELEMENT_FACTORY = TypeAdapters.newTypeHierarchyFactory(JsonElement.class, JSON_ELEMENT);
    public static final TypeAdapterFactory ENUM_FACTORY = new TypeAdapterFactory(){

        @Override
        public final <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            Class<T> clazz = typeToken.getRawType();
            if (!Enum.class.isAssignableFrom(clazz) || clazz == Enum.class) {
                return null;
            }
            if (!clazz.isEnum()) {
                clazz = clazz.getSuperclass();
            }
            clazz = new a<T>(clazz);
            return clazz;
        }
    };

    private TypeAdapters() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    public static <TT> TypeAdapterFactory newFactory(TypeToken<TT> type, TypeAdapter<TT> typeAdapter) {
        void var1_1;
        TypeToken<TT> typeToken;
        return new TypeAdapterFactory(typeToken, (TypeAdapter)var1_1){
            private /* synthetic */ TypeToken a;
            private /* synthetic */ TypeAdapter b;
            {
                this.a = typeToken;
                this.b = typeAdapter;
            }

            @Override
            public final <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
                if (typeToken.equals(this.a)) {
                    return this.b;
                }
                return null;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static <TT> TypeAdapterFactory newFactory(Class<TT> type, TypeAdapter<TT> typeAdapter) {
        void var1_1;
        Class<TT> clazz;
        return new TypeAdapterFactory(clazz, (TypeAdapter)var1_1){
            private /* synthetic */ Class a;
            private /* synthetic */ TypeAdapter b;
            {
                this.a = clazz;
                this.b = typeAdapter;
            }

            @Override
            public final <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
                if (typeToken.getRawType() == this.a) {
                    return this.b;
                }
                return null;
            }

            public final String toString() {
                return "Factory[type=" + this.a.getName() + ",adapter=" + this.b + "]";
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static <TT> TypeAdapterFactory newFactory(Class<TT> unboxed, Class<TT> boxed, TypeAdapter<? super TT> typeAdapter) {
        void var2_2;
        void var1_1;
        Class<TT> clazz;
        return new TypeAdapterFactory(clazz, (Class)var1_1, (TypeAdapter)var2_2){
            private /* synthetic */ Class a;
            private /* synthetic */ Class b;
            private /* synthetic */ TypeAdapter c;
            {
                this.a = clazz;
                this.b = clazz2;
                this.c = typeAdapter;
            }

            @Override
            public final <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
                Class<T> clazz = typeToken.getRawType();
                if (clazz == this.a || clazz == this.b) {
                    return this.c;
                }
                return null;
            }

            public final String toString() {
                return "Factory[type=" + this.b.getName() + "+" + this.a.getName() + ",adapter=" + this.c + "]";
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static <TT> TypeAdapterFactory newFactoryForMultipleTypes(Class<TT> base, Class<? extends TT> sub, TypeAdapter<? super TT> typeAdapter) {
        void var2_2;
        void var1_1;
        Class<TT> clazz;
        return new TypeAdapterFactory(clazz, (Class)var1_1, (TypeAdapter)var2_2){
            private /* synthetic */ Class a;
            private /* synthetic */ Class b;
            private /* synthetic */ TypeAdapter c;
            {
                this.a = clazz;
                this.b = clazz2;
                this.c = typeAdapter;
            }

            @Override
            public final <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
                Class<T> clazz = typeToken.getRawType();
                if (clazz == this.a || clazz == this.b) {
                    return this.c;
                }
                return null;
            }

            public final String toString() {
                return "Factory[type=" + this.a.getName() + "+" + this.b.getName() + ",adapter=" + this.c + "]";
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static <T1> TypeAdapterFactory newTypeHierarchyFactory(Class<T1> clazz, TypeAdapter<T1> typeAdapter) {
        void var1_1;
        Class<T1> clazz2;
        return new TypeAdapterFactory(clazz2, (TypeAdapter)var1_1){
            private /* synthetic */ Class b;
            final /* synthetic */ TypeAdapter a;
            {
                this.b = clazz;
                this.a = typeAdapter;
            }

            public final <T2> TypeAdapter<T2> create(Gson gson, TypeToken<T2> typeToken) {
                Class<T2> clazz = typeToken.getRawType();
                if (!this.b.isAssignableFrom(clazz)) {
                    return null;
                }
                return new TypeAdapter<T1>(this, clazz){
                    private /* synthetic */ Class a;
                    private /* synthetic */ 28 b;
                    {
                        this.b = var1_1;
                        this.a = clazz;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public final void write(JsonWriter out, T1 value) {
                        void var2_2;
                        void var1_1;
                        this.b.a.write((JsonWriter)var1_1, var2_2);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public final T1 read(JsonReader in) {
                        Object t2 = this.b.a.read(in);
                        if (t2 != null && !this.a.isInstance(t2)) {
                            void var1_1;
                            throw new JsonSyntaxException("Expected a " + this.a.getName() + " but was " + t2.getClass().getName() + "; at path " + var1_1.getPreviousPath());
                        }
                        return t2;
                    }
                };
            }

            public final String toString() {
                return "Factory[typeHierarchy=" + this.b.getName() + ",adapter=" + this.a + "]";
            }
        };
    }

    private static final class a<T extends Enum<T>>
    extends TypeAdapter<T> {
        private final Map<String, T> a = new HashMap<String, T>();
        private final Map<String, T> b = new HashMap<String, T>();
        private final Map<T, String> c = new HashMap<T, String>();

        public a(Class<T> fieldArray) {
            try {
                Field[] fieldArray2 = AccessController.doPrivileged(new PrivilegedAction<Field[]>(this, fieldArray){
                    private /* synthetic */ Class a;
                    private /* synthetic */ a b;
                    {
                        this.b = a2;
                        this.a = clazz;
                    }

                    @Override
                    public final /* synthetic */ Object run() {
                        Field[] fieldArray = this;
                        fieldArray = this.a.getDeclaredFields();
                        ArrayList<Field> arrayList = new ArrayList<Field>(fieldArray.length);
                        for (Field field : fieldArray) {
                            if (!field.isEnumConstant()) continue;
                            arrayList.add(field);
                        }
                        fieldArray = arrayList.toArray(new Field[0]);
                        AccessibleObject.setAccessible(fieldArray, true);
                        return fieldArray;
                    }
                });
                fieldArray = fieldArray2;
                fieldArray = fieldArray2;
                int n2 = fieldArray2.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    String[] stringArray = fieldArray[i2];
                    Enum enum_ = (Enum)stringArray.get(null);
                    String string = enum_.name();
                    String string2 = enum_.toString();
                    if ((stringArray = stringArray.getAnnotation(SerializedName.class)) != null) {
                        string = stringArray.value();
                        for (String string3 : stringArray.alternate()) {
                            this.a.put(string3, enum_);
                        }
                    }
                    this.a.put(string, enum_);
                    this.b.put(string2, enum_);
                    this.c.put(enum_, string);
                }
                return;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException);
            }
        }

        @Override
        public final /* synthetic */ Object read(JsonReader object) {
            Object object2 = object;
            object = this;
            if (((JsonReader)object2).peek() == JsonToken.NULL) {
                ((JsonReader)object2).nextNull();
                return null;
            }
            Enum enum_ = (Enum)((a)object).a.get(object2 = ((JsonReader)object2).nextString());
            if (enum_ == null) {
                return (Enum)((a)object).b.get(object2);
            }
            return enum_;
        }

        @Override
        public final /* synthetic */ void write(JsonWriter object, Object object2) {
            Enum enum_ = (Enum)object2;
            object2 = object;
            object = this;
            ((JsonWriter)object2).value(enum_ == null ? null : ((a)object).c.get(enum_));
        }
    }
}

