/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.stream;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;

public class JsonWriter
implements Closeable,
Flushable {
    private static final Pattern a = Pattern.compile("-?(?:0|[1-9][0-9]*)(?:\\.[0-9]+)?(?:[eE][-+]?[0-9]+)?");
    private static final String[] b = new String[128];
    private static final String[] c;
    private final Writer d;
    private int[] e = new int[32];
    private int f = 0;
    private String g;
    private String h;
    private boolean i;
    private boolean j;
    private String k;
    private boolean l;

    /*
     * WARNING - void declaration
     */
    public JsonWriter(Writer out) {
        void var1_1;
        this.a(6);
        this.h = ":";
        this.l = true;
        this.d = (Writer)Objects.requireNonNull(var1_1, "out == null");
    }

    /*
     * WARNING - void declaration
     */
    public final void setIndent(String indent) {
        void var1_1;
        if (indent.length() == 0) {
            this.g = null;
            this.h = ":";
            return;
        }
        this.g = var1_1;
        this.h = ": ";
    }

    /*
     * WARNING - void declaration
     */
    public final void setLenient(boolean lenient) {
        void var1_1;
        this.i = var1_1;
    }

    public boolean isLenient() {
        return this.i;
    }

    /*
     * WARNING - void declaration
     */
    public final void setHtmlSafe(boolean htmlSafe) {
        void var1_1;
        this.j = var1_1;
    }

    public final boolean isHtmlSafe() {
        return this.j;
    }

    /*
     * WARNING - void declaration
     */
    public final void setSerializeNulls(boolean serializeNulls) {
        void var1_1;
        this.l = var1_1;
    }

    public final boolean getSerializeNulls() {
        return this.l;
    }

    public JsonWriter beginArray() {
        this.b();
        return this.a(1, '[');
    }

    public JsonWriter endArray() {
        return this.a(1, 2, ']');
    }

    public JsonWriter beginObject() {
        this.b();
        return this.a(3, '{');
    }

    public JsonWriter endObject() {
        return this.a(3, 5, '}');
    }

    private JsonWriter a(int n2, char c2) {
        this.e();
        this.a(n2);
        this.d.write(c2);
        return this;
    }

    private JsonWriter a(int n2, int n3, char c2) {
        int n4 = this.a();
        if (n4 != n3 && n4 != n2) {
            throw new IllegalStateException("Nesting problem.");
        }
        if (this.k != null) {
            throw new IllegalStateException("Dangling name: " + this.k);
        }
        --this.f;
        if (n4 == n3) {
            this.c();
        }
        this.d.write(c2);
        return this;
    }

    private void a(int n2) {
        if (this.f == this.e.length) {
            this.e = Arrays.copyOf(this.e, this.f << 1);
        }
        this.e[this.f++] = n2;
    }

    private int a() {
        if (this.f == 0) {
            throw new IllegalStateException("JsonWriter is closed.");
        }
        return this.e[this.f - 1];
    }

    private void b(int n2) {
        this.e[this.f - 1] = n2;
    }

    /*
     * WARNING - void declaration
     */
    public JsonWriter name(String name) {
        void var1_1;
        Objects.requireNonNull(name, "name == null");
        if (this.k != null) {
            throw new IllegalStateException();
        }
        if (this.f == 0) {
            throw new IllegalStateException("JsonWriter is closed.");
        }
        this.k = var1_1;
        return this;
    }

    private void b() {
        if (this.k != null) {
            this.d();
            JsonWriter jsonWriter = this;
            jsonWriter.a(jsonWriter.k);
            this.k = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public JsonWriter value(String value) {
        void var1_1;
        if (value == null) {
            return this.nullValue();
        }
        this.b();
        this.e();
        this.a((String)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public JsonWriter jsonValue(String value) {
        void var1_1;
        if (value == null) {
            return this.nullValue();
        }
        this.b();
        this.e();
        this.d.append((CharSequence)var1_1);
        return this;
    }

    public JsonWriter nullValue() {
        if (this.k != null) {
            if (this.l) {
                this.b();
            } else {
                this.k = null;
                return this;
            }
        }
        this.e();
        this.d.write("null");
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public JsonWriter value(boolean value) {
        void var1_1;
        this.b();
        this.e();
        this.d.write(var1_1 != false ? "true" : "false");
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public JsonWriter value(Boolean value) {
        void var1_1;
        if (value == null) {
            return this.nullValue();
        }
        this.b();
        this.e();
        this.d.write(var1_1.booleanValue() ? "true" : "false");
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public JsonWriter value(float value) {
        void var1_1;
        this.b();
        if (!this.i && (Float.isNaN(value) || Float.isInfinite(value))) {
            throw new IllegalArgumentException("Numeric values must be finite, but was " + value);
        }
        this.e();
        this.d.append(Float.toString((float)var1_1));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public JsonWriter value(double value) {
        void var1_1;
        this.b();
        if (!this.i && (Double.isNaN(value) || Double.isInfinite(value))) {
            throw new IllegalArgumentException("Numeric values must be finite, but was " + value);
        }
        this.e();
        this.d.append(Double.toString((double)var1_1));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public JsonWriter value(long value) {
        void var1_1;
        this.b();
        this.e();
        this.d.write(Long.toString((long)var1_1));
        return this;
    }

    public JsonWriter value(Number value) {
        if (value == null) {
            return this.nullValue();
        }
        this.b();
        String string = value.toString();
        if (string.equals("-Infinity") || string.equals("Infinity") || string.equals("NaN")) {
            if (!this.i) {
                throw new IllegalArgumentException("Numeric values must be finite, but was " + string);
            }
        } else {
            Class<?> clazz;
            Class<?> clazz2 = clazz = clazz.getClass();
            if (!(clazz == Integer.class || clazz2 == Long.class || clazz2 == Double.class || clazz2 == Float.class || clazz2 == Byte.class || clazz2 == Short.class || clazz2 == BigDecimal.class || clazz2 == BigInteger.class || clazz2 == AtomicInteger.class || clazz2 == AtomicLong.class) && !a.matcher(string).matches()) {
                throw new IllegalArgumentException("String created by " + clazz + " is not a valid JSON number: " + string);
            }
        }
        this.e();
        this.d.append(string);
        return this;
    }

    @Override
    public void flush() {
        if (this.f == 0) {
            throw new IllegalStateException("JsonWriter is closed.");
        }
        this.d.flush();
    }

    @Override
    public void close() {
        this.d.close();
        int n2 = this.f;
        if (n2 > 1 || n2 == 1 && this.e[n2 - 1] != 7) {
            throw new IOException("Incomplete document");
        }
        this.f = 0;
    }

    private void a(String string) {
        String[] stringArray = this.j ? c : b;
        this.d.write(34);
        int n2 = 0;
        int n3 = string.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            String string2;
            char c2 = string.charAt(i2);
            if (c2 < '\u0080') {
                string2 = stringArray[c2];
                if (string2 == null) {
                    continue;
                }
            } else if (c2 == '\u2028') {
                string2 = "\\u2028";
            } else {
                if (c2 != '\u2029') continue;
                string2 = "\\u2029";
            }
            if (n2 < i2) {
                this.d.write(string, n2, i2 - n2);
            }
            this.d.write(string2);
            n2 = i2 + 1;
        }
        if (n2 < n3) {
            this.d.write(string, n2, n3 - n2);
        }
        this.d.write(34);
    }

    private void c() {
        if (this.g == null) {
            return;
        }
        this.d.write(10);
        int n2 = this.f;
        for (int i2 = 1; i2 < n2; ++i2) {
            this.d.write(this.g);
        }
    }

    private void d() {
        int n2 = this.a();
        if (n2 == 5) {
            this.d.write(44);
        } else if (n2 != 3) {
            throw new IllegalStateException("Nesting problem.");
        }
        this.c();
        this.b(4);
    }

    private void e() {
        switch (this.a()) {
            case 7: {
                if (!this.i) {
                    throw new IllegalStateException("JSON must have only one top-level value.");
                }
            }
            case 6: {
                this.b(7);
                return;
            }
            case 1: {
                this.b(2);
                this.c();
                return;
            }
            case 2: {
                this.d.append(',');
                this.c();
                return;
            }
            case 4: {
                this.d.append(this.h);
                this.b(5);
                return;
            }
        }
        throw new IllegalStateException("Nesting problem.");
    }

    static {
        for (int i2 = 0; i2 <= 31; ++i2) {
            JsonWriter.b[i2] = String.format("\\u%04x", i2);
        }
        JsonWriter.b[34] = "\\\"";
        JsonWriter.b[92] = "\\\\";
        JsonWriter.b[9] = "\\t";
        JsonWriter.b[8] = "\\b";
        JsonWriter.b[10] = "\\n";
        JsonWriter.b[13] = "\\r";
        JsonWriter.b[12] = "\\f";
        String[] stringArray = (String[])b.clone();
        c = stringArray;
        stringArray[60] = "\\u003c";
        JsonWriter.c[62] = "\\u003e";
        JsonWriter.c[38] = "\\u0026";
        JsonWriter.c[61] = "\\u003d";
        JsonWriter.c[39] = "\\u0027";
    }
}

