/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.audience;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collector;
import net.kyori.adventure.audience.Audiences;
import net.kyori.adventure.audience.ForwardingAudience;
import net.kyori.adventure.audience.MessageType;
import net.kyori.adventure.audience.a;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.chat.ChatType;
import net.kyori.adventure.chat.SignedMessage;
import net.kyori.adventure.identity.Identified;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.inventory.Book;
import net.kyori.adventure.pointer.Pointered;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.sound.SoundStop;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.title.Title;
import net.kyori.adventure.title.TitlePart;
import org.jetbrains.annotations.ApiStatus;

public interface Audience
extends Pointered {
    public static Audience empty() {
        return a.a;
    }

    public static Audience audience(Audience ... audiences) {
        Audience[] audienceArray;
        int n2 = audiences.length;
        if (n2 == 0) {
            return Audience.empty();
        }
        if (n2 == 1) {
            return audiences[0];
        }
        return Audience.audience(Arrays.asList(audienceArray));
    }

    public static ForwardingAudience audience(Iterable<? extends Audience> audiences) {
        return () -> audiences;
    }

    public static Collector<? super Audience, ?, ForwardingAudience> toAudience() {
        return Audiences.a;
    }

    default public Audience filterAudience(Predicate<? super Audience> filter) {
        if (filter.test(this)) {
            return this;
        }
        return Audience.empty();
    }

    default public void forEachAudience(Consumer<? super Audience> action) {
        action.accept(this);
    }

    /*
     * WARNING - void declaration
     */
    default public void sendMessage(ComponentLike message) {
        void var1_1;
        this.sendMessage(var1_1.asComponent());
    }

    /*
     * WARNING - void declaration
     */
    default public void sendMessage(Component message) {
        void var1_1;
        this.sendMessage((Component)var1_1, MessageType.SYSTEM);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
    default public void sendMessage(ComponentLike message, MessageType type) {
        void var2_2;
        void var1_1;
        this.sendMessage(var1_1.asComponent(), (MessageType)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
    default public void sendMessage(Component message, MessageType type) {
        void var2_2;
        void var1_1;
        this.sendMessage(Identity.nil(), (Component)var1_1, (MessageType)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    default public void sendMessage(Identified source, ComponentLike message) {
        void var2_2;
        void var1_1;
        this.sendMessage((Identified)var1_1, var2_2.asComponent());
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    default public void sendMessage(Identity source, ComponentLike message) {
        void var2_2;
        void var1_1;
        this.sendMessage((Identity)var1_1, var2_2.asComponent());
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    default public void sendMessage(Identified source, Component message) {
        void var2_2;
        void var1_1;
        this.sendMessage((Identified)var1_1, (Component)var2_2, MessageType.CHAT);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    default public void sendMessage(Identity source, Component message) {
        void var2_2;
        void var1_1;
        this.sendMessage((Identity)var1_1, (Component)var2_2, MessageType.CHAT);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
    default public void sendMessage(Identified source, ComponentLike message, MessageType type) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.sendMessage((Identified)var1_1, var2_2.asComponent(), (MessageType)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
    default public void sendMessage(Identity source, ComponentLike message, MessageType type) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.sendMessage((Identity)var1_1, var2_2.asComponent(), (MessageType)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
    default public void sendMessage(Identified source, Component message, MessageType type) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.sendMessage(var1_1.identity(), (Component)var2_2, (MessageType)var3_3);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
    default public void sendMessage(Identity source, Component message, MessageType type) {
    }

    /*
     * WARNING - void declaration
     */
    default public void sendMessage(Component message, ChatType.Bound boundChatType) {
        void var1_1;
        this.sendMessage((Component)var1_1, MessageType.CHAT);
    }

    /*
     * WARNING - void declaration
     */
    default public void sendMessage(ComponentLike message, ChatType.Bound boundChatType) {
        void var2_2;
        void var1_1;
        this.sendMessage(var1_1.asComponent(), (ChatType.Bound)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    default public void sendMessage(SignedMessage signedMessage, ChatType.Bound boundChatType) {
        void var1_1;
        Component component;
        Component component2 = component = signedMessage.unsignedContent() != null ? signedMessage.unsignedContent() : Component.text(signedMessage.message());
        if (signedMessage.isSystem()) {
            this.sendMessage(component);
            return;
        }
        this.sendMessage(var1_1.identity(), component, MessageType.CHAT);
    }

    /*
     * WARNING - void declaration
     */
    default public void deleteMessage(SignedMessage signedMessage) {
        if (signedMessage.canDelete()) {
            void var1_1;
            this.deleteMessage(Objects.requireNonNull(var1_1.signature()));
        }
    }

    default public void deleteMessage(SignedMessage.Signature signature) {
    }

    /*
     * WARNING - void declaration
     */
    default public void sendActionBar(ComponentLike message) {
        void var1_1;
        this.sendActionBar(var1_1.asComponent());
    }

    default public void sendActionBar(Component message) {
    }

    /*
     * WARNING - void declaration
     */
    default public void sendPlayerListHeader(ComponentLike header) {
        void var1_1;
        this.sendPlayerListHeader(var1_1.asComponent());
    }

    /*
     * WARNING - void declaration
     */
    default public void sendPlayerListHeader(Component header) {
        void var1_1;
        this.sendPlayerListHeaderAndFooter((Component)var1_1, Component.empty());
    }

    /*
     * WARNING - void declaration
     */
    default public void sendPlayerListFooter(ComponentLike footer) {
        void var1_1;
        this.sendPlayerListFooter(var1_1.asComponent());
    }

    /*
     * WARNING - void declaration
     */
    default public void sendPlayerListFooter(Component footer) {
        void var1_1;
        this.sendPlayerListHeaderAndFooter(Component.empty(), (Component)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    default public void sendPlayerListHeaderAndFooter(ComponentLike header, ComponentLike footer) {
        void var2_2;
        void var1_1;
        this.sendPlayerListHeaderAndFooter(var1_1.asComponent(), var2_2.asComponent());
    }

    default public void sendPlayerListHeaderAndFooter(Component header, Component footer) {
    }

    /*
     * WARNING - void declaration
     */
    default public void showTitle(Title title) {
        void var1_1;
        Title.Times times = title.times();
        if (times != null) {
            this.sendTitlePart(TitlePart.TIMES, times);
        }
        this.sendTitlePart(TitlePart.SUBTITLE, title.subtitle());
        this.sendTitlePart(TitlePart.TITLE, var1_1.title());
    }

    default public <T> void sendTitlePart(TitlePart<T> part, T value) {
    }

    default public void clearTitle() {
    }

    default public void resetTitle() {
    }

    default public void showBossBar(BossBar bar) {
    }

    default public void hideBossBar(BossBar bar) {
    }

    default public void playSound(Sound sound) {
    }

    default public void playSound(Sound sound, double x2, double y2, double z2) {
    }

    default public void playSound(Sound sound, Sound.Emitter emitter) {
    }

    /*
     * WARNING - void declaration
     */
    default public void stopSound(Sound sound) {
        void var1_1;
        this.stopSound(((Sound)Objects.requireNonNull(var1_1, "sound")).asStop());
    }

    default public void stopSound(SoundStop stop) {
    }

    /*
     * WARNING - void declaration
     */
    default public void openBook(Book.Builder book) {
        void var1_1;
        this.openBook(var1_1.build());
    }

    default public void openBook(Book book) {
    }
}

