/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text;

import java.util.regex.Matcher;
import java.util.stream.Stream;
import net.kyori.a.b;
import net.kyori.a.c;
import net.kyori.adventure.text.NBTComponent;
import net.kyori.adventure.text.NBTComponentBuilder;
import net.kyori.adventure.text.ScopedComponent;
import net.kyori.adventure.text.c;
import org.jetbrains.annotations.ApiStatus;

public interface BlockNBTComponent
extends NBTComponent<BlockNBTComponent, Builder>,
ScopedComponent<BlockNBTComponent> {
    public Pos pos();

    public BlockNBTComponent pos(Pos var1);

    /*
     * WARNING - void declaration
     */
    default public BlockNBTComponent localPos(double left, double up, double forwards) {
        void var3_2;
        void var1_1;
        return this.pos(LocalPos.localPos((double)var1_1, (double)var3_2, forwards));
    }

    /*
     * WARNING - void declaration
     */
    default public BlockNBTComponent worldPos(WorldPos.Coordinate x2, WorldPos.Coordinate y2, WorldPos.Coordinate z2) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.pos(WorldPos.worldPos((WorldPos.Coordinate)var1_1, (WorldPos.Coordinate)var2_2, (WorldPos.Coordinate)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    default public BlockNBTComponent absoluteWorldPos(int x2, int y2, int z2) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.worldPos(WorldPos.Coordinate.absolute((int)var1_1), WorldPos.Coordinate.absolute((int)var2_2), WorldPos.Coordinate.absolute((int)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    default public BlockNBTComponent relativeWorldPos(int x2, int y2, int z2) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.worldPos(WorldPos.Coordinate.relative((int)var1_1), WorldPos.Coordinate.relative((int)var2_2), WorldPos.Coordinate.relative((int)var3_3));
    }

    @Override
    default public Stream<? extends c> examinableProperties() {
        return Stream.concat(Stream.of(c.a("pos", this.pos())), NBTComponent.super.examinableProperties());
    }

    public static interface WorldPos
    extends Pos {
        /*
         * WARNING - void declaration
         */
        public static WorldPos worldPos(Coordinate x2, Coordinate y2, Coordinate z2) {
            void var2_2;
            void var1_1;
            Coordinate coordinate;
            return new c.d(coordinate, (Coordinate)var1_1, (Coordinate)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
        public static WorldPos of(Coordinate x2, Coordinate y2, Coordinate z2) {
            void var2_2;
            void var1_1;
            Coordinate coordinate;
            return new c.d(coordinate, (Coordinate)var1_1, (Coordinate)var2_2);
        }

        public Coordinate x();

        public Coordinate y();

        public Coordinate z();

        public static interface Coordinate
        extends b {
            public static Coordinate absolute(int value) {
                return Coordinate.coordinate(value, Type.ABSOLUTE);
            }

            public static Coordinate relative(int value) {
                return Coordinate.coordinate(value, Type.RELATIVE);
            }

            /*
             * WARNING - void declaration
             */
            public static Coordinate coordinate(int value, Type type) {
                void var1_1;
                int n2;
                return new c.d.a(n2, (Type)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Deprecated
            @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
            public static Coordinate of(int value, Type type) {
                void var1_1;
                int n2;
                return new c.d.a(n2, (Type)var1_1);
            }

            public int value();

            public Type type();

            public static enum Type {
                ABSOLUTE,
                RELATIVE;

            }
        }
    }

    public static interface LocalPos
    extends Pos {
        /*
         * WARNING - void declaration
         */
        public static LocalPos localPos(double left, double up, double forwards) {
            void var2_2;
            double d2;
            return new c.b(d2, (double)var2_2, forwards);
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
        public static LocalPos of(double left, double up, double forwards) {
            void var2_2;
            double d2;
            return new c.b(d2, (double)var2_2, forwards);
        }

        public double left();

        public double up();

        public double forwards();
    }

    public static interface Pos
    extends b {
        public static Pos fromString(String input) {
            String string;
            Matcher matcher = c.c.a.matcher(input);
            if (matcher.matches()) {
                return LocalPos.localPos(Double.parseDouble(matcher.group(1)), Double.parseDouble(matcher.group(3)), Double.parseDouble(matcher.group(5)));
            }
            matcher = c.c.b.matcher(input);
            if (matcher.matches()) {
                return WorldPos.worldPos(c.c.a(matcher.group(1), matcher.group(2)), c.c.a(matcher.group(3), matcher.group(4)), c.c.a(matcher.group(5), matcher.group(6)));
            }
            throw new IllegalArgumentException("Cannot convert position specification '" + string + "' into a position");
        }

        public String asString();
    }

    public static interface Builder
    extends NBTComponentBuilder<BlockNBTComponent, Builder> {
        public Builder pos(Pos var1);

        /*
         * WARNING - void declaration
         */
        default public Builder localPos(double left, double up, double forwards) {
            void var3_2;
            void var1_1;
            return this.pos(LocalPos.localPos((double)var1_1, (double)var3_2, forwards));
        }

        /*
         * WARNING - void declaration
         */
        default public Builder worldPos(WorldPos.Coordinate x2, WorldPos.Coordinate y2, WorldPos.Coordinate z2) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.pos(WorldPos.worldPos((WorldPos.Coordinate)var1_1, (WorldPos.Coordinate)var2_2, (WorldPos.Coordinate)var3_3));
        }

        /*
         * WARNING - void declaration
         */
        default public Builder absoluteWorldPos(int x2, int y2, int z2) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.worldPos(WorldPos.Coordinate.absolute((int)var1_1), WorldPos.Coordinate.absolute((int)var2_2), WorldPos.Coordinate.absolute((int)var3_3));
        }

        /*
         * WARNING - void declaration
         */
        default public Builder relativeWorldPos(int x2, int y2, int z2) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.worldPos(WorldPos.Coordinate.relative((int)var1_1), WorldPos.Coordinate.relative((int)var2_2), WorldPos.Coordinate.relative((int)var3_3));
        }
    }
}

