/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.kyori.adventure.text.Component;

@FunctionalInterface
public interface ComponentLike {
    public static List<Component> asComponents(List<? extends ComponentLike> likes) {
        return ComponentLike.asComponents(likes, null);
    }

    public static List<Component> asComponents(List<? extends ComponentLike> likes, Predicate<? super Component> filter) {
        Objects.requireNonNull(likes, "likes");
        int n2 = likes.size();
        if (n2 == 0) {
            return Collections.emptyList();
        }
        ArrayList<ComponentLike> arrayList = null;
        for (int i2 = 0; i2 < n2; ++i2) {
            ComponentLike componentLike = likes.get(i2);
            if (componentLike == null) {
                throw new NullPointerException("likes[" + i2 + "]");
            }
            componentLike = componentLike.asComponent();
            if (filter != null && !filter.test((Component)componentLike)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<ComponentLike>(n2);
            }
            arrayList.add(componentLike);
        }
        if (arrayList == null) {
            return Collections.emptyList();
        }
        arrayList.trimToSize();
        return Collections.unmodifiableList(arrayList);
    }

    public static Component unbox(ComponentLike like) {
        if (like != null) {
            ComponentLike componentLike;
            return componentLike.asComponent();
        }
        return null;
    }

    public Component asComponent();
}

