/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.event;

import java.net.URL;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.kyori.a.b;
import net.kyori.a.c;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.builder.AbstractBuilder;
import net.kyori.adventure.internal.Internals;
import net.kyori.adventure.text.event.ClickCallback;
import net.kyori.adventure.text.event.a;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.StyleBuilderApplicable;
import net.kyori.adventure.util.Index;

public final class ClickEvent
implements b,
StyleBuilderApplicable {
    private final Action a;
    private final String b;

    public static ClickEvent openUrl(String url) {
        String string;
        return new ClickEvent(Action.OPEN_URL, string);
    }

    public static ClickEvent openUrl(URL url) {
        return ClickEvent.openUrl(url.toExternalForm());
    }

    public static ClickEvent openFile(String file) {
        String string;
        return new ClickEvent(Action.OPEN_FILE, string);
    }

    public static ClickEvent runCommand(String command) {
        String string;
        return new ClickEvent(Action.RUN_COMMAND, string);
    }

    public static ClickEvent suggestCommand(String command) {
        String string;
        return new ClickEvent(Action.SUGGEST_COMMAND, string);
    }

    public static ClickEvent changePage(String page) {
        String string;
        return new ClickEvent(Action.CHANGE_PAGE, string);
    }

    public static ClickEvent changePage(int page) {
        return ClickEvent.changePage(String.valueOf(page));
    }

    public static ClickEvent copyToClipboard(String text) {
        String string;
        return new ClickEvent(Action.COPY_TO_CLIPBOARD, string);
    }

    public static ClickEvent callback(ClickCallback<Audience> function) {
        ClickCallback<Audience> clickCallback;
        return net.kyori.adventure.text.event.a.b.create(Objects.requireNonNull(clickCallback, "function"), net.kyori.adventure.text.event.b.a);
    }

    /*
     * WARNING - void declaration
     */
    public static ClickEvent callback(ClickCallback<Audience> function, ClickCallback.Options options) {
        void var1_1;
        ClickCallback<Audience> clickCallback;
        return net.kyori.adventure.text.event.a.b.create(Objects.requireNonNull(clickCallback, "function"), (ClickCallback.Options)Objects.requireNonNull(var1_1, "options"));
    }

    /*
     * WARNING - void declaration
     */
    public static ClickEvent callback(ClickCallback<Audience> function, Consumer<ClickCallback.Options.Builder> optionsBuilder) {
        void var1_1;
        ClickCallback<Audience> clickCallback;
        return net.kyori.adventure.text.event.a.b.create(Objects.requireNonNull(clickCallback, "function"), (ClickCallback.Options)AbstractBuilder.configureAndBuild(ClickCallback.Options.builder(), (Consumer)Objects.requireNonNull(var1_1, "optionsBuilder")));
    }

    /*
     * WARNING - void declaration
     */
    public static ClickEvent clickEvent(Action action, String value) {
        void var1_1;
        Action action2;
        return new ClickEvent(action2, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private ClickEvent(Action action, String value) {
        void var2_2;
        void var1_1;
        this.a = (Action)Objects.requireNonNull(var1_1, "action");
        this.b = (String)Objects.requireNonNull(var2_2, "value");
    }

    public final Action action() {
        return this.a;
    }

    public final String value() {
        return this.b;
    }

    @Override
    public final void styleApply(Style.Builder style) {
        style.clickEvent(this);
    }

    public final boolean equals(Object other) {
        ClickEvent clickEvent;
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        clickEvent = clickEvent;
        return this.a == clickEvent.a && Objects.equals(this.b, clickEvent.b);
    }

    public final int hashCode() {
        int n2 = this.a.hashCode();
        n2 = n2 * 31 + this.b.hashCode();
        return n2;
    }

    @Override
    public final Stream<? extends c> examinableProperties() {
        return Stream.of(c.a("action", (Object)this.a), c.a("value", this.b));
    }

    public final String toString() {
        return Internals.toString(this);
    }

    public static enum Action {
        OPEN_URL("open_url", true),
        OPEN_FILE("open_file", false),
        RUN_COMMAND("run_command", true),
        SUGGEST_COMMAND("suggest_command", true),
        CHANGE_PAGE("change_page", true),
        COPY_TO_CLIPBOARD("copy_to_clipboard", true);

        public static final Index<String, Action> NAMES;
        private final String a;
        private final boolean b;

        /*
         * WARNING - void declaration
         */
        private Action(String name, boolean readable) {
            void var3_3;
            this.a = var3_3;
            this.b = readable;
        }

        public final boolean readable() {
            return this.b;
        }

        public final String toString() {
            return this.a;
        }

        static {
            NAMES = Index.create(Action.class, action -> action.a);
        }
    }
}

