/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.format;

import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.kyori.a.b;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.StyleBuilderApplicable;
import net.kyori.adventure.text.format.TextFormat;
import net.kyori.adventure.text.format.c;
import net.kyori.adventure.util.HSVLike;
import net.kyori.adventure.util.RGBLike;
import org.jetbrains.annotations.Range;

public interface TextColor
extends Comparable<TextColor>,
b,
StyleBuilderApplicable,
TextFormat,
RGBLike {
    public static final char HEX_CHARACTER = '#';
    public static final String HEX_PREFIX = "#";

    public static TextColor color(int value) {
        int n2 = value & 0xFFFFFF;
        NamedTextColor namedTextColor = NamedTextColor.namedColor(n2);
        if (namedTextColor != null) {
            return namedTextColor;
        }
        return new c(n2);
    }

    public static TextColor color(RGBLike rgb) {
        RGBLike rGBLike;
        if (rgb instanceof TextColor) {
            return (TextColor)rgb;
        }
        return TextColor.color(rgb.red(), rgb.green(), rGBLike.blue());
    }

    public static TextColor color(HSVLike hsv) {
        HSVLike hSVLike;
        float f2 = hsv.s();
        float f3 = hsv.v();
        if (f2 == 0.0f) {
            float f4 = f3;
            return TextColor.color(f4, f4, f3);
        }
        float f5 = hSVLike.h() * 6.0f;
        int n2 = (int)Math.floor(f5);
        float f6 = f3 * (1.0f - f2);
        float f7 = f3 * (1.0f - f2 * (f5 -= (float)n2));
        f5 = f3 * (1.0f - f2 * (1.0f - f5));
        if (n2 == 0) {
            return TextColor.color(f3, f5, f6);
        }
        if (n2 == 1) {
            return TextColor.color(f7, f3, f6);
        }
        if (n2 == 2) {
            return TextColor.color(f6, f3, f5);
        }
        if (n2 == 3) {
            return TextColor.color(f6, f7, f3);
        }
        if (n2 == 4) {
            return TextColor.color(f5, f6, f3);
        }
        return TextColor.color(f3, f6, f7);
    }

    /*
     * WARNING - void declaration
     */
    public static TextColor color(@Range(from=0L, to=255L) int r2, @Range(from=0L, to=255L) int g2, @Range(from=0L, to=255L) int b2) {
        void var2_2;
        void var1_1;
        return TextColor.color((r2 & 0xFF) << 16 | (var1_1 & 0xFF) << 8 | var2_2 & 0xFF);
    }

    /*
     * WARNING - void declaration
     */
    public static TextColor color(float r2, float g2, float b2) {
        void var2_2;
        void var1_1;
        return TextColor.color((int)(r2 * 255.0f), (int)(var1_1 * 255.0f), (int)(var2_2 * 255.0f));
    }

    public static TextColor fromHexString(String string) {
        if (string.startsWith(HEX_PREFIX)) {
            try {
                String string2;
                int n2 = Integer.parseInt(string2.substring(1), 16);
                return TextColor.color(n2);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return null;
    }

    public static TextColor fromCSSHexString(String string) {
        if (string.startsWith(HEX_PREFIX)) {
            int n2;
            String string2;
            if ((string2 = string2.substring(1)).length() != 3 && string2.length() != 6) {
                return null;
            }
            try {
                n2 = Integer.parseInt(string2, 16);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            if (string2.length() == 6) {
                return TextColor.color(n2);
            }
            int n3 = (n2 & 0xF00) >> 8 | (n2 & 0xF00) >> 4;
            int n4 = (n2 & 0xF0) >> 4 | n2 & 0xF0;
            n2 = (n2 & 0xF) << 4 | n2 & 0xF;
            return TextColor.color(n3, n4, n2);
        }
        return null;
    }

    public int value();

    default public String asHexString() {
        return String.format("%c%06x", Character.valueOf('#'), this.value());
    }

    @Override
    default public @Range(from=0L, to=255L) int red() {
        return this.value() >> 16 & 0xFF;
    }

    @Override
    default public @Range(from=0L, to=255L) int green() {
        return this.value() >> 8 & 0xFF;
    }

    @Override
    default public @Range(from=0L, to=255L) int blue() {
        return this.value() & 0xFF;
    }

    /*
     * WARNING - void declaration
     */
    public static TextColor lerp(float t2, RGBLike a2, RGBLike b2) {
        void var2_3;
        void var1_1;
        float f2;
        f2 = Math.min(1.0f, Math.max(0.0f, f2));
        int n2 = a2.red();
        int n3 = b2.red();
        int n4 = a2.green();
        int n5 = b2.green();
        int n6 = var1_1.blue();
        int n7 = var2_3.blue();
        return TextColor.color(Math.round((float)n2 + f2 * (float)(n3 - n2)), Math.round((float)n4 + f2 * (float)(n5 - n4)), Math.round((float)n6 + f2 * (float)(n7 - n6)));
    }

    public static <C extends TextColor> C nearestColorTo(List<C> values, TextColor any) {
        Objects.requireNonNull(any, "color");
        float f2 = Float.MAX_VALUE;
        TextColor textColor = (TextColor)values.get(0);
        int n2 = values.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            float f3;
            TextColor textColor2 = (TextColor)values.get(i2);
            HSVLike hSVLike = textColor2.asHSV();
            HSVLike hSVLike2 = any.asHSV();
            float f4 = 3.0f * Math.min(Math.abs(hSVLike2.h() - hSVLike.h()), 1.0f - Math.abs(hSVLike2.h() - hSVLike.h()));
            float f5 = hSVLike2.s() - hSVLike.s();
            float f6 = hSVLike2.v() - hSVLike.v();
            float f7 = f4;
            float f8 = f5;
            float f9 = f6;
            f6 = f7 * f7 + f8 * f8 + f9 * f9;
            if (f3 < f2) {
                textColor = textColor2;
                f2 = f6;
            }
            if (f6 == 0.0f) break;
        }
        return (C)textColor;
    }

    @Override
    default public void styleApply(Style.Builder style) {
        style.color(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    default public int compareTo(TextColor that) {
        void var1_1;
        return Integer.compare(this.value(), var1_1.value());
    }

    @Override
    default public Stream<? extends net.kyori.a.c> examinableProperties() {
        return Stream.of(net.kyori.a.c.a("value", this.asHexString()));
    }
}

