/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.JsonElement;
import com.google.gson.internal.LazilyParsedNumber;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;

public final class JsonPrimitive
extends JsonElement {
    private final Object a;

    /*
     * WARNING - void declaration
     */
    public JsonPrimitive(Boolean bool) {
        void var1_1;
        this.a = Objects.requireNonNull(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public JsonPrimitive(Number number) {
        void var1_1;
        this.a = Objects.requireNonNull(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public JsonPrimitive(String string) {
        void var1_1;
        this.a = Objects.requireNonNull(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public JsonPrimitive(Character c2) {
        void var1_1;
        this.a = ((Character)Objects.requireNonNull(var1_1)).toString();
    }

    @Override
    public final JsonPrimitive deepCopy() {
        return this;
    }

    public final boolean isBoolean() {
        return this.a instanceof Boolean;
    }

    @Override
    public final boolean getAsBoolean() {
        if (this.isBoolean()) {
            return (Boolean)this.a;
        }
        return Boolean.parseBoolean(((JsonElement)this).getAsString());
    }

    public final boolean isNumber() {
        return this.a instanceof Number;
    }

    @Override
    public final Number getAsNumber() {
        if (this.a instanceof Number) {
            return (Number)this.a;
        }
        if (this.a instanceof String) {
            return new LazilyParsedNumber((String)this.a);
        }
        throw new UnsupportedOperationException("Primitive is neither a number nor a string");
    }

    public final boolean isString() {
        return this.a instanceof String;
    }

    @Override
    public final String getAsString() {
        if (this.a instanceof String) {
            return (String)this.a;
        }
        if (this.isNumber()) {
            return ((JsonElement)this).getAsNumber().toString();
        }
        if (this.isBoolean()) {
            return ((Boolean)this.a).toString();
        }
        throw new AssertionError((Object)("Unexpected value type: " + this.a.getClass()));
    }

    @Override
    public final double getAsDouble() {
        if (this.isNumber()) {
            return ((JsonElement)this).getAsNumber().doubleValue();
        }
        return Double.parseDouble(((JsonElement)this).getAsString());
    }

    @Override
    public final BigDecimal getAsBigDecimal() {
        if (this.a instanceof BigDecimal) {
            return (BigDecimal)this.a;
        }
        return new BigDecimal(((JsonElement)this).getAsString());
    }

    @Override
    public final BigInteger getAsBigInteger() {
        if (this.a instanceof BigInteger) {
            return (BigInteger)this.a;
        }
        return new BigInteger(((JsonElement)this).getAsString());
    }

    @Override
    public final float getAsFloat() {
        if (this.isNumber()) {
            return ((JsonElement)this).getAsNumber().floatValue();
        }
        return Float.parseFloat(((JsonElement)this).getAsString());
    }

    @Override
    public final long getAsLong() {
        if (this.isNumber()) {
            return ((JsonElement)this).getAsNumber().longValue();
        }
        return Long.parseLong(((JsonElement)this).getAsString());
    }

    @Override
    public final short getAsShort() {
        if (this.isNumber()) {
            return ((JsonElement)this).getAsNumber().shortValue();
        }
        return Short.parseShort(((JsonElement)this).getAsString());
    }

    @Override
    public final int getAsInt() {
        if (this.isNumber()) {
            return ((JsonElement)this).getAsNumber().intValue();
        }
        return Integer.parseInt(((JsonElement)this).getAsString());
    }

    @Override
    public final byte getAsByte() {
        if (this.isNumber()) {
            return ((JsonElement)this).getAsNumber().byteValue();
        }
        return Byte.parseByte(((JsonElement)this).getAsString());
    }

    @Override
    @Deprecated
    public final char getAsCharacter() {
        String string = ((JsonElement)this).getAsString();
        if (string.isEmpty()) {
            throw new UnsupportedOperationException("String value is empty");
        }
        return string.charAt(0);
    }

    public final int hashCode() {
        if (this.a == null) {
            return 31;
        }
        if (JsonPrimitive.a(this)) {
            long l2 = ((JsonElement)this).getAsNumber().longValue();
            return (int)(l2 ^ l2 >>> 32);
        }
        if (this.a instanceof Number) {
            long l3 = Double.doubleToLongBits(((JsonElement)this).getAsNumber().doubleValue());
            return (int)(l3 ^ l3 >>> 32);
        }
        return this.a.hashCode();
    }

    public final boolean equals(Object obj) {
        JsonPrimitive jsonPrimitive;
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        jsonPrimitive = jsonPrimitive;
        if (this.a == null) {
            return jsonPrimitive.a == null;
        }
        if (JsonPrimitive.a(this) && JsonPrimitive.a(jsonPrimitive)) {
            return ((JsonElement)this).getAsNumber().longValue() == ((JsonElement)jsonPrimitive).getAsNumber().longValue();
        }
        if (this.a instanceof Number && jsonPrimitive.a instanceof Number) {
            double d2;
            double d3 = ((JsonElement)this).getAsNumber().doubleValue();
            return d3 == (d2 = ((JsonElement)jsonPrimitive).getAsNumber().doubleValue()) || Double.isNaN(d3) && Double.isNaN(d2);
        }
        return this.a.equals(jsonPrimitive.a);
    }

    private static boolean a(JsonPrimitive object) {
        if (((JsonPrimitive)object).a instanceof Number) {
            object = (Number)((JsonPrimitive)object).a;
            return object instanceof BigInteger || object instanceof Long || object instanceof Integer || object instanceof Short || object instanceof Byte;
        }
        return false;
    }
}

