/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.JavaVersion;
import com.google.gson.internal.PreJava9DateFormatProvider;
import com.google.gson.internal.bind.util.ISO8601Utils;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public final class DateTypeAdapter
extends TypeAdapter<Date> {
    public static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

        @Override
        public final <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            if (typeToken.getRawType() == Date.class) {
                return new DateTypeAdapter();
            }
            return null;
        }
    };
    private final List<DateFormat> a = new ArrayList<DateFormat>();

    public DateTypeAdapter() {
        this.a.add(DateFormat.getDateTimeInstance(2, 2, Locale.US));
        if (!Locale.getDefault().equals(Locale.US)) {
            this.a.add(DateFormat.getDateTimeInstance(2, 2));
        }
        if (JavaVersion.isJava9OrLater()) {
            this.a.add(PreJava9DateFormatProvider.getUSDateTimeFormat(2, 2));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Date read(JsonReader in) {
        void var1_1;
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        return this.a((JsonReader)var1_1);
    }

    private Date a(JsonReader jsonReader) {
        String string = jsonReader.nextString();
        List<DateFormat> list = this.a;
        synchronized (list) {
            for (DateFormat dateFormat : this.a) {
                try {
                    return dateFormat.parse(string);
                }
                catch (ParseException parseException) {
                }
            }
            try {
                return ISO8601Utils.parse(string, new ParsePosition(0));
            }
            catch (ParseException parseException) {
                throw new JsonSyntaxException("Failed parsing '" + string + "' as Date; at path " + jsonReader.getPreviousPath(), parseException);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void write(JsonWriter out, Date value) {
        void var1_1;
        String string;
        if (value == null) {
            out.nullValue();
            return;
        }
        DateFormat dateFormat = this.a.get(0);
        List<DateFormat> list = this.a;
        synchronized (list) {
            string = dateFormat.format((Date)((Object)string));
        }
        var1_1.value(string);
    }
}

