/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.reflect;

import com.google.gson.JsonIOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ReflectionHelper {
    private static final a a;

    private ReflectionHelper() {
    }

    public static void makeAccessible(AccessibleObject object) {
        try {
            object.setAccessible(true);
            return;
        }
        catch (Exception exception) {
            String string;
            string = ReflectionHelper.getAccessibleObjectDescription((AccessibleObject)((Object)string), false);
            throw new JsonIOException("Failed making " + (String)string + " accessible; either increase its visibility or write a custom TypeAdapter for its declaring type.", exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String getAccessibleObjectDescription(AccessibleObject object, boolean uppercaseFirstLetter) {
        void var1_1;
        Object object2;
        if (object instanceof Field) {
            object2 = "field '" + ReflectionHelper.fieldToString((Field)object) + "'";
        } else if (object2 instanceof Method) {
            object2 = (Method)object2;
            CharSequence charSequence = new StringBuilder(((Method)object2).getName());
            ReflectionHelper.a((AccessibleObject)object2, charSequence);
            charSequence = charSequence.toString();
            object2 = "method '" + ((Method)object2).getDeclaringClass().getName() + "#" + (String)charSequence + "'";
        } else {
            object2 = object2 instanceof Constructor ? "constructor '" + ReflectionHelper.constructorToString((Constructor)object2) + "'" : "<unknown AccessibleObject> " + object2.toString();
        }
        if (var1_1 != false && Character.isLowerCase(((String)object2).charAt(0))) {
            object2 = Character.toUpperCase(((String)object2).charAt(0)) + ((String)object2).substring(1);
        }
        return object2;
    }

    public static String fieldToString(Field field) {
        Field field2;
        return field.getDeclaringClass().getName() + "#" + field2.getName();
    }

    public static String constructorToString(Constructor<?> constructor) {
        Constructor<?> constructor2;
        StringBuilder stringBuilder = new StringBuilder(constructor.getDeclaringClass().getName());
        ReflectionHelper.a(constructor2, stringBuilder);
        return stringBuilder.toString();
    }

    private static void a(AccessibleObject classArray, StringBuilder stringBuilder) {
        stringBuilder.append('(');
        classArray = classArray instanceof Method ? ((Method)classArray).getParameterTypes() : ((Constructor)classArray).getParameterTypes();
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(classArray[i2].getSimpleName());
        }
        stringBuilder.append(')');
    }

    public static String tryMakeAccessible(Constructor<?> constructor) {
        try {
            constructor.setAccessible(true);
            return null;
        }
        catch (Exception exception) {
            Constructor<?> constructor2;
            return "Failed making constructor '" + ReflectionHelper.constructorToString(constructor2) + "' accessible; either increase its visibility or write a custom InstanceCreator or TypeAdapter for its declaring type: " + exception.getMessage();
        }
    }

    public static boolean isRecord(Class<?> raw) {
        Class<?> clazz;
        return a.a(clazz);
    }

    public static String[] getRecordComponentNames(Class<?> raw) {
        Class<?> clazz;
        return a.b(clazz);
    }

    /*
     * WARNING - void declaration
     */
    public static Method getAccessor(Class<?> raw, Field field) {
        void var1_1;
        Class<?> clazz;
        return a.a(clazz, (Field)var1_1);
    }

    public static <T> Constructor<T> getCanonicalRecordConstructor(Class<T> raw) {
        Class<T> clazz;
        return a.c(clazz);
    }

    public static RuntimeException createExceptionForUnexpectedIllegalAccess(IllegalAccessException exception) {
        IllegalAccessException illegalAccessException;
        throw new RuntimeException("Unexpected IllegalAccessException occurred (Gson 2.10.1). Certain ReflectionAccessFilter features require Java >= 9 to work correctly. If you are not using ReflectionAccessFilter, report this to the Gson maintainers.", illegalAccessException);
    }

    static /* synthetic */ RuntimeException a(ReflectiveOperationException reflectiveOperationException) {
        throw new RuntimeException("Unexpected ReflectiveOperationException occurred (Gson 2.10.1). To support Java records, reflection is utilized to read out information about records. All these invocations happens after it is established that records exist in the JVM. This exception is unexpected behavior.", reflectiveOperationException);
    }

    static {
        a a2;
        try {
            a2 = new c(0);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            a2 = new b(0);
        }
        a = a2;
    }

    private static final class b
    extends a {
        private b() {
            super((byte)0);
        }

        @Override
        final boolean a(Class<?> clazz) {
            return false;
        }

        @Override
        final String[] b(Class<?> clazz) {
            throw new UnsupportedOperationException("Records are not supported on this JVM, this method should not be called");
        }

        @Override
        final <T> Constructor<T> c(Class<T> clazz) {
            throw new UnsupportedOperationException("Records are not supported on this JVM, this method should not be called");
        }

        @Override
        public final Method a(Class<?> clazz, Field field) {
            throw new UnsupportedOperationException("Records are not supported on this JVM, this method should not be called");
        }

        /* synthetic */ b(byte by) {
            this();
        }
    }

    private static final class c
    extends a {
        private final Method a = Class.class.getMethod("isRecord", new Class[0]);
        private final Method b = Class.class.getMethod("getRecordComponents", new Class[0]);
        private final Method c;
        private final Method d;

        private c() {
            super((byte)0);
            Class<?> clazz = this.b.getReturnType().getComponentType();
            this.c = clazz.getMethod("getName", new Class[0]);
            this.d = clazz.getMethod("getType", new Class[0]);
        }

        @Override
        final boolean a(Class<?> serializable) {
            try {
                return (Boolean)this.a.invoke(serializable, new Object[0]);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                serializable = reflectiveOperationException;
                throw ReflectionHelper.a(reflectiveOperationException);
            }
        }

        @Override
        final String[] b(Class<?> objectArray) {
            try {
                objectArray = (Object[])this.b.invoke(objectArray, new Object[0]);
                String[] stringArray = new String[objectArray.length];
                for (int i2 = 0; i2 < objectArray.length; ++i2) {
                    stringArray[i2] = (String)this.c.invoke(objectArray[i2], new Object[0]);
                }
                return stringArray;
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                objectArray = reflectiveOperationException;
                throw ReflectionHelper.a(reflectiveOperationException);
            }
        }

        @Override
        public final <T> Constructor<T> c(Class<T> clazz) {
            try {
                Object[] objectArray = (Object[])this.b.invoke(clazz, new Object[0]);
                Class[] classArray = new Class[objectArray.length];
                for (int i2 = 0; i2 < objectArray.length; ++i2) {
                    classArray[i2] = (Class)this.d.invoke(objectArray[i2], new Object[0]);
                }
                return clazz.getDeclaredConstructor(classArray);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                ReflectiveOperationException reflectiveOperationException2 = reflectiveOperationException;
                throw ReflectionHelper.a(reflectiveOperationException);
            }
        }

        @Override
        public final Method a(Class<?> serializable, Field field) {
            try {
                return serializable.getMethod(field.getName(), new Class[0]);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                serializable = reflectiveOperationException;
                throw ReflectionHelper.a(reflectiveOperationException);
            }
        }

        /* synthetic */ c(byte by) {
            this();
        }
    }

    private static abstract class a {
        private a() {
        }

        abstract boolean a(Class<?> var1);

        abstract String[] b(Class<?> var1);

        abstract <T> Constructor<T> c(Class<T> var1);

        public abstract Method a(Class<?> var1, Field var2);

        /* synthetic */ a(byte by) {
            this();
        }
    }
}

